# 画面設計書 242-タスク詳細

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タスク詳細」画面の設計書です。

### 本画面の処理概要

本画面は、タスクの詳細情報を参照するための画面です。タスクの基本情報、プロジェクト情報、時間追跡情報、レコード情報、統計情報などを一覧表示し、タスクの全体像を把握することができます。

**業務上の目的・背景**：プロジェクト管理において、タスクの詳細情報を素早く確認することは、進捗管理や作業計画において重要です。担当者、期限、進捗状況、関連するプロジェクトやマイルストーンなど、タスクに関するあらゆる情報を一画面で確認できることで、意思決定の迅速化と業務効率の向上を実現します。

**画面へのアクセス方法**：
1. サイドメニューから「プロジェクト」→「タスク」を選択
2. タスク一覧画面で確認したいタスクの行をクリック、または行アクションメニューから「表示」を選択
3. または、他の画面からタスクへのリンクをクリック

**主要な操作・処理内容**：
1. タスクの基本情報（タイトル、状態、優先度、説明、タグ）の確認
2. プロジェクト情報（プロジェクト名、マイルストーン、ステージ、顧客、担当者、期限）の確認
3. 時間追跡情報（割り当て時間、使用時間、残り時間、進捗率）の確認
4. レコード情報（作成日時、作成者、更新日時）の確認
5. 統計情報（サブタスク数、タイムシートエントリ数）の確認
6. Chatterアクションによるコメント・アクティビティの管理
7. タスクの削除

**画面遷移**：
- 遷移元：タスク一覧画面、プロジェクト詳細画面、他画面からのリンク
- 遷移先：タスク編集画面、タイムシート管理画面、サブタスク管理画面、プロジェクト詳細画面

**権限による表示制御**：
- タスクの閲覧権限を持つユーザーのみアクセス可能
- マイルストーン情報はTaskSettings.enable_milestonesが有効な場合のみ表示
- 時間追跡セクションはTimeSettings.enable_timesheetsが有効な場合のみ表示
- タイムシートエントリ数はTimeSettings.enable_timesheetsが有効な場合のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-011 | タスク表示 | 主機能 | タスク詳細情報の表示 |
| FN-PROJ-008 | タスク一覧 | 遷移元機能 | タスク一覧から詳細画面へのアクセス |
| FN-PROJ-010 | タスク編集 | 遷移先機能 | 詳細画面から編集画面への遷移 |
| FN-PROJ-004 | プロジェクト表示 | 遷移先機能 | プロジェクト名クリックで遷移 |

## 画面種別

詳細

## URL/ルーティング

`/admin/project/tasks/{record}`

## 画面構成

- ヘッダーアクション
  - Chatterアクション（コメント・アクティビティ管理）
  - 削除アクション
- サブナビゲーション（Top位置）
  - 詳細、編集、タイムシート、サブタスク
- メインコンテンツ（3カラムレイアウト）
  - 左側2カラム
    - 一般情報セクション
      - タイトル表示
      - 状態バッジ
      - 優先度アイコン
      - 説明表示
      - タグ一覧
    - プロジェクト情報セクション
      - プロジェクト名（リンク）
      - マイルストーン名
      - ステージ名
      - 顧客名
      - 担当者一覧
      - 期限
    - 時間追跡セクション（条件付き表示）
      - 割り当て時間
      - 使用時間
      - 残り時間
      - 進捗率
    - 追加情報セクション（カスタムフィールド）
  - 右側1カラム
    - レコード情報セクション
      - 作成日時
      - 作成者
      - 更新日時
    - 統計セクション
      - サブタスク数
      - タイムシートエントリ数

## 入出力項目

本画面は参照専用のため、入力項目はありません。

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| タイトル | task.title | TextEntry (Large, Bold) | - |
| 状態 | task.state | Badge (icon, color) | TaskState enumから変換 |
| 優先度 | task.priority | IconEntry | 星アイコン（黄/灰） |
| 説明 | task.description | HTML | - |
| タグ | task.tags | Badge (色付き) | タグ色を反映 |
| プロジェクト | task.project.name | リンク | フォルダアイコン付き |
| マイルストーン | task.milestone.name | TextEntry | フラグアイコン付き、条件付き表示 |
| ステージ | task.stage.name | Badge | キューアイコン付き |
| 顧客 | task.partner.name | TextEntry | 電話アイコン付き |
| 担当者 | task.users.name | リスト | ユーザーアイコン付き |
| 期限 | task.deadline | 日時 | カレンダーアイコン付き |
| 割り当て時間 | task.allocated_hours | 時:分形式 | 時計アイコン付き、条件付き表示 |
| 使用時間 | task.total_hours_spent | 時:分形式 | 条件付き表示 |
| 残り時間 | task.remaining_hours | 時:分形式 | 色分け（負は赤）、条件付き表示 |
| 進捗率 | task.progress | パーセント | 色分け、条件付き表示 |
| 作成日時 | task.created_at | 日時 | カレンダーアイコン付き |
| 作成者 | task.creator.name | TextEntry | ユーザーアイコン付き |
| 更新日時 | task.updated_at | 日時 | カレンダーアイコン付き |
| サブタスク数 | subTasks()->count() | 数値 | クリップボードアイコン付き |
| タイムシートエントリ数 | timesheets()->count() | 数値 | 時計アイコン付き、条件付き表示 |

## イベント仕様

### 1-削除アクション

ヘッダーの削除アクションをクリックすると、確認後にタスクを論理削除します。

処理フロー：
1. 確認ダイアログ表示
2. 確認後、projects_tasksテーブルのdeleted_atを更新
3. 成功通知の表示
4. 一覧画面へリダイレクト

### 2-Chatterアクション

コメントの追加やアクティビティプランの実行が可能です。

### 3-プロジェクトリンククリック

プロジェクト名をクリックすると、該当プロジェクトの詳細画面に遷移します。

### 4-サブナビゲーション操作

各タブをクリックすることで、編集画面、タイムシート管理画面、サブタスク管理画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | projects_tasks | SELECT | タスク情報の取得 |
| 画面表示 | projects_projects | SELECT | プロジェクト情報の取得 |
| 画面表示 | projects_milestones | SELECT | マイルストーン情報の取得 |
| 画面表示 | projects_task_stages | SELECT | ステージ情報の取得 |
| 画面表示 | partners | SELECT | 顧客情報の取得 |
| 画面表示 | users | SELECT | ユーザー情報の取得 |
| 削除アクション | projects_tasks | SOFT DELETE | タスクの論理削除 |

### テーブル別更新項目詳細

#### projects_tasks（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（削除） | タスクが正常に削除されました | 削除成功時 |
| プレースホルダー | — | 値が未設定の項目 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| レコード未存在 | 404エラーページ表示 | ページが見つかりません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 論理削除済み | 404エラーページ表示 | ページが見つかりません |

## 備考

- ViewRecordクラスを継承したFilament標準の詳細画面実装
- InfolistコンポーネントによるReadOnly表示
- 時間の表示は「時:分」形式（例：8:30）
- 進捗率は100%超過で赤色、100%未満で黄色、100%で緑色表示
- 残り時間がマイナスの場合は赤色で表示
- プロジェクト名はリンクとして機能し、クリックでプロジェクト詳細画面に遷移
- カスタムフィールド機能により、追加フィールドの表示が可能
