# 画面設計書 243-サブタスク管理

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「サブタスク管理」画面の設計書です。

### 本画面の処理概要

本画面は、親タスクに紐づくサブタスクを管理するための画面です。サブタスクの一覧表示、新規作成、表示、編集、削除、復元、完全削除などの操作を行うことができます。

**業務上の目的・背景**：複雑なタスクを管理する際、タスクを小さなサブタスクに分割することで、作業の進捗管理が容易になります。本画面は、親タスクとサブタスクの階層構造を維持しながら、効率的にサブタスクを管理するためのインターフェースを提供します。WBS（Work Breakdown Structure）的なタスク分解を実現し、プロジェクト管理の精度向上に貢献します。

**画面へのアクセス方法**：
1. サイドメニューから「プロジェクト」→「タスク」を選択
2. タスク一覧画面で親タスクを選択
3. タスク詳細画面または編集画面のサブナビゲーションから「サブタスク」タブを選択

**主要な操作・処理内容**：
1. サブタスク一覧の表示（テーブル形式）
2. サブタスクの新規作成（親タスクの情報を継承）
3. サブタスクの詳細表示（別画面へ遷移）
4. サブタスクの編集（別画面へ遷移）
5. サブタスクの論理削除
6. 論理削除されたサブタスクの復元
7. サブタスクの完全削除
8. 削除済みフィルタの切り替え

**画面遷移**：
- 遷移元：タスク詳細画面、タスク編集画面
- 遷移先：サブタスク詳細画面、サブタスク編集画面

**権限による表示制御**：
- タスクの閲覧権限を持つユーザーがアクセス可能
- 作成・編集・削除権限に応じてアクションの表示/非表示が制御される
- 論理削除されたレコードでは表示・編集アクションが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-011 | タスク表示 | 遷移元機能 | 詳細画面からのアクセス |
| FN-PROJ-010 | タスク編集 | 遷移元機能 | 編集画面からのアクセス |
| FN-PROJ-009 | タスク作成 | 関連機能 | サブタスク作成時のフォーム |
| FN-PROJ-008 | タスク一覧 | 関連機能 | サブタスク一覧表示のテーブル定義 |

## 画面種別

関連レコード管理

## URL/ルーティング

`/admin/project/tasks/{record}/sub-tasks`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細、編集、タイムシート、サブタスク（アクティブ）
- ヘッダーアクション
  - サブタスク作成ボタン
- テーブルエリア
  - フィルタ（ドロップダウン形式）
    - 削除済みフィルタ（TrashedFilter）
  - テーブル本体（TaskResourceのテーブル定義を継承）
  - 行アクション
    - 表示（遷移）
    - 編集（遷移）
    - 復元
    - 削除
    - 完全削除

## 入出力項目

### 作成モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| ステージ | stage_id | integer | Yes | ProgressStepper | 初期値：最初のTaskStage |
| タイトル | title | string | Yes | テキスト入力 | 最大255文字 |
| 状態 | state | enum | Yes | ToggleButtons | 初期値：IN_PROGRESS |
| タグ | tags | array | No | 複数選択 | - |
| 説明 | description | text | No | RichEditor | - |
| プロジェクト | project_id | integer | No | 選択 | 親タスクから継承 |
| マイルストーン | milestone_id | integer | No | 選択 | 親タスクから継承 |
| 顧客 | partner_id | integer | No | 選択 | 親タスクから継承 |
| 担当者 | users | array | No | 複数選択 | 親タスクから継承 |
| 期限 | deadline | datetime | No | 日時ピッカー | - |
| 割り当て時間 | allocated_hours | float | No | 数値入力 | 条件付き表示 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| ID | task.id | テキスト | 非表示（デフォルト） |
| 優先度 | task.priority | アイコン | 星アイコン（クリックで切替） |
| 状態 | task.state | アイコン | クリックで状態変更モーダル |
| タイトル | task.title | テキスト | 検索・ソート可能 |
| プロジェクト | task.project.name | テキスト | 非表示 |
| マイルストーン | task.milestone.name | テキスト | 非表示（デフォルト）、条件付き |
| 顧客 | task.partner.name | テキスト | 非表示（デフォルト） |
| 担当者 | task.users.name | テキスト | 検索・ソート可能 |
| 割り当て時間 | task.allocated_hours | 時:分 | 非表示（デフォルト）、条件付き |
| 使用時間 | task.total_hours_spent | 時:分 | 条件付き |
| 残り時間 | task.remaining_hours | 時:分 | 非表示（デフォルト）、条件付き |
| 進捗 | task.progress | プログレスバー | 条件付き |
| 期限 | task.deadline | 日時 | ソート可能 |
| タグ | task.tags.name | バッジ | 色付き |
| ステージ | task.stage.name | テキスト | ソート可能 |

## イベント仕様

### 1-サブタスク作成ボタン押下

モーダルダイアログが開き、新規サブタスクの情報を入力できます。親タスクの情報（プロジェクト、マイルストーン、顧客、担当者）が初期値として設定されます。

処理フロー：
1. モーダル表示（6xl幅）
2. 親タスクの情報で初期値設定
3. フォーム入力
4. 保存時にcreator_idを現在ユーザーに設定
5. projects_tasksテーブルにINSERT（parent_idに親タスクID）
6. 成功通知表示
7. テーブル更新

### 2-表示アクション

サブタスクの詳細画面（ViewTask）に遷移します。論理削除されたレコードでは非表示。

### 3-編集アクション

サブタスクの編集画面（EditTask）に遷移します。論理削除されたレコードでは非表示。

### 4-削除アクション

サブタスクを論理削除します。

### 5-復元アクション

論理削除されたサブタスクを復元します。

### 6-完全削除アクション

サブタスクをデータベースから完全に削除します。

### 7-優先度アイコンクリック

優先度のON/OFFを切り替えます。

### 8-状態アイコンクリック

状態変更モーダルが表示され、新しい状態を選択できます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_tasks | INSERT | サブタスクの作成 |
| 作成ボタン押下 | projects_task_tag | INSERT | タグ関連の作成 |
| 作成ボタン押下 | projects_task_users | INSERT | 担当者関連の作成 |
| 削除アクション | projects_tasks | SOFT DELETE | サブタスクの論理削除 |
| 復元アクション | projects_tasks | UPDATE | deleted_atをnullに |
| 完全削除アクション | projects_tasks | DELETE | サブタスクの物理削除 |

### テーブル別更新項目詳細

#### projects_tasks（作成時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | フォーム入力値 | 必須 |
| INSERT | state | IN_PROGRESS（初期値） | TaskState enum |
| INSERT | stage_id | 最初のTaskStage ID | 初期値 |
| INSERT | project_id | 親タスクのproject_id | 継承 |
| INSERT | milestone_id | 親タスクのmilestone_id | 継承 |
| INSERT | partner_id | 親タスクのpartner_id | 継承 |
| INSERT | parent_id | 親タスクのID | 必須 |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | created_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | サブタスクが正常に作成されました | 作成成功時 |
| 成功通知（削除） | サブタスクが正常に削除されました | 削除成功時 |
| 成功通知（復元） | サブタスクが正常に復元されました | 復元成功時 |
| 成功通知（完全削除） | サブタスクが完全に削除されました | 完全削除成功時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 親レコード未存在 | 404エラーページ表示 | ページが見つかりません |
| 権限不足 | アクション非表示 | - |
| 外部キー制約違反 | エラー通知表示 | 関連データがあるため削除できません |

## 備考

- ManageRelatedRecordsクラスを継承したFilament標準の関連レコード管理画面実装
- subTasksリレーションシップを使用（parent_idでの親子関係）
- テーブル定義はTaskResource::table()を継承して使用
- フォーム定義はTaskResource::form()を継承して使用
- Infolist定義はTaskResource::infolist()を継承して使用
- グルーピング機能は無効化されている（groups([])）
- ナビゲーションアイコンはclipboard-document-list
- 作成モーダルは6xl幅で表示
- 担当者は親タスクの担当者配列を初期値として設定
