# 画面設計書 244-タイムシート管理

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タイムシート管理」画面の設計書です。

### 本画面の処理概要

本画面は、タスクに紐づくタイムシート（作業時間記録）を管理するための画面です。タイムシートエントリの一覧表示、新規作成、編集、削除などの操作を行い、タスクにかかった作業時間を追跡・管理することができます。

**業務上の目的・背景**：プロジェクト管理において、作業時間の正確な記録と追跡は、コスト管理、リソース配分、生産性分析において極めて重要です。本画面は、タスク単位での作業時間入力を可能にし、時間集計機能により使用時間、サブタスク時間、合計時間、残り時間を自動計算します。これにより、プロジェクトの進捗状況とリソース消費を可視化し、適切なプロジェクト管理を支援します。

**画面へのアクセス方法**：
1. サイドメニューから「プロジェクト」→「タスク」を選択
2. タスク一覧画面でタスクを選択
3. タスク詳細画面または編集画面のサブナビゲーションから「タイムシート」タブを選択

**主要な操作・処理内容**：
1. タイムシートエントリ一覧の表示（テーブル形式）
2. タイムシートエントリの新規作成
3. タイムシートエントリの編集
4. タイムシートエントリの削除
5. 時間集計の表示（使用時間、サブタスク時間、合計時間、残り時間）

**画面遷移**：
- 遷移元：タスク詳細画面、タスク編集画面
- 遷移先：なし（同一画面内でモーダル操作）

**権限による表示制御**：
- タスクの閲覧権限を持つユーザーがアクセス可能
- TimeSettings.enable_timesheetsが有効な場合のみアクセス可能
- プロジェクトが設定されている場合、project.allow_timesheetsが有効な場合のみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-011 | タスク表示 | 遷移元機能 | 詳細画面からのアクセス |
| FN-PROJ-010 | タスク編集 | 遷移元機能 | 編集画面からのアクセス |
| FN-TS-002 | タイムシート作成 | 関連機能 | タイムシートエントリの作成 |
| FN-TS-003 | タイムシート編集 | 関連機能 | タイムシートエントリの編集 |

## 画面種別

関連レコード管理

## URL/ルーティング

`/admin/project/tasks/{record}/timesheets`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細、編集、タイムシート（アクティブ）、サブタスク
- ヘッダーアクション
  - タイムシート作成ボタン
- テーブルエリア
  - テーブル本体（ページネーションなし）
    - 日付
    - 従業員
    - 説明
    - 使用時間（サマリー付き）
  - サマリー行
    - 使用時間合計
    - サブタスク使用時間合計
    - 総使用時間
    - 残り時間（割り当て時間設定時のみ）
  - 行アクション
    - 編集
    - 削除

## 入出力項目

### 作成/編集モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| タイプ | type | string | No | Hidden | 固定値「projects」 |
| 日付 | date | date | Yes | 日付ピッカー | ネイティブ無効 |
| 従業員 | user_id | integer | Yes | 選択 | ユーザーから選択 |
| 説明 | name | string | No | テキスト入力 | 作業内容の説明 |
| 使用時間 | unit_amount | float | Yes | 数値入力 | 0-99999999999、時間単位 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| 日付 | timesheet.date | Y-m-d形式 | - |
| 従業員 | timesheet.user.name | テキスト | - |
| 説明 | timesheet.name | テキスト | - |
| 使用時間 | timesheet.unit_amount | 時:分形式 | Sum集計あり |
| 使用時間合計 | Sum(unit_amount) | 時:分形式 | サマリー |
| サブタスク使用時間 | task.subtask_effective_hours | 時:分形式 | サマリー |
| 総使用時間 | task.total_hours_spent | 時:分形式 | サマリー |
| 残り時間 | task.remaining_hours | 時:分形式 | サマリー、条件付き表示 |

## イベント仕様

### 1-タイムシート作成ボタン押下

モーダルダイアログが開き、新規タイムシートエントリの情報を入力できます。

処理フロー：
1. モーダル表示
2. フォーム入力
3. 保存時にcreator_id、project_id、partner_idを自動設定
4. projects_timesheetsテーブルにINSERT
5. 成功通知表示
6. テーブル更新

### 2-編集アクション

タイムシートエントリを編集するモーダルが表示されます。

処理フロー：
1. 編集モーダル表示
2. 既存データで初期化
3. フォーム入力
4. 保存時にprojects_timesheetsテーブルをUPDATE
5. 成功通知表示
6. テーブル更新

### 3-削除アクション

タイムシートエントリを削除します。

処理フロー：
1. 確認ダイアログ表示
2. 確認後、projects_timesheetsテーブルからDELETE
3. 成功通知表示
4. テーブル更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_timesheets | INSERT | タイムシートエントリの作成 |
| 編集アクション | projects_timesheets | UPDATE | タイムシートエントリの更新 |
| 削除アクション | projects_timesheets | DELETE | タイムシートエントリの削除 |

### テーブル別更新項目詳細

#### projects_timesheets（作成時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | type | 'projects' | 固定値 |
| INSERT | date | フォーム入力値 | 必須 |
| INSERT | user_id | フォーム選択値 | 必須 |
| INSERT | name | フォーム入力値 | 説明 |
| INSERT | unit_amount | フォーム入力値 | 必須、時間 |
| INSERT | task_id | 親タスクのID | リレーション |
| INSERT | project_id | 親タスクのproject_id | 自動設定 |
| INSERT | partner_id | 親タスクのpartner_id or project.partner_id | 自動設定 |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | created_at | 現在日時 | 自動設定 |

#### projects_timesheets（編集時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | date | フォーム入力値 | - |
| UPDATE | user_id | フォーム選択値 | - |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | unit_amount | フォーム入力値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | タイムシートが正常に作成されました | 作成成功時 |
| 成功通知（編集） | タイムシートが正常に更新されました | 更新成功時 |
| 成功通知（削除） | タイムシートが正常に削除されました | 削除成功時 |
| ヘルパーテキスト | 時間単位で入力してください | 使用時間フィールド |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 親レコード未存在 | 404エラーページ表示 | ページが見つかりません |
| タイムシート機能無効 | 画面アクセス不可 | - |
| プロジェクトのタイムシート不許可 | 画面アクセス不可 | - |
| バリデーションエラー | フォームエラー表示 | 各フィールドにエラーメッセージ |

## 備考

- ManageRelatedRecordsクラスを継承したFilament標準の関連レコード管理画面実装
- timesheetsリレーションシップを使用
- ナビゲーションアイコンはclock
- ページネーションは無効化されている（全件表示）
- canAccessメソッドで以下の条件をチェック：
  1. 親の権限チェック
  2. TimeSettings.enable_timesheetsが有効
  3. プロジェクト未設定、またはproject.allow_timesheetsが有効
- 残り時間サマリーはタスクにallocated_hoursが設定されている場合のみ表示
- partner_idは親タスクのpartner_idまたはプロジェクトのpartner_idを使用
- 時間表示は「時:分」形式（例：8:30 = 8時間30分）
