# 画面設計書 245-タスクステージ管理

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タスクステージ管理」画面の設計書です。

### 本画面の処理概要

本画面は、プロジェクト内のタスクを分類するためのステージ（段階）を管理する設定画面です。タスクステージの一覧表示、新規作成、編集、削除、復元、完全削除、およびドラッグ&ドロップによる順序変更を行うことができます。

**業務上の目的・背景**：タスクステージは、タスクの進行状況を視覚的に管理するための重要な分類軸です。「未着手」「進行中」「レビュー中」「完了」などのステージを定義することで、カンバンボード形式でのタスク管理やタスクの進捗追跡が可能になります。プロジェクトごとに異なるステージ構成を設定できるため、各プロジェクトの特性に応じた柔軟なワークフロー管理を実現します。

**画面へのアクセス方法**：
1. サイドメニューから「設定」→「Projects」→「設定」を選択
2. 設定クラスター内の「タスクステージ」メニューを選択

**主要な操作・処理内容**：
1. タスクステージ一覧の表示（テーブル形式）
2. タブによるフィルタリング（すべて / アーカイブ済み）
3. タスクステージの新規作成
4. タスクステージの編集
5. タスクステージの論理削除（アーカイブ）
6. 論理削除されたステージの復元
7. タスクステージの完全削除
8. ドラッグ&ドロップによる表示順序の変更
9. プロジェクトによるフィルタリング

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：なし（同一画面内でモーダル操作）

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONF-001 | タスクステージ管理 | 主機能 | タスクステージのCRUD操作 |
| FN-PROJ-009 | タスク作成 | 参照機能 | タスク作成時のステージ選択 |
| FN-PROJ-010 | タスク編集 | 参照機能 | タスク編集時のステージ変更 |

## 画面種別

一覧管理（ManageRecords）

## URL/ルーティング

`/admin/settings/projects/task-stages`

## 画面構成

- タブナビゲーション
  - すべて（件数バッジ）
  - アーカイブ済み（件数バッジ）
- ヘッダーアクション
  - 新規作成ボタン
- テーブルエリア
  - フィルタ
    - プロジェクトフィルタ
  - グループ化オプション
    - プロジェクト
    - 作成日
  - テーブル本体（並べ替え可能）
    - 名前
    - プロジェクト
  - 行アクション
    - 編集（非削除レコード）
    - 復元（削除レコード）
    - 削除（非削除レコード）
    - 完全削除（削除レコード）
  - 一括アクション
    - 復元
    - 削除
    - 完全削除

## 入出力項目

### 作成/編集モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 名前 | name | string | Yes | テキスト入力 | 最大255文字 |
| プロジェクト | project_id | integer | Yes | 選択 | 論理削除済みプロジェクトも表示（選択不可） |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| 名前 | task_stage.name | テキスト | 検索・ソート可能 |
| プロジェクト | task_stage.project.name | テキスト | ソート可能 |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが開き、新規タスクステージの情報を入力できます。

処理フロー：
1. モーダル表示
2. フォーム入力
3. 保存時にcreator_idを現在ユーザーに設定
4. projects_task_stagesテーブルにINSERT
5. 成功通知表示
6. テーブル更新

### 2-編集アクション

タスクステージを編集するモーダルが表示されます。論理削除されたレコードでは非表示。

### 3-削除アクション

タスクステージを論理削除（アーカイブ）します。

### 4-復元アクション

論理削除されたタスクステージを復元します。

### 5-完全削除アクション

タスクステージをデータベースから完全に削除します。関連するタスクが存在する場合はエラーになります。

### 6-タブ切り替え

「すべて」タブと「アーカイブ済み」タブを切り替え、表示するレコードをフィルタリングします。

### 7-行ドラッグ&ドロップ

行をドラッグ&ドロップすることで、ステージの表示順序を変更します。sortカラムが更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_task_stages | INSERT | タスクステージの作成 |
| 編集アクション | projects_task_stages | UPDATE | タスクステージの更新 |
| 削除アクション | projects_task_stages | SOFT DELETE | タスクステージの論理削除 |
| 復元アクション | projects_task_stages | UPDATE | deleted_atをnullに |
| 完全削除アクション | projects_task_stages | DELETE | タスクステージの物理削除 |
| ドラッグ&ドロップ | projects_task_stages | UPDATE | sort値の更新 |

### テーブル別更新項目詳細

#### projects_task_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | project_id | フォーム選択値 | 必須 |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | sort | 自動採番 | SortableTrait |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | project_id | フォーム選択値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | タスクステージが正常に作成されました | 作成成功時 |
| 成功通知（編集） | タスクステージが正常に更新されました | 更新成功時 |
| 成功通知（削除） | タスクステージが正常に削除されました | 削除成功時 |
| 成功通知（復元） | タスクステージが正常に復元されました | 復元成功時 |
| 成功通知（完全削除） | タスクステージが完全に削除されました | 完全削除成功時 |
| エラー通知（完全削除） | 関連データがあるため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 外部キー制約違反（完全削除時） | エラー通知表示 | 関連データがあるため削除できません |
| バリデーションエラー | フォームエラー表示 | 各フィールドにエラーメッセージ |

## 備考

- ManageRecordsクラスを継承したFilament標準の一覧管理画面実装
- Configurationsクラスター内に配置
- ナビゲーションアイコンはrectangle-stack
- ナビゲーション順序は2
- reorderable('sort')で行の並べ替えが可能
- defaultSort('sort', 'desc')でソート順の降順表示がデフォルト
- プロジェクト選択では論理削除されたプロジェクトも表示されるが選択不可（Deleted表示）
- 完全削除時はQueryExceptionをキャッチして外部キー制約違反を処理
- タブのバッジにはcount()およびonlyTrashed()->count()で件数を表示
