# 画面設計書 246-プロジェクトステージ管理

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「プロジェクトステージ管理」画面の設計書です。

### 本画面の処理概要

本画面は、プロジェクトを分類するためのステージ（段階）を管理する設定画面です。プロジェクトステージの一覧表示、新規作成、編集、削除、復元、完全削除、およびドラッグ&ドロップによる順序変更を行うことができます。

**業務上の目的・背景**：プロジェクトステージは、プロジェクトの進行状況を管理するための分類軸です。「計画中」「実行中」「レビュー中」「完了」などのステージを定義することで、組織全体のプロジェクトポートフォリオを視覚的に把握し、リソース配分や優先順位付けの判断材料とすることができます。

**画面へのアクセス方法**：
1. サイドメニューから「設定」→「Projects」→「設定」を選択
2. 設定クラスター内の「プロジェクトステージ」メニューを選択

**主要な操作・処理内容**：
1. プロジェクトステージ一覧の表示（テーブル形式）
2. タブによるフィルタリング（すべて / アーカイブ済み）
3. プロジェクトステージの新規作成
4. プロジェクトステージの編集
5. プロジェクトステージの論理削除（アーカイブ）
6. 論理削除されたステージの復元
7. プロジェクトステージの完全削除
8. ドラッグ&ドロップによる表示順序の変更

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：なし（同一画面内でモーダル操作）

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能
- TaskSettings.enable_project_stagesが有効な場合のみメニューに表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONF-002 | プロジェクトステージ管理 | 主機能 | プロジェクトステージのCRUD操作 |
| FN-PROJ-002 | プロジェクト作成 | 参照機能 | プロジェクト作成時のステージ選択 |
| FN-PROJ-003 | プロジェクト編集 | 参照機能 | プロジェクト編集時のステージ変更 |

## 画面種別

一覧管理（ManageRecords）

## URL/ルーティング

`/admin/settings/projects/project-stages`

## 画面構成

- タブナビゲーション
  - すべて（件数バッジ）
  - アーカイブ済み（件数バッジ）
- ヘッダーアクション
  - 新規作成ボタン
- テーブルエリア
  - グループ化オプション
    - 作成日
  - テーブル本体（並べ替え可能）
    - 名前
  - 行アクション
    - 編集（非削除レコード）
    - 復元（削除レコード）
    - 削除（非削除レコード）
    - 完全削除（削除レコード）
  - 一括アクション
    - 復元
    - 削除
    - 完全削除

## 入出力項目

### 作成/編集モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 名前 | name | string | Yes | テキスト入力 | 最大255文字、一意制約 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| 名前 | project_stage.name | テキスト | 検索・ソート可能 |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが開き、新規プロジェクトステージの情報を入力できます。

処理フロー：
1. モーダル表示
2. フォーム入力
3. 保存時にcreator_idを現在ユーザーに設定
4. projects_project_stagesテーブルにINSERT
5. 成功通知表示
6. テーブル更新

### 2-編集アクション

プロジェクトステージを編集するモーダルが表示されます。論理削除されたレコードでは非表示。

### 3-削除アクション

プロジェクトステージを論理削除（アーカイブ）します。

### 4-復元アクション

論理削除されたプロジェクトステージを復元します。

### 5-完全削除アクション

プロジェクトステージをデータベースから完全に削除します。関連するプロジェクトが存在する場合はエラーになります。

### 6-タブ切り替え

「すべて」タブと「アーカイブ済み」タブを切り替え、表示するレコードをフィルタリングします。

### 7-行ドラッグ&ドロップ

行をドラッグ&ドロップすることで、ステージの表示順序を変更します。sortカラムが更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_project_stages | INSERT | プロジェクトステージの作成 |
| 編集アクション | projects_project_stages | UPDATE | プロジェクトステージの更新 |
| 削除アクション | projects_project_stages | SOFT DELETE | プロジェクトステージの論理削除 |
| 復元アクション | projects_project_stages | UPDATE | deleted_atをnullに |
| 完全削除アクション | projects_project_stages | DELETE | プロジェクトステージの物理削除 |
| ドラッグ&ドロップ | projects_project_stages | UPDATE | sort値の更新 |

### テーブル別更新項目詳細

#### projects_project_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須、一意 |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | sort | 自動採番 | SortableTrait |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | 一意（自己除外） |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | プロジェクトステージが正常に作成されました | 作成成功時 |
| 成功通知（編集） | プロジェクトステージが正常に更新されました | 更新成功時 |
| 成功通知（削除） | プロジェクトステージが正常に削除されました | 削除成功時 |
| 成功通知（復元） | プロジェクトステージが正常に復元されました | 復元成功時 |
| 成功通知（完全削除） | プロジェクトステージが完全に削除されました | 完全削除成功時 |
| エラー通知（完全削除） | 関連データがあるため削除できません | 外部キー制約違反時 |
| バリデーションエラー | この名前は既に使用されています | 一意制約違反時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 外部キー制約違反（完全削除時） | エラー通知表示 | 関連データがあるため削除できません |
| 一意制約違反 | フォームエラー表示 | この名前は既に使用されています |

## 備考

- ManageRecordsクラスを継承したFilament標準の一覧管理画面実装
- Configurationsクラスター内に配置
- ナビゲーションアイコンはsquares-2x2
- ナビゲーション順序は1
- reorderable('sort')で行の並べ替えが可能
- defaultSort('sort', 'desc')でソート順の降順表示がデフォルト
- nameフィールドは一意制約（ignoreRecord: true）
- isDiscovered()メソッドでTaskSettings.enable_project_stagesをチェック
- コンソール実行時は常にtrue、それ以外は設定値に従う
- 完全削除時はQueryExceptionをキャッチして外部キー制約違反を処理
- タブのバッジにはcount()およびonlyTrashed()->count()で件数を表示
