# 画面設計書 247-タグ管理

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タグ管理」画面の設計書です。

### 本画面の処理概要

本画面は、タスクに付与するタグを管理する設定画面です。タグの一覧表示、新規作成、編集、削除、復元、完全削除を行うことができます。タグには名前と色を設定でき、タスクの分類やフィルタリングに使用されます。

**業務上の目的・背景**：タグは、タスクを横断的に分類するための柔軟なラベルです。「緊急」「バグ」「機能追加」「ドキュメント」など、プロジェクトやステージとは独立した切り口でタスクを分類することで、特定の種類のタスクを素早く抽出したり、優先度を視覚的に示したりすることができます。タグに色を設定できるため、一覧画面でのタスクの識別が容易になります。

**画面へのアクセス方法**：
1. サイドメニューから「設定」→「Projects」→「設定」を選択
2. 設定クラスター内の「タグ」メニューを選択

**主要な操作・処理内容**：
1. タグ一覧の表示（テーブル形式）
2. タブによるフィルタリング（すべて / アーカイブ済み）
3. タグの新規作成（名前と色）
4. タグの編集
5. タグの論理削除（アーカイブ）
6. 論理削除されたタグの復元
7. タグの完全削除

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：なし（同一画面内でモーダル操作）

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONF-003 | タグ管理 | 主機能 | タグのCRUD操作 |
| FN-PROJ-009 | タスク作成 | 参照機能 | タスク作成時のタグ選択 |
| FN-PROJ-010 | タスク編集 | 参照機能 | タスク編集時のタグ変更 |

## 画面種別

一覧管理（ManageRecords）

## URL/ルーティング

`/admin/settings/projects/tags`

## 画面構成

- タブナビゲーション
  - すべて（件数バッジ）
  - アーカイブ済み（件数バッジ）
- ヘッダーアクション
  - 新規作成ボタン
- テーブルエリア
  - テーブル本体
    - 名前
    - 色
  - 行アクション
    - 編集（非削除レコード）
    - 復元（削除レコード）
    - 削除（非削除レコード）
    - 完全削除（削除レコード）
  - 一括アクション
    - 復元
    - 削除
    - 完全削除

## 入出力項目

### 作成/編集モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 名前 | name | string | Yes | テキスト入力 | 最大255文字、一意制約 |
| 色 | color | string | No | カラーピッカー | 16進数、デフォルト#808080 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| 名前 | tag.name | テキスト | 検索・ソート可能 |
| 色 | tag.color | カラーセル | ColorColumn |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが開き、新規タグの情報を入力できます。色が未設定の場合は#808080がデフォルト値として設定されます。

処理フロー：
1. モーダル表示
2. フォーム入力
3. 保存時にcreator_idを現在ユーザーに設定
4. 色が空の場合#808080を設定
5. projects_tagsテーブルにINSERT
6. 成功通知表示
7. テーブル更新

### 2-編集アクション

タグを編集するモーダルが表示されます。論理削除されたレコードでは非表示。色が空にされた場合#808080がデフォルト値として設定されます。

### 3-削除アクション

タグを論理削除（アーカイブ）します。

### 4-復元アクション

論理削除されたタグを復元します。

### 5-完全削除アクション

タグをデータベースから完全に削除します。

### 6-タブ切り替え

「すべて」タブと「アーカイブ済み」タブを切り替え、表示するレコードをフィルタリングします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_tags | INSERT | タグの作成 |
| 編集アクション | projects_tags | UPDATE | タグの更新 |
| 削除アクション | projects_tags | SOFT DELETE | タグの論理削除 |
| 復元アクション | projects_tags | UPDATE | deleted_atをnullに |
| 完全削除アクション | projects_tags | DELETE | タグの物理削除 |

### テーブル別更新項目詳細

#### projects_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須、一意 |
| INSERT | color | フォーム入力値、空なら#808080 | デフォルトグレー |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | 一意（自己除外） |
| UPDATE | color | フォーム入力値、空なら#808080 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | タグが正常に作成されました | 作成成功時 |
| 成功通知（編集） | タグが正常に更新されました | 更新成功時 |
| 成功通知（削除） | タグが正常に削除されました | 削除成功時 |
| 成功通知（復元） | タグが正常に復元されました | 復元成功時 |
| 成功通知（完全削除） | タグが完全に削除されました | 完全削除成功時 |
| バリデーションエラー | この名前は既に使用されています | 一意制約違反時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| 一意制約違反 | フォームエラー表示 | この名前は既に使用されています |
| バリデーションエラー | フォームエラー表示 | 各フィールドにエラーメッセージ |

## 備考

- ManageRecordsクラスを継承したFilament標準の一覧管理画面実装
- Configurationsクラスター内に配置
- ナビゲーションアイコンはtag
- ナビゲーション順序は4
- 色のデフォルト値は#808080（グレー）
- ColorPickerはhexColorモード
- ColorColumnで色をセルに表示
- mutateDataUsingで色の空値チェックとデフォルト値設定
- タブのバッジにはcount()およびonlyTrashed()->count()で件数を表示
- タスクとの関連は中間テーブルprojects_task_tagで管理
