# 画面設計書 248-マイルストーン管理（設定）

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「マイルストーン管理（設定）」画面の設計書です。

### 本画面の処理概要

本画面は、プロジェクトのマイルストーン（中間目標・節目）を管理する設定画面です。全プロジェクトのマイルストーンを横断的に一覧表示し、新規作成、編集、削除を行うことができます。マイルストーンにはプロジェクト、期限、完了状態を設定できます。

**業務上の目的・背景**：マイルストーンは、プロジェクトの重要な節目や中間目標を表します。「要件定義完了」「設計完了」「テスト開始」「リリース」など、プロジェクトの進捗を測る重要なチェックポイントとして機能します。本画面では、組織全体のマイルストーンを一元管理し、プロジェクト横断での進捗把握を支援します。

**画面へのアクセス方法**：
1. サイドメニューから「設定」→「Projects」→「設定」を選択
2. 設定クラスター内の「マイルストーン」メニューを選択

**主要な操作・処理内容**：
1. マイルストーン一覧の表示（テーブル形式）
2. マイルストーンの新規作成
3. マイルストーンの編集
4. マイルストーンの削除
5. 完了状態の切り替え（トグル）
6. プロジェクトによるフィルタリング
7. 完了状態によるフィルタリング
8. 作成者によるフィルタリング

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：なし（同一画面内でモーダル操作）

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能
- TaskSettings.enable_milestonesが有効な場合のみメニューに表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONF-004 | マイルストーン管理 | 主機能 | マイルストーンのCRUD操作 |
| FN-PROJ-009 | タスク作成 | 参照機能 | タスク作成時のマイルストーン選択 |
| FN-PROJ-010 | タスク編集 | 参照機能 | タスク編集時のマイルストーン変更 |

## 画面種別

一覧管理（ManageRecords）

## URL/ルーティング

`/admin/settings/projects/milestones`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン
- テーブルエリア
  - カラム管理（2カラム表示）
  - 並べ替え可能
  - フィルタ
    - 完了状態フィルタ
    - プロジェクトフィルタ
    - 作成者フィルタ
  - グループ化オプション
    - プロジェクト
    - 完了状態
    - 作成日
  - テーブル本体
    - 名前
    - 期限
    - 完了（トグル）
    - 完了日時
    - プロジェクト
    - 作成者
    - 作成日時（非表示デフォルト）
    - 更新日時（非表示デフォルト）
  - 行アクション
    - 編集
    - 削除
  - 一括アクション
    - 削除

## 入出力項目

### 作成/編集モーダル入力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| 名前 | name | string | Yes | テキスト入力 | 最大255文字 |
| 期限 | deadline | datetime | No | 日時ピッカー | ネイティブ無効 |
| 完了 | is_completed | boolean | Yes | トグル | - |
| プロジェクト | project_id | integer | Yes | 選択 | 設定画面では必須 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| 名前 | milestone.name | テキスト | 検索・ソート可能 |
| 期限 | milestone.deadline | 日時 | ソート可能 |
| 完了 | milestone.is_completed | トグル | 変更時にcompleted_at更新 |
| 完了日時 | milestone.completed_at | 日時 | ソート可能 |
| プロジェクト | milestone.project.name | テキスト | ソート可能 |
| 作成者 | milestone.creator.name | テキスト | ソート可能 |
| 作成日時 | milestone.created_at | 日時 | 非表示デフォルト |
| 更新日時 | milestone.updated_at | 日時 | 非表示デフォルト |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが開き、新規マイルストーンの情報を入力できます。

処理フロー：
1. モーダル表示
2. フォーム入力
3. 保存時にcreator_idを現在ユーザーに設定
4. projects_milestonesテーブルにINSERT
5. 成功通知表示
6. テーブル更新

### 2-編集アクション

マイルストーンを編集するモーダルが表示されます。

### 3-削除アクション

マイルストーンを削除します（物理削除）。

### 4-完了トグル切り替え

完了状態をON/OFFに切り替えます。ON時にcompleted_atに現在日時が設定され、OFF時にnullが設定されます。

### 5-フィルタ操作

プロジェクト、完了状態、作成者でマイルストーン一覧をフィルタリングします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_milestones | INSERT | マイルストーンの作成 |
| 編集アクション | projects_milestones | UPDATE | マイルストーンの更新 |
| 削除アクション | projects_milestones | DELETE | マイルストーンの物理削除 |
| 完了トグル | projects_milestones | UPDATE | is_completedとcompleted_atの更新 |

### テーブル別更新項目詳細

#### projects_milestones

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | deadline | フォーム入力値 | 期限 |
| INSERT | is_completed | フォーム入力値 | boolean |
| INSERT | project_id | フォーム選択値 | 必須 |
| INSERT | creator_id | 現在ログインユーザーID | Auth::id() |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | deadline | フォーム入力値 | - |
| UPDATE | is_completed | フォーム入力値 | - |
| UPDATE | project_id | フォーム選択値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| トグル | is_completed | true/false | - |
| トグル | completed_at | 現在日時/null | ONでnow()、OFFでnull |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知（作成） | マイルストーンが正常に作成されました | 作成成功時 |
| 成功通知（編集） | マイルストーンが正常に更新されました | 更新成功時 |
| 成功通知（削除） | マイルストーンが正常に削除されました | 削除成功時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| バリデーションエラー | フォームエラー表示 | 各フィールドにエラーメッセージ |

## 備考

- ManageRecordsクラスを継承したFilament標準の一覧管理画面実装
- Configurationsクラスター内に配置
- ナビゲーションアイコンはflag
- ナビゲーション順序は3
- isDiscovered()メソッドでTaskSettings.enable_milestonesをチェック
- コンソール実行時は常にtrue、それ以外は設定値に従う
- ToggleColumnのbeforeStateUpdatedでcompleted_atを自動設定
- 論理削除（SoftDeletes）は使用していない（物理削除のみ）
- プロジェクト画面からのマイルストーン管理（ManageMilestones）とは別の画面
- reorderableColumnsで列の並べ替え可能
- columnManagerColumnsで2カラム表示
