# 画面設計書 249-タスク設定

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タスク設定」画面の設計書です。

### 本画面の処理概要

本画面は、プロジェクト管理モジュールのタスクに関するグローバル設定を管理する設定画面です。プロジェクトステージ機能とマイルストーン機能の有効/無効を切り替えることができます。

**業務上の目的・背景**：組織によってプロジェクト管理の手法は異なります。シンプルなタスク管理のみを行いたい場合もあれば、ステージやマイルストーンを活用した詳細な進捗管理を行いたい場合もあります。本画面では、組織のニーズに合わせてプロジェクト管理機能のオプションを有効/無効に設定できます。

**画面へのアクセス方法**：
1. サイドメニューから「設定」を選択
2. 「Project」ナビゲーショングループ内の「タスク」を選択

**主要な操作・処理内容**：
1. プロジェクトステージ機能の有効/無効切り替え
2. マイルストーン機能の有効/無効切り替え
3. 設定の保存

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：タスクステージ設定画面（リンク経由）

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能（HasPageShieldトレイト使用）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SET-001 | タスク設定 | 主機能 | タスク関連設定の管理 |
| FN-CONF-001 | タスクステージ管理 | 関連機能 | ステージ設定リンクから遷移 |
| FN-CONF-002 | プロジェクトステージ管理 | 影響機能 | プロジェクトステージ有効時のみ表示 |
| FN-CONF-004 | マイルストーン管理 | 影響機能 | マイルストーン有効時のみ表示 |

## 画面種別

設定（SettingsPage）

## URL/ルーティング

`/admin/settings/manage-tasks`

## 画面構成

- パンくずリスト
  - タスク設定
- フォームエリア
  - プロジェクトステージ有効化トグル
    - ヘルパーテキスト
    - ステージ設定へのリンク
  - マイルストーン有効化トグル
    - ヘルパーテキスト
- 保存ボタン

## 入出力項目

### 設定項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| プロジェクトステージ有効化 | enable_project_stages | boolean | Yes | トグル | ヘルパーテキストとリンク付き |
| マイルストーン有効化 | enable_milestones | boolean | Yes | トグル | ヘルパーテキスト付き |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| プロジェクトステージ有効化 | TaskSettings.enable_project_stages | トグル | - |
| ステージ設定リンク | TaskStageResource::getUrl() | リンク | アイコン付き |
| マイルストーン有効化 | TaskSettings.enable_milestones | トグル | - |

## イベント仕様

### 1-保存ボタン押下

設定値をデータベースに保存します。

処理フロー：
1. フォーム入力値の取得
2. settings_task_settingsテーブルの更新（Spatie Laravel Settings）
3. 成功通知表示

### 2-ステージ設定リンククリック

タスクステージ管理画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新 |

### テーブル別更新項目詳細

#### settings（Spatie Laravel Settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | task.enable_project_stages | フォーム入力値 | boolean |
| UPDATE | task.enable_milestones | フォーム入力値 | boolean |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知 | 設定が正常に保存されました | 保存成功時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |

## 備考

- SettingsPageクラスを継承したFilament/Spatie Laravel Settings連携画面
- Settingsクラスター内に配置（Webkul\Support\Filament\Clusters\Settings）
- ナビゲーションアイコンはclipboard-document-check
- ナビゲーショングループは「Project」
- HasPageShieldトレイトで権限制御
- TaskSettingsクラス（Spatie Laravel Settings）で設定値を管理
- プロジェクトステージ有効化のヘルパーテキストにはHTMLリンクが含まれる
- リンクアイコンは外部リンクアイコン（heroicon-o-arrow-top-right-on-square相当）
- enable_project_stagesの変更は、プロジェクトステージ管理画面の表示/非表示に影響
- enable_milestonesの変更は、マイルストーン管理画面およびタスクフォームのマイルストーンフィールド表示に影響
