# 画面設計書 25-請求書一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおける請求書一覧画面の設計仕様を定義します。請求書（Invoice）は顧客への売上請求を管理する中核機能であり、この一覧画面ではすべての請求書を検索・フィルタリング・管理します。

### 本画面の処理概要

**業務上の目的・背景**：
請求書管理は企業の売上・収益管理の根幹を成す機能です。この一覧画面では、発行済み・下書き・キャンセル・支払済みなど様々なステータスの請求書を一元管理し、効率的な売掛金管理を実現します。プリセットビュー機能により、業務ニーズに応じた迅速なフィルタリングが可能です。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 「請求書」または「売上請求書」メニューを選択

**主要な操作・処理内容**：
1. 請求書の一覧表示・検索・フィルタリング
2. プリセットビューによる表示切替（請求書、下書き、発行済み、キャンセル、未保全、返金、要確認、要支払、支払中、期限超過）
3. 新規請求書の作成画面への遷移
4. 既存請求書の詳細・編集画面への遷移
5. 請求書の削除
6. 一括削除
7. 列のカスタマイズ（並び替え、表示/非表示）

**画面遷移**：
- 遷移元：会計モジュールのメニュー
- 遷移先：請求書作成画面、請求書詳細画面、請求書編集画面

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-001 | 請求書管理 | 主機能 | 請求書のCRUD操作 |
| FN-ACC-002 | 支払管理 | 参照機能 | 支払ステータスの表示 |
| FN-ACC-003 | 会計仕訳 | 参照機能 | 仕訳との連携 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/accounts/invoices`

## 画面構成

- ヘッダーアクション
  - 作成ボタン（CreateAction）- アイコン付き
- プリセットビュータブ
  - 請求書（デフォルト、お気に入り）
  - 下書き（お気に入り）
  - 発行済み（お気に入り）
  - キャンセル（お気に入り）
  - 未保全（お気に入り）
  - 返金
  - 要確認
  - 要支払
  - 支払中
  - 期限超過
- テーブル
  - 並び替え可能なカラム
  - カラムマネージャー（2カラム）
  - グループ化オプション
  - フィルタービルダー
  - 合計行（税抜・税額・合計・残高）
- ツールバーアクション
  - 一括アクショングループ（削除）

## 入出力項目

本画面は一覧表示のため、入力項目はフィルター・検索のみです。

### フィルター項目

| 項目名 | 項目ID | フィルター種別 | 備考 |
|--------|--------|---------------|------|
| 番号 | name | テキスト | 部分一致検索 |
| ソースドキュメント | invoice_origin | テキスト | 部分一致検索 |
| 参照 | reference | テキスト | 部分一致検索 |
| 顧客表示名 | invoice_partner_display_name | テキスト | 部分一致検索 |
| 請求日 | invoice_date | 日付 | 範囲指定可 |
| 支払期日 | invoice_date_due | 日付 | 範囲指定可 |
| 作成日 | created_at | 日付 | 範囲指定可 |
| 更新日 | updated_at | 日付 | 範囲指定可 |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 | デフォルト表示 | 集計 |
|--------|--------|----------|----------|--------|------|---------------|------|
| 番号 | name | string | テキスト | ○ | ○ | ○ | - |
| ステータス | state | enum | ラベル | ○ | - | ○ | - |
| 顧客 | invoice_partner_display_name | string | テキスト | ○ | ○ | ○ | - |
| 請求日 | invoice_date | date | 日付 | ○ | - | ○ | - |
| 支払期日 | invoice_date_due | date | 日付 | ○ | - | ○ | - |
| 税抜金額 | amount_untaxed_in_currency_signed | decimal | 金額 | ○ | ○ | ○ | Sum |
| 税額 | amount_tax_signed | decimal | 金額 | ○ | ○ | ○ | Sum |
| 合計 | amount_total_in_currency_signed | decimal | 金額 | ○ | ○ | ○ | Sum |
| 残高 | amount_residual_signed | decimal | 金額 | ○ | ○ | ○ | Sum |
| 支払ステータス | payment_state | enum | バッジ | ○ | ○ | ○ | - |
| 確認済み | checked | boolean | アイコン | ○ | - | × | - |
| 会計日 | date | date | 日付 | ○ | ○ | × | - |
| ソースドキュメント | invoice_origin | string | テキスト | ○ | ○ | × | - |
| 参照 | reference | string | テキスト | ○ | ○ | × | - |
| 担当者 | invoiceUser.name | string | テキスト | ○ | ○ | × | - |
| 通貨 | currency.name | string | テキスト | ○ | ○ | × | - |

### グループ化オプション

| グループ名 | 項目ID | 備考 |
|-----------|--------|------|
| 番号 | name | 折りたたみ可 |
| 顧客 | invoice_partner_display_name | 折りたたみ可 |
| 請求日 | invoice_date | 折りたたみ可 |
| 確認済み | checked | 折りたたみ可 |
| 会計日 | date | 日付、折りたたみ可 |
| 支払期日 | invoice_date_due | 日付、折りたたみ可 |
| ソースドキュメント | invoice_origin | 折りたたみ可 |
| 担当者 | invoiceUser.name | 日付、折りたたみ可 |
| 通貨 | currency.name | 折りたたみ可 |
| 作成日 | created_at | 日付、折りたたみ可 |
| 更新日 | updated_at | 日付、折りたたみ可 |

## イベント仕様

### 1-作成ボタン押下

1. 請求書作成画面（CreateInvoice）へ遷移

### 2-行クリック/表示ボタン押下

1. 請求書詳細画面（ViewInvoice）へ遷移

### 3-編集ボタン押下（行アクション）

1. 請求書編集画面（EditInvoice）へ遷移

### 4-削除ボタン押下（行アクション）

1. 確認ダイアログ表示
2. ユーザーが確認した場合、レコードを削除
3. 成功通知を表示
4. テーブルを更新

### 5-プリセットビュー切替

各ビューは異なるクエリ条件を適用：
- **請求書**：move_type = OUT_INVOICE
- **下書き**：state = DRAFT
- **発行済み**：state = POSTED
- **キャンセル**：state = CANCEL
- **未保全**：inalterable_hash IS NOT NULL
- **返金**：move_type = IN_REFUND
- **要確認**：state != DRAFT AND checked = false
- **要支払**：state = POSTED AND payment_state IN (NOT_PAID, PARTIAL)
- **支払中**：state = POSTED AND payment_state = IN_PAYMENT
- **期限超過**：state = POSTED AND payment_state = NOT_PAID AND invoice_date_due < 今日

### 6-一括削除

1. 選択された複数レコードを一括削除
2. 成功通知を表示
3. テーブルを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | account_moves | SELECT | 請求書一覧の取得 |
| 削除ボタン押下 | account_moves | DELETE | 請求書レコードの削除 |
| 一括削除 | account_moves | DELETE | 複数請求書の削除 |

### テーブル別更新項目詳細

#### account_moves（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | プリセットビューの条件に基づく | 通貨情報をEager Load |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| invoice.table.actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| invoice.table.actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |
| invoice.table.bulk-actions.delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| invoice.table.bulk-actions.delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 権限不足 | 操作権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| データ取得エラー | データベース接続エラー等 | エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装されている
- HasTableViewsトレイトを使用してプリセットビュー機能を実装
- モデルはAccountMove（account_movesテーブル）
- 金額カラムは通貨に応じたフォーマットで表示
- レコードタイトル属性はname
- クエリはid降順でソート
- カラムマネージャーは2カラム表示
- 通貨リレーションをEager Loadして最適化
