# 画面設計書 250-時間設定

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「時間設定」画面の設計書です。

### 本画面の処理概要

本画面は、プロジェクト管理モジュールの時間追跡（タイムシート）機能に関するグローバル設定を管理する設定画面です。タイムシート機能の有効/無効を切り替えることができます。

**業務上の目的・背景**：すべての組織でタイムシート機能が必要とは限りません。作業時間の記録が不要な場合や、別のシステムで時間管理を行っている場合など、タイムシート機能を無効化することで、画面をシンプルに保ち、ユーザーの操作負担を軽減することができます。本画面では、組織のニーズに合わせてタイムシート機能を有効/無効に設定できます。

**画面へのアクセス方法**：
1. サイドメニューから「設定」を選択
2. 「Project」ナビゲーショングループ内の「時間」を選択

**主要な操作・処理内容**：
1. タイムシート機能の有効/無効切り替え
2. 設定の保存

**画面遷移**：
- 遷移元：設定画面、サイドメニュー
- 遷移先：なし

**権限による表示制御**：
- 設定権限を持つユーザーのみアクセス可能（HasPageShieldトレイト使用）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-SET-002 | 時間設定 | 主機能 | 時間関連設定の管理 |
| FN-TS-001 | タイムシート一覧 | 影響機能 | タイムシート有効時のみ表示 |
| FN-PROJ-010 | タスク編集 | 影響機能 | タイムシート有効時のみ時間関連フィールド表示 |

## 画面種別

設定（SettingsPage）

## URL/ルーティング

`/admin/settings/manage-time`

## 画面構成

- パンくずリスト
  - 時間設定
- フォームエリア
  - タイムシート有効化トグル
    - ヘルパーテキスト
- 保存ボタン

## 入出力項目

### 設定項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| タイムシート有効化 | enable_timesheets | boolean | Yes | トグル | ヘルパーテキスト付き |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| タイムシート有効化 | TimeSettings.enable_timesheets | トグル | - |

## イベント仕様

### 1-保存ボタン押下

設定値をデータベースに保存します。

処理フロー：
1. フォーム入力値の取得
2. settings_time_settingsテーブルの更新（Spatie Laravel Settings）
3. 成功通知表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 設定値の更新 |

### テーブル別更新項目詳細

#### settings（Spatie Laravel Settings）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | time.enable_timesheets | フォーム入力値 | boolean |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知 | 設定が正常に保存されました | 保存成功時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |

## 備考

- SettingsPageクラスを継承したFilament/Spatie Laravel Settings連携画面
- Settingsクラスター内に配置（Webkul\Support\Filament\Clusters\Settings）
- ナビゲーションアイコンはclock
- ナビゲーショングループは「Project」
- HasPageShieldトレイトで権限制御
- TimeSettingsクラス（Spatie Laravel Settings）で設定値を管理
- enable_timesheetsの変更は、以下に影響：
  - タスク管理画面のタイムシートタブ表示/非表示
  - タスクフォームの時間関連フィールド（割り当て時間等）表示/非表示
  - タスク一覧テーブルの時間関連カラム表示/非表示
  - タスク詳細画面の時間追跡セクション表示/非表示
  - プロジェクトフォームのallow_timesheetsフィールド関連動作
