# 画面設計書 251-見積依頼一覧

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「見積依頼一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、仕入先に対する見積依頼（Request for Quotation: RFQ）の一覧を表示・管理するための画面です。購買担当者が仕入先への見積依頼状況を一覧で把握し、各種操作を行うことができます。

**業務上の目的・背景**：
購買業務において、仕入先から適切な価格・条件で商品やサービスを調達するためには、複数の仕入先への見積依頼を効率的に管理する必要があります。本画面は、見積依頼のステータス管理、検索・フィルタリング、および各見積依頼へのアクセスを容易にすることで、購買プロセスの効率化を支援します。

**画面へのアクセス方法**：
メインナビゲーション > 購買（Purchases）クラスター > 注文（Orders）> 見積依頼（Quotations）を選択してアクセスします。

**主要な操作・処理内容**：
1. 見積依頼の一覧表示（テーブル形式）
2. プリセットビューによる絞り込み（マイ購買、発注済み、スター付き、下書き、待機中、遅延）
3. 高度なフィルタリング・検索機能
4. 見積依頼の新規作成画面への遷移
5. 各見積依頼の詳細・編集・削除操作
6. 一括削除機能

**画面遷移**：
- 遷移元：ダッシュボード、購買クラスターナビゲーション
- 遷移先：見積依頼作成画面、見積依頼詳細画面、見積依頼編集画面

**権限による表示制御**：
ユーザーの購買モジュールに対する権限に応じて、作成・編集・削除ボタンの表示/非表示が制御されます。完了（DONE）状態の見積依頼は削除不可となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-001 | 購買見積一覧 | 主機能 | 見積依頼データの一覧表示、検索、フィルタ、グループ化、ソート |
| FN-PURCH-002 | 購買見積作成 | 遷移先機能 | 新規見積依頼の作成画面への遷移 |
| FN-PURCH-004 | 購買見積表示 | 遷移先機能 | 見積依頼詳細の表示画面への遷移 |
| FN-PURCH-003 | 購買見積編集 | 遷移先機能 | 見積依頼編集画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/purchases/orders/quotations`

## 画面構成

1. **ヘッダーアクション**
   - 新規作成ボタン（「+ 新規見積依頼」）

2. **プリセットビュー（タブ）**
   - マイ購買（my_purchases）：ログインユーザーの担当する見積依頼
   - 発注済み（purchase_orders）：PURCHASE/DONE状態の見積依頼
   - スター付き（starred_orders）：優先度フラグが立っている見積依頼
   - 注文（orders）：DRAFT/SENT状態の見積依頼
   - 下書き（draft_orders）：DRAFT状態の見積依頼
   - 待機中（waiting_orders）：SENT状態の見積依頼
   - 遅延（late_orders）：DRAFT/SENTで発注日が過去の見積依頼

3. **データテーブル**
   - 並べ替え可能なカラム
   - カラムマネージャー（表示/非表示の切り替え）

4. **フィルターモーダル**
   - 高度な検索条件の設定

## 入出力項目

該当なし（一覧画面のため、入力項目はフィルター条件のみ）

## 表示項目

| No | 項目名 | データ型 | 説明 | デフォルト表示 |
|----|--------|----------|------|---------------|
| 1 | 優先度（priority） | アイコン | スター表示、クリックで切り替え可能 | 表示 |
| 2 | 仕入先参照（partner_reference） | テキスト | 仕入先の参照番号 | 非表示 |
| 3 | 参照番号（name） | テキスト | 見積依頼番号（PO/XXX形式） | 表示 |
| 4 | 仕入先（partner.name） | テキスト | 仕入先名 | 表示 |
| 5 | 会社（company.name） | テキスト | 所属会社名 | 表示 |
| 6 | 購買担当者（user.name） | テキスト | 担当者名 | 表示 |
| 7 | 発注期限（ordered_at） | 日時 | 発注期限日時 | 表示 |
| 8 | 元伝票（origin） | テキスト | ソースドキュメント | 表示 |
| 9 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額 | 表示 |
| 10 | 合計金額（total_amount） | 通貨 | 税込合計金額 | 表示 |
| 11 | 請求ステータス（invoice_status） | バッジ | 請求状況 | 表示 |
| 12 | ステータス（state） | バッジ | 見積依頼のステータス | 非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、見積依頼作成画面（CreateQuotation）に遷移します。

### 2-優先度アイコンクリック

一覧の優先度（スター）アイコンをクリックすると、該当レコードの`priority`フィールドが反転（true/false）し、即時データベースに保存されます。

### 3-行アクション（表示・編集・削除）

各行の右端にあるアクションメニューから以下の操作が可能：
- 表示：見積依頼詳細画面に遷移
- 編集：見積依頼編集画面に遷移
- 削除：確認後、見積依頼を削除（DONE状態の場合は非表示）

### 4-一括削除

チェックボックスで複数選択し、一括削除を実行できます。DONE状態のレコードは選択不可となります。

### 5-フィルター適用

フィルターモーダルで条件を設定し、適用ボタンを押すとテーブルデータがフィルタリングされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | purchases_orders | SELECT | 見積依頼データの取得 |
| 優先度変更 | purchases_orders | UPDATE | priorityカラムの更新 |
| 削除 | purchases_orders | DELETE | 見積依頼レコードの削除 |
| 一括削除 | purchases_orders | DELETE | 複数見積依頼レコードの削除 |

### テーブル別更新項目詳細

#### purchases_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | priority | !current_value（反転） | スター切り替え時 |
| DELETE | - | id = 指定ID | 削除時、state != DONEの場合のみ |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | delete.notification.success | 見積依頼が正常に削除されました | 削除成功時 |
| 2 | エラー | delete.notification.error | 関連データが存在するため、削除できません | 削除失敗時（FK制約） |
| 3 | 成功 | bulk-delete.notification.success | 選択した見積依頼が正常に削除されました | 一括削除成功時 |
| 4 | エラー | bulk-delete.notification.error | 関連データが存在するため、一部の削除ができません | 一括削除失敗時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | データが見つからない | 空のテーブルを表示、データなしメッセージ表示 |
| 2 | 削除時のFK制約違反 | エラー通知を表示し、処理を中断 |
| 3 | 権限不足 | 該当操作ボタンを非表示、または操作時にエラー表示 |
| 4 | 通信エラー | 一般的なエラー通知を表示 |

## 備考

- 本画面はFilament PHPの`ListRecords`コンポーネントを継承して実装
- テーブルビューには`HasTableViews`トレイトを使用し、プリセットビュー機能を実現
- 通貨表示は各レコードに紐づく通貨マスタに基づいて動的にフォーマット
- グループ化機能により、仕入先別、担当者別、ステータス別などでデータを集約表示可能
