# 画面設計書 252-見積依頼作成

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「見積依頼作成」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、仕入先に対する新規見積依頼（Request for Quotation: RFQ）を作成するための画面です。購買担当者が仕入先、商品、数量、価格などの情報を入力し、見積依頼を登録します。

**業務上の目的・背景**：
購買プロセスの開始点として、仕入先への正式な見積依頼を作成・記録するための画面です。適切な仕入先選定、価格交渉の基礎となるデータを登録し、購買プロセス全体の追跡を可能にします。

**画面へのアクセス方法**：
1. 見積依頼一覧画面の「新規作成」ボタンをクリック
2. URL直接アクセス：`/admin/purchases/orders/quotations/create`

**主要な操作・処理内容**：
1. 基本情報（仕入先、担当者、通貨、日付等）の入力
2. 注文明細（商品、数量、単価等）の登録
3. 追加情報（カスタムフィールド、備考等）の入力
4. 見積依頼の保存

**画面遷移**：
- 遷移元：見積依頼一覧画面
- 遷移先：見積依頼編集画面（作成成功後）

**権限による表示制御**：
購買モジュールの作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-002 | 購買見積作成 | 主機能 | 見積依頼データの新規登録 |
| FN-PURCH-001 | 購買見積一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-003 | 購買見積編集 | 遷移先機能 | 作成成功後の編集画面遷移 |

## 画面種別

作成（Create）

## URL/ルーティング

`/admin/purchases/orders/quotations/create`

## 画面構成

1. **進捗ステッパー**
   - ステータス表示（DRAFT → SENT → PURCHASE → DONE）

2. **基本情報セクション**
   - 仕入先選択
   - 請求先・配送先連絡先
   - 通貨選択
   - 発注期限・入荷予定日
   - 購買担当者・会社選択

3. **タブセクション**
   - 商品タブ：注文明細の入力
   - その他情報タブ：追加設定
   - 備考タブ：利用規約等

4. **フッターアクション**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

| No | 項目名 | データ型 | 必須 | 初期値 | バリデーション | 説明 |
|----|--------|----------|------|--------|----------------|------|
| 1 | 仕入先（partner_id） | Integer/Select | ○ | - | 存在確認 | 仕入先マスタから選択 |
| 2 | 請求先連絡先（invoice_address_id） | Integer/Select | - | - | partner_idに紐づく連絡先 | 請求先住所 |
| 3 | 配送先連絡先（delivery_address_id） | Integer/Select | - | - | partner_idに紐づく連絡先 | 配送先住所 |
| 4 | 購買担当者（user_id） | Integer/Select | - | ログインユーザー | - | 担当者選択 |
| 5 | 通貨（currency_id） | Integer/Select | ○ | 会社デフォルト | - | 通貨マスタから選択 |
| 6 | 発注期限（ordered_at） | DateTime | - | - | 日付形式 | 発注期限日時 |
| 7 | 入荷予定日（planned_at） | DateTime | - | - | 日付形式 | 入荷予定日時 |
| 8 | 確認期限（calendar_start_at） | DateTime | - | - | 日付形式 | 確認期限日時 |
| 9 | 仕入先参照（partner_reference） | String | - | - | 最大255文字 | 仕入先の参照番号 |
| 10 | 会社（company_id） | Integer/Select | ○ | ユーザーデフォルト会社 | - | 会社マスタから選択 |
| 11 | 財務ポジション（fiscal_position_id） | Integer/Select | - | - | - | 財務ポジション選択 |
| 12 | インコタームズ（incoterm_id） | Integer/Select | - | - | - | インコタームズ選択 |
| 13 | インコタームズ場所（incoterm_location） | String | - | - | 最大255文字 | インコタームズの場所 |
| 14 | 支払条件（payment_term_id） | Integer/Select | - | - | - | 支払条件選択 |
| 15 | 入庫タイプ（operation_type_id） | Integer/Select | - | - | - | 入庫オペレーションタイプ |
| 16 | 備考（description） | Text/RichEditor | - | - | - | 利用規約・備考 |

### 注文明細（lines）

| No | 項目名 | データ型 | 必須 | 初期値 | バリデーション | 説明 |
|----|--------|----------|------|--------|----------------|------|
| 1 | 商品（product_id） | Integer/Select | ○ | - | 存在確認 | 商品マスタから選択 |
| 2 | 説明（name） | Text | - | 商品から自動設定 | - | 商品説明 |
| 3 | 数量（product_qty） | Decimal | ○ | 0 | 0以上 | 発注数量 |
| 4 | 単位（product_uom_id） | Integer/Select | 設定依存 | 商品から自動設定 | - | 単位選択（UOM設定時のみ表示） |
| 5 | 単価（price_unit） | Decimal | ○ | 商品から自動設定 | 0以上 | 単価 |
| 6 | 税（taxes） | Array/Select | - | 商品から自動設定 | - | 税選択（複数可） |
| 7 | 小計（price_subtotal） | Decimal | - | 自動計算 | - | 税抜小計（読み取り専用） |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 1 | 状態ステッパー（state） | Badge | 現在のステータスをステップ形式で表示 | 常時 |
| 2 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額（読み取り専用） | 常時 |
| 3 | 税額（tax_amount） | 通貨 | 税額合計（読み取り専用） | 常時 |
| 4 | 合計金額（total_amount） | 通貨 | 税込合計金額（読み取り専用） | 常時 |

## イベント仕様

### 1-仕入先選択変更

仕入先（partner_id）を選択すると、以下の処理が実行されます：
- 請求先連絡先・配送先連絡先の選択肢を該当仕入先の子連絡先でフィルタリング
- 仕入先のデフォルト通貨・支払条件を自動設定

### 2-商品選択変更

商品（product_id）を選択すると、以下の項目が自動設定されます：
- 商品名 → name
- 商品の購買価格 → price_unit
- 商品の単位 → product_uom_id
- 商品のデフォルト税 → taxes

### 3-数量・単価変更

数量（product_qty）または単価（price_unit）が変更されると、小計（price_subtotal）が再計算されます。

### 4-保存ボタン押下

フォーム内容を検証し、問題がなければ見積依頼を作成します。作成成功後、編集画面に遷移します。

### 5-キャンセルボタン押下

確認なしで一覧画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | purchases_orders | INSERT | 見積依頼ヘッダーの作成 |
| 保存 | purchases_order_lines | INSERT | 見積依頼明細の作成 |
| 保存 | purchases_order_line_taxes | INSERT | 明細税の関連付け |

### テーブル別更新項目詳細

#### purchases_orders（INSERT）

| 項目（カラム名） | 値・取得元 | 備考 |
|-----------------|-----------|------|
| name | 自動生成（PO/{id}） | 作成後に更新 |
| state | DRAFT | 固定値 |
| invoice_status | NO | 固定値 |
| receipt_status | PENDING（設定依存） | 設定による |
| partner_id | フォーム入力 | 必須 |
| currency_id | フォーム入力 | 必須 |
| user_id | フォーム入力 or ログインユーザー | - |
| company_id | フォーム入力 | 必須 |
| creator_id | ログインユーザーID | 自動設定 |
| ordered_at | フォーム入力 | - |
| planned_at | フォーム入力 | - |
| untaxed_amount | 計算値 | 明細小計の合計 |
| tax_amount | 計算値 | 税額の合計 |
| total_amount | 計算値 | 税込合計 |

#### purchases_order_lines（INSERT）

| 項目（カラム名） | 値・取得元 | 備考 |
|-----------------|-----------|------|
| order_id | 親レコードID | 自動設定 |
| product_id | フォーム入力 | 必須 |
| name | フォーム入力 | - |
| product_qty | フォーム入力 | 必須 |
| product_uom_id | フォーム入力 | 設定依存 |
| price_unit | フォーム入力 | 必須 |
| price_subtotal | 計算値 | qty * unit_price |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | create.notification.success.title | 作成完了 | 作成成功時 |
| 2 | 成功 | create.notification.success.body | 見積依頼が正常に作成されました | 作成成功時 |
| 3 | エラー | validation.required | {field}は必須です | 必須項目未入力時 |
| 4 | エラー | validation.numeric | {field}は数値で入力してください | 数値項目に非数値入力時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | 必須項目未入力 | バリデーションエラー表示、該当項目をハイライト |
| 2 | 仕入先が存在しない（削除済み） | 選択不可として表示 |
| 3 | 商品が存在しない（削除済み） | 選択不可として表示 |
| 4 | DB保存エラー | エラー通知を表示、ロールバック |
| 5 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |

## 備考

- 本画面はFilament PHPの`CreateRecord`コンポーネントを継承して実装
- フォームスキーマは親クラス`OrderResource`で定義され、`CreateOrder`クラスで継承
- 金額計算は`HasTotals`トレイトで実装されたリアルタイム計算機能を使用
- UOM（単位）関連項目は`ProductSettings`の設定により表示/非表示が制御される
- 明細の税選択は複数選択可能（BelongsToManyリレーション）
- 保存後は`getRedirectUrl()`により編集画面に自動遷移
