# 画面設計書 253-見積依頼編集

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「見積依頼編集」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、既存の見積依頼（Request for Quotation: RFQ）を編集・更新するための画面です。見積依頼のステータスに応じて、各種アクション（確認、キャンセル等）を実行できます。

**業務上の目的・背景**：
購買プロセスにおいて、見積依頼の内容を修正したり、ステータスを進行させるために使用します。仕入先との交渉結果の反映、数量や価格の調整、発注への移行などを行います。

**画面へのアクセス方法**：
1. 見積依頼一覧画面から対象レコードの「編集」をクリック
2. 見積依頼詳細画面の「編集」ボタンをクリック
3. 見積依頼作成成功後の自動遷移
4. URL直接アクセス：`/admin/purchases/orders/quotations/{record}/edit`

**主要な操作・処理内容**：
1. 見積依頼内容の編集・保存
2. 見積依頼の確認（DRAFT → SENT）
3. 発注への変換（SENT → PURCHASE）
4. 見積依頼のキャンセル（→ CANCELED）
5. メール送信・印刷

**画面遷移**：
- 遷移元：見積依頼一覧画面、見積依頼詳細画面、見積依頼作成画面
- 遷移先：見積依頼詳細画面、発注書編集画面（発注変換時）

**権限による表示制御**：
購買モジュールの編集権限を持つユーザーのみがアクセス可能です。ステータスによって編集可能な項目が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-003 | 購買見積編集 | 主機能 | 見積依頼データの編集・更新 |
| FN-PURCH-001 | 購買見積一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-004 | 購買見積表示 | 関連機能 | サブナビゲーションで連携 |
| FN-PURCH-006 | 発注書編集 | 遷移先機能 | 発注変換後の遷移先 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/admin/purchases/orders/quotations/{record}/edit`

## 画面構成

1. **サブナビゲーション**
   - 詳細表示（ViewQuotation）
   - 編集（EditQuotation）- 現在画面

2. **ヘッダーアクション**
   - 確認（Confirm）ボタン
   - 発注確認（Confirm Order）ボタン
   - キャンセルボタン
   - 印刷ボタン
   - メール送信ボタン

3. **進捗ステッパー**
   - ステータス表示（DRAFT → SENT → PURCHASE → DONE）

4. **基本情報セクション**
   - 仕入先選択（ステータスに応じて編集可否制御）
   - 請求先・配送先連絡先
   - 通貨選択
   - 発注期限・入荷予定日
   - 購買担当者・会社選択

5. **タブセクション**
   - 商品タブ：注文明細の編集
   - その他情報タブ：追加設定
   - 備考タブ：利用規約等

6. **金額サマリー**
   - 税抜金額、税額、合計金額の表示

7. **フッターアクション**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

| No | 項目名 | データ型 | 必須 | 編集可否条件 | バリデーション | 説明 |
|----|--------|----------|------|-------------|----------------|------|
| 1 | 仕入先（partner_id） | Integer/Select | ○ | state=DRAFT時のみ | 存在確認 | 仕入先マスタから選択 |
| 2 | 請求先連絡先（invoice_address_id） | Integer/Select | - | 常時 | - | 請求先住所 |
| 3 | 配送先連絡先（delivery_address_id） | Integer/Select | - | 常時 | - | 配送先住所 |
| 4 | 購買担当者（user_id） | Integer/Select | - | 常時 | - | 担当者選択 |
| 5 | 通貨（currency_id） | Integer/Select | ○ | state=DRAFT時のみ | - | 通貨マスタから選択 |
| 6 | 発注期限（ordered_at） | DateTime | - | 常時 | 日付形式 | 発注期限日時 |
| 7 | 入荷予定日（planned_at） | DateTime | - | 常時 | 日付形式 | 入荷予定日時 |
| 8 | 確認期限（calendar_start_at） | DateTime | - | 常時 | 日付形式 | 確認期限日時 |
| 9 | 仕入先参照（partner_reference） | String | - | 常時 | 最大255文字 | 仕入先の参照番号 |
| 10 | 会社（company_id） | Integer/Select | ○ | state=DRAFT時のみ | - | 会社マスタから選択 |
| 11 | 財務ポジション（fiscal_position_id） | Integer/Select | - | 常時 | - | 財務ポジション選択 |
| 12 | インコタームズ（incoterm_id） | Integer/Select | - | 常時 | - | インコタームズ選択 |
| 13 | 支払条件（payment_term_id） | Integer/Select | - | 常時 | - | 支払条件選択 |
| 14 | 備考（description） | Text/RichEditor | - | 常時 | - | 利用規約・備考 |

### 注文明細（lines）

| No | 項目名 | データ型 | 必須 | 編集可否条件 | バリデーション | 説明 |
|----|--------|----------|------|-------------|----------------|------|
| 1 | 商品（product_id） | Integer/Select | ○ | state != DONE/CANCELED | 存在確認 | 商品マスタから選択 |
| 2 | 説明（name） | Text | - | state != DONE/CANCELED | - | 商品説明 |
| 3 | 数量（product_qty） | Decimal | ○ | state != DONE/CANCELED | 0以上 | 発注数量 |
| 4 | 単位（product_uom_id） | Integer/Select | 設定依存 | state != DONE/CANCELED | - | 単位選択 |
| 5 | 単価（price_unit） | Decimal | ○ | state != DONE/CANCELED | 0以上 | 単価 |
| 6 | 税（taxes） | Array/Select | - | state != DONE/CANCELED | - | 税選択 |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 1 | 参照番号（name） | テキスト | PO/XXX形式の見積依頼番号 | 常時 |
| 2 | 状態ステッパー（state） | Badge | 現在のステータス | 常時 |
| 3 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額 | 常時 |
| 4 | 税額（tax_amount） | 通貨 | 税額合計 | 常時 |
| 5 | 合計金額（total_amount） | 通貨 | 税込合計金額 | 常時 |
| 6 | 入庫数（receipts_count） | 数値 | 関連入庫オペレーション数 | 常時 |

## イベント仕様

### 1-確認ボタン押下（Confirm）

ステータスがDRAFTの場合に表示されます。押下すると見積依頼のステータスをSENT（送信済み）に変更し、発注日を現在日時に設定します。

### 2-発注確認ボタン押下（Confirm Order）

ステータスがDRAFT/SENTの場合に表示されます。押下すると見積依頼を発注に変換します：
- ステータスをPURCHASEに変更
- 発注日を現在日時に設定
- 関連する在庫オペレーション（入庫）を生成
- 成功通知を表示

### 3-キャンセルボタン押下

ステータスがDRAFT/SENTの場合に表示されます。押下すると見積依頼のステータスをCANCELEDに変更します。関連する入庫オペレーションがある場合はそれらもキャンセルされます。

### 4-印刷ボタン押下

見積依頼のPDFをダウンロードまたは印刷します。

### 5-メール送信ボタン押下

見積依頼をメールで送信するためのモーダルを表示します。

### 6-保存ボタン押下

フォーム内容を検証し、問題がなければ見積依頼を更新します。金額の再計算も行われます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | purchases_orders | UPDATE | 見積依頼ヘッダーの更新 |
| 保存 | purchases_order_lines | UPDATE/INSERT/DELETE | 見積依頼明細の更新 |
| 確認 | purchases_orders | UPDATE | ステータス変更 |
| 発注確認 | purchases_orders | UPDATE | ステータス変更 |
| 発注確認 | inventories_operations | INSERT | 入庫オペレーション作成 |
| キャンセル | purchases_orders | UPDATE | ステータス変更 |

### テーブル別更新項目詳細

#### purchases_orders（確認時UPDATE）

| 項目（カラム名） | 更新値 | 備考 |
|-----------------|--------|------|
| state | SENT | 確認時 |
| ordered_at | now() | 発注日を現在日時に |

#### purchases_orders（発注確認時UPDATE）

| 項目（カラム名） | 更新値 | 備考 |
|-----------------|--------|------|
| state | PURCHASE | 発注確認時 |
| ordered_at | now() | 発注日を現在日時に |
| receipt_status | PENDING | 入庫待ちに |

#### purchases_orders（キャンセル時UPDATE）

| 項目（カラム名） | 更新値 | 備考 |
|-----------------|--------|------|
| state | CANCELED | キャンセル時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | save.notification.success | 見積依頼が正常に更新されました | 保存成功時 |
| 2 | 成功 | confirm.notification.success | 見積依頼が確認されました | 確認成功時 |
| 3 | 成功 | confirm-order.notification.success | 発注が確認されました | 発注確認成功時 |
| 4 | 成功 | cancel.notification.success | 見積依頼がキャンセルされました | キャンセル成功時 |
| 5 | 警告 | cancel.confirm.title | 本当にキャンセルしますか？ | キャンセル確認時 |
| 6 | エラー | validation.required | {field}は必須です | 必須項目未入力時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | 必須項目未入力 | バリデーションエラー表示、該当項目をハイライト |
| 2 | レコードが見つからない | 404エラー、一覧画面にリダイレクト |
| 3 | 同時編集の競合 | 最新データで上書きまたはエラー表示 |
| 4 | ステータス不正 | 操作不可の通知、画面リフレッシュ |
| 5 | DB保存エラー | エラー通知を表示、ロールバック |
| 6 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |

## 備考

- 本画面はFilament PHPの`EditRecord`コンポーネントを継承して実装
- フォームスキーマは親クラス`OrderResource`で定義
- ステータスに応じた編集制御は各フォームフィールドの`disabled`条件で実装
- 発注確認時の在庫オペレーション生成は`confirmOrder`アクション内で実行
- サブナビゲーションにより詳細表示画面と編集画面をシームレスに切り替え可能
- アクティビティログ機能により編集履歴が記録される
