# 画面設計書 254-見積依頼詳細

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「見積依頼詳細」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、既存の見積依頼（Request for Quotation: RFQ）の詳細情報を読み取り専用で表示するための画面です。見積依頼の全体像を確認し、必要に応じて編集画面への遷移やアクション実行が可能です。

**業務上の目的・背景**：
購買担当者や管理者が見積依頼の内容を確認するための参照画面です。編集権限がないユーザーでも内容を閲覧でき、監査・確認目的での利用が想定されます。

**画面へのアクセス方法**：
1. 見積依頼一覧画面から対象レコードの「表示」をクリック
2. URL直接アクセス：`/admin/purchases/orders/quotations/{record}`

**主要な操作・処理内容**：
1. 見積依頼詳細情報の閲覧
2. 編集画面への遷移
3. 確認・発注確認・キャンセル等のアクション実行
4. 関連入庫オペレーションの確認

**画面遷移**：
- 遷移元：見積依頼一覧画面
- 遷移先：見積依頼編集画面

**権限による表示制御**：
購買モジュールの閲覧権限を持つユーザーがアクセス可能です。編集権限がない場合でも閲覧可能ですが、編集・アクションボタンは非表示または無効化されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-004 | 購買見積表示 | 主機能 | 見積依頼データの詳細表示 |
| FN-PURCH-001 | 購買見積一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-003 | 購買見積編集 | 遷移先機能 | サブナビゲーションで連携 |

## 画面種別

詳細（View）

## URL/ルーティング

`/admin/purchases/orders/quotations/{record}`

## 画面構成

1. **サブナビゲーション**
   - 詳細表示（ViewQuotation）- 現在画面
   - 編集（EditQuotation）

2. **ヘッダーアクション**
   - 確認（Confirm）ボタン
   - 発注確認（Confirm Order）ボタン
   - キャンセルボタン
   - 印刷ボタン
   - メール送信ボタン

3. **ステータスセクション**
   - 現在のステータスバッジ表示

4. **基本情報セクション**
   - 仕入先情報
   - 請求先・配送先連絡先
   - 通貨情報
   - 日付情報
   - 担当者・会社情報

5. **タブセクション**
   - 商品タブ：注文明細の表示
   - その他情報タブ：追加設定表示
   - 備考タブ：利用規約等

6. **金額サマリー**
   - 税抜金額、税額、合計金額の表示

7. **メタデータセクション**
   - 作成日時、作成者、更新日時

## 入出力項目

該当なし（読み取り専用画面のため入力項目なし）

## 表示項目

### 基本情報セクション

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 1 | ステータス（state） | バッジ | 見積依頼の現在ステータス | 常時 |
| 2 | 仕入先（partner.name） | テキスト | 仕入先名 | 常時 |
| 3 | 購買担当者（user.name） | テキスト | 担当者名 | 常時 |
| 4 | 通貨（currency.name） | テキスト | 通貨名 | 常時 |
| 5 | 発注期限（ordered_at） | 日時 | 発注期限日時 | 常時 |
| 6 | 入荷予定日（planned_at） | 日時 | 入荷予定日時 | 常時 |
| 7 | 仕入先参照（partner_reference） | テキスト | 仕入先の参照番号 | 常時 |
| 8 | 会社（company.name） | テキスト | 会社名 | 常時 |

### その他情報セクション

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 9 | 財務ポジション（fiscalPosition.name） | テキスト | 財務ポジション名 | 常時 |
| 10 | インコタームズ（incoterm.name） | テキスト | インコタームズ名 | 常時 |
| 11 | インコタームズ場所（incoterm_location） | テキスト | インコタームズの場所 | 常時 |
| 12 | 支払条件（paymentTerm.name） | テキスト | 支払条件名 | 常時 |
| 13 | 入庫タイプ（operationType.name） | テキスト | 入庫オペレーションタイプ | 常時 |

### 注文明細（lines）

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 14 | 商品（product.name） | テキスト | 商品名 | 常時 |
| 15 | 説明（name） | テキスト | 商品説明 | 常時 |
| 16 | 数量（product_qty） | 数値 | 発注数量 | 常時 |
| 17 | 入庫済数量（qty_received） | 数値 | 入庫済みの数量 | 常時 |
| 18 | 請求済数量（qty_invoiced） | 数値 | 請求済みの数量 | 常時 |
| 19 | 単位（productUom.name） | テキスト | 単位名 | UOM設定有効時 |
| 20 | 単価（price_unit） | 通貨 | 単価 | 常時 |
| 21 | 税（taxes） | リスト | 適用税リスト | 常時 |
| 22 | 小計（price_subtotal） | 通貨 | 税抜小計 | 常時 |

### 金額サマリー

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 23 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額 | 常時 |
| 24 | 税額（tax_amount） | 通貨 | 税額合計 | 常時 |
| 25 | 合計金額（total_amount） | 通貨 | 税込合計金額 | 常時 |

### メタデータセクション

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 26 | 作成日時（created_at） | 日時 | レコード作成日時 | 常時 |
| 27 | 作成者（creator.name） | テキスト | 作成者名 | 常時 |
| 28 | 更新日時（updated_at） | 日時 | 最終更新日時 | 常時 |

## イベント仕様

### 1-確認ボタン押下（Confirm）

ステータスがDRAFTの場合に表示されます。押下すると見積依頼のステータスをSENT（送信済み）に変更します。

### 2-発注確認ボタン押下（Confirm Order）

ステータスがDRAFT/SENTの場合に表示されます。押下すると見積依頼を発注に変換します。

### 3-キャンセルボタン押下

ステータスがDRAFT/SENTの場合に表示されます。押下すると見積依頼をキャンセルします。

### 4-印刷ボタン押下

見積依頼のPDFをダウンロードまたは印刷します。

### 5-メール送信ボタン押下

見積依頼をメールで送信するためのモーダルを表示します。

### 6-編集ボタン押下（サブナビゲーション）

サブナビゲーションの「編集」をクリックすると編集画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | purchases_orders | SELECT | 見積依頼データの取得 |
| 画面表示 | purchases_order_lines | SELECT | 見積依頼明細の取得 |
| 確認 | purchases_orders | UPDATE | ステータス変更 |
| 発注確認 | purchases_orders | UPDATE | ステータス変更 |
| キャンセル | purchases_orders | UPDATE | ステータス変更 |

※詳細なデータベース更新仕様は「見積依頼編集」画面設計書を参照

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | confirm.notification.success | 見積依頼が確認されました | 確認成功時 |
| 2 | 成功 | confirm-order.notification.success | 発注が確認されました | 発注確認成功時 |
| 3 | 成功 | cancel.notification.success | 見積依頼がキャンセルされました | キャンセル成功時 |
| 4 | 情報 | data.empty | データがありません | 明細が空の場合 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | レコードが見つからない | 404エラー、一覧画面にリダイレクト |
| 2 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |
| 3 | アクション実行時のエラー | エラー通知を表示 |

## 備考

- 本画面はFilament PHPの`ViewRecord`コンポーネントを継承して実装
- 情報表示はInfolist（Infolist）を使用して構造化された形式で表示
- サブナビゲーションにより編集画面とシームレスに切り替え可能
- ヘッダーアクションは編集画面と同一のものを共有（ViewOrderトレイト使用）
- 明細の表示にはRepeatableEntryコンポーネントを使用したテーブル形式表示
- 金額表示は通貨コードに基づいてフォーマット
- カスタムフィールドが設定されている場合は追加タブに表示
