# 画面設計書 255-発注書一覧

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「発注書一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、確定済みの発注書（Purchase Order）の一覧を表示・管理するための画面です。見積依頼から発注に変換された注文や、直接作成された発注書を一覧で表示します。

**業務上の目的・背景**：
購買プロセスにおいて、発注済みの注文を管理するための画面です。入庫状況、請求状況の確認、および関連する請求書・入庫オペレーションへのアクセスを提供します。

**画面へのアクセス方法**：
メインナビゲーション > 購買（Purchases）クラスター > 注文（Orders）> 発注書（Purchase Orders）を選択してアクセスします。

**主要な操作・処理内容**：
1. 発注書の一覧表示（テーブル形式）
2. プリセットビューによる絞り込み（マイ発注、スター付き、請求待ち、請求受領済み）
3. 高度なフィルタリング・検索機能
4. 発注書の新規作成画面への遷移
5. 各発注書の詳細・編集・削除操作
6. 一括削除機能

**画面遷移**：
- 遷移元：ダッシュボード、購買クラスターナビゲーション
- 遷移先：発注書作成画面、発注書詳細画面、発注書編集画面

**権限による表示制御**：
ユーザーの購買モジュールに対する権限に応じて、作成・編集・削除ボタンの表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-005 | 発注書一覧 | 主機能 | 発注書データの一覧表示、検索、フィルタ、グループ化、ソート |
| FN-PURCH-006 | 発注書作成 | 遷移先機能 | 新規発注書の作成画面への遷移 |
| FN-PURCH-008 | 発注書表示 | 遷移先機能 | 発注書詳細の表示画面への遷移 |
| FN-PURCH-007 | 発注書編集 | 遷移先機能 | 発注書編集画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/purchases/orders/purchase-orders`

## 画面構成

1. **ヘッダーアクション**
   - 新規作成ボタン（「+ 新規発注書」）

2. **プリセットビュー（タブ）**
   - マイ発注（my_orders）：ログインユーザーの担当する発注書
   - スター付き（starred_orders）：優先度フラグが立っている発注書
   - 請求待ち（waiting-bills）：SENT状態で発注日が過去の発注書
   - 請求受領済み（received-bills）：PURCHASE/DONE状態で請求済みの発注書

3. **データテーブル**
   - 見積依頼一覧と同様のカラム構成
   - ステータスフィルタによりPURCHASE/DONEのみ表示

4. **フィルターモーダル**
   - 高度な検索条件の設定

## 入出力項目

該当なし（一覧画面のため、入力項目はフィルター条件のみ）

## 表示項目

| No | 項目名 | データ型 | 説明 | デフォルト表示 |
|----|--------|----------|------|---------------|
| 1 | 優先度（priority） | アイコン | スター表示、クリックで切り替え可能 | 表示 |
| 2 | 仕入先参照（partner_reference） | テキスト | 仕入先の参照番号 | 非表示 |
| 3 | 参照番号（name） | テキスト | 発注書番号（PO/XXX形式） | 表示 |
| 4 | 仕入先（partner.name） | テキスト | 仕入先名 | 表示 |
| 5 | 会社（company.name） | テキスト | 所属会社名 | 表示 |
| 6 | 購買担当者（user.name） | テキスト | 担当者名 | 表示 |
| 7 | 発注日（ordered_at） | 日時 | 発注確定日時 | 表示 |
| 8 | 元伝票（origin） | テキスト | ソースドキュメント | 表示 |
| 9 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額 | 表示 |
| 10 | 合計金額（total_amount） | 通貨 | 税込合計金額 | 表示 |
| 11 | 請求ステータス（invoice_status） | バッジ | 請求状況 | 表示 |
| 12 | ステータス（state） | バッジ | 発注書のステータス | 非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、発注書作成画面（CreatePurchaseOrder）に遷移します。

### 2-優先度アイコンクリック

一覧の優先度（スター）アイコンをクリックすると、該当レコードの`priority`フィールドが反転します。

### 3-行アクション（表示・編集・削除）

各行の右端にあるアクションメニューから以下の操作が可能：
- 表示：発注書詳細画面に遷移
- 編集：発注書編集画面に遷移
- 削除：確認後、発注書を削除（DONE状態の場合は非表示）

### 4-一括削除

チェックボックスで複数選択し、一括削除を実行できます。

### 5-フィルター適用

フィルターモーダルで条件を設定し、適用ボタンを押すとテーブルデータがフィルタリングされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | purchases_orders | SELECT | state=PURCHASE/DONEの発注書取得 |
| 優先度変更 | purchases_orders | UPDATE | priorityカラムの更新 |
| 削除 | purchases_orders | DELETE | 発注書レコードの削除 |
| 一括削除 | purchases_orders | DELETE | 複数発注書レコードの削除 |

### テーブル別更新項目詳細

#### purchases_orders

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | state IN (PURCHASE, DONE) | クエリ修正により絞り込み |
| UPDATE | priority | !current_value | スター切り替え時 |
| DELETE | - | id = 指定ID | 削除時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | delete.notification.success | 発注書が正常に削除されました | 削除成功時 |
| 2 | エラー | delete.notification.error | 関連データが存在するため、削除できません | 削除失敗時 |
| 3 | 成功 | bulk-delete.notification.success | 選択した発注書が正常に削除されました | 一括削除成功時 |
| 4 | エラー | bulk-delete.notification.error | 関連データが存在するため、一部の削除ができません | 一括削除失敗時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | データが見つからない | 空のテーブルを表示、データなしメッセージ表示 |
| 2 | 削除時のFK制約違反 | エラー通知を表示し、処理を中断 |
| 3 | 権限不足 | 該当操作ボタンを非表示、または操作時にエラー表示 |
| 4 | 通信エラー | 一般的なエラー通知を表示 |

## 備考

- 本画面はFilament PHPの`ListRecords`コンポーネントを継承して実装
- `PurchaseOrderResource`は`OrderResource`を継承し、テーブルにクエリ修正を追加
- `modifyQueryUsing`により`state IN (PURCHASE, DONE)`の条件が常に適用される
- これにより見積依頼（DRAFT/SENT状態）は本一覧には表示されない
- プリセットビューは`ListPurchaseOrders`クラスで独自に定義
- 見積依頼一覧とは異なるプリセットビューが提供される
