# 画面設計書 256-発注書作成

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「発注書作成」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、新規発注書（Purchase Order）を直接作成するための画面です。見積依頼プロセスを経ずに、直接発注書を作成する場合に使用します。

**業務上の目的・背景**：
定型的な発注や、見積もり不要な仕入先への発注において、効率的に発注書を作成するための画面です。作成された発注書はPURCHASE状態で登録されます。

**画面へのアクセス方法**：
1. 発注書一覧画面の「新規作成」ボタンをクリック
2. URL直接アクセス：`/admin/purchases/orders/purchase-orders/create`

**主要な操作・処理内容**：
1. 基本情報（仕入先、担当者、通貨、日付等）の入力
2. 注文明細（商品、数量、単価等）の登録
3. 追加情報（カスタムフィールド、備考等）の入力
4. 発注書の保存

**画面遷移**：
- 遷移元：発注書一覧画面
- 遷移先：発注書編集画面（作成成功後）

**権限による表示制御**：
購買モジュールの作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-006 | 発注書作成 | 主機能 | 発注書データの新規登録 |
| FN-PURCH-005 | 発注書一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-007 | 発注書編集 | 遷移先機能 | 作成成功後の編集画面遷移 |

## 画面種別

作成（Create）

## URL/ルーティング

`/admin/purchases/orders/purchase-orders/create`

## 画面構成

見積依頼作成画面（252-見積依頼作成）と同様の構成です。

1. **進捗ステッパー**
   - ステータス表示（DRAFT → SENT → PURCHASE → DONE）

2. **基本情報セクション**
   - 仕入先選択
   - 請求先・配送先連絡先
   - 通貨選択
   - 発注期限・入荷予定日
   - 購買担当者・会社選択

3. **タブセクション**
   - 商品タブ：注文明細の入力
   - その他情報タブ：追加設定
   - 備考タブ：利用規約等

4. **フッターアクション**
   - 保存ボタン
   - キャンセルボタン

## 入出力項目

見積依頼作成画面（252-見積依頼作成）と同様です。

| No | 項目名 | データ型 | 必須 | 初期値 | バリデーション | 説明 |
|----|--------|----------|------|--------|----------------|------|
| 1 | 仕入先（partner_id） | Integer/Select | ○ | - | 存在確認 | 仕入先マスタから選択 |
| 2 | 請求先連絡先（invoice_address_id） | Integer/Select | - | - | - | 請求先住所 |
| 3 | 配送先連絡先（delivery_address_id） | Integer/Select | - | - | - | 配送先住所 |
| 4 | 購買担当者（user_id） | Integer/Select | - | ログインユーザー | - | 担当者選択 |
| 5 | 通貨（currency_id） | Integer/Select | ○ | 会社デフォルト | - | 通貨マスタから選択 |
| 6 | 発注日（ordered_at） | DateTime | - | - | 日付形式 | 発注日時 |
| 7 | 入荷予定日（planned_at） | DateTime | - | - | 日付形式 | 入荷予定日時 |
| 8 | 会社（company_id） | Integer/Select | ○ | ユーザーデフォルト会社 | - | 会社マスタから選択 |
| 9 | 財務ポジション（fiscal_position_id） | Integer/Select | - | - | - | 財務ポジション選択 |
| 10 | インコタームズ（incoterm_id） | Integer/Select | - | - | - | インコタームズ選択 |
| 11 | 支払条件（payment_term_id） | Integer/Select | - | - | - | 支払条件選択 |
| 12 | 入庫タイプ（operation_type_id） | Integer/Select | - | - | - | 入庫オペレーションタイプ |
| 13 | 備考（description） | Text/RichEditor | - | - | - | 利用規約・備考 |

## 表示項目

見積依頼作成画面（252-見積依頼作成）と同様です。

## イベント仕様

### 1-仕入先選択変更

仕入先（partner_id）を選択すると、関連連絡先がフィルタリングされ、デフォルト設定が自動適用されます。

### 2-商品選択変更

商品（product_id）を選択すると、商品情報（価格、単位等）が自動設定されます。

### 3-数量・単価変更

数量または単価が変更されると、小計が再計算されます。

### 4-保存ボタン押下

フォーム内容を検証し、問題がなければ発注書を作成します。作成成功後、編集画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | purchases_orders | INSERT | 発注書ヘッダーの作成 |
| 保存 | purchases_order_lines | INSERT | 発注書明細の作成 |
| 保存 | purchases_order_line_taxes | INSERT | 明細税の関連付け |

### テーブル別更新項目詳細

#### purchases_orders（INSERT）

| 項目（カラム名） | 値・取得元 | 備考 |
|-----------------|-----------|------|
| name | 自動生成（PO/{id}） | 作成後に更新 |
| state | DRAFT | 固定値（見積依頼と同じ初期状態） |
| invoice_status | NO | 固定値 |
| partner_id | フォーム入力 | 必須 |
| currency_id | フォーム入力 | 必須 |
| user_id | フォーム入力 or ログインユーザー | - |
| company_id | フォーム入力 | 必須 |
| creator_id | ログインユーザーID | 自動設定 |
| ordered_at | フォーム入力 | - |
| planned_at | フォーム入力 | - |
| untaxed_amount | 計算値 | 明細小計の合計 |
| tax_amount | 計算値 | 税額の合計 |
| total_amount | 計算値 | 税込合計 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | create.notification.success.title | 作成完了 | 作成成功時 |
| 2 | 成功 | create.notification.success.body | 発注書が正常に作成されました | 作成成功時 |
| 3 | エラー | validation.required | {field}は必須です | 必須項目未入力時 |
| 4 | エラー | validation.numeric | {field}は数値で入力してください | 数値項目に非数値入力時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | 必須項目未入力 | バリデーションエラー表示、該当項目をハイライト |
| 2 | 仕入先が存在しない（削除済み） | 選択不可として表示 |
| 3 | 商品が存在しない（削除済み） | 選択不可として表示 |
| 4 | DB保存エラー | エラー通知を表示、ロールバック |
| 5 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |

## 備考

- 本画面は`CreatePurchaseOrder`クラスで実装され、`CreateOrder`を継承
- フォームスキーマは親クラス`OrderResource`で定義（見積依頼と共通）
- 発注書作成画面と見積依頼作成画面は同一のフォーム構造を使用
- 違いは所属するResourceクラスとリダイレクト先のURL
- 作成後のワークフローは見積依頼と同様（確認→発注確認→完了）
- 直接発注書を作成する場合でも初期状態はDRAFTで、発注確認操作が必要
