# 画面設計書 257-発注書編集

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「発注書編集」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、既存の発注書（Purchase Order）を編集・更新するための画面です。発注書のステータスに応じて編集可能な項目が制御され、関連する入庫・請求書管理も行えます。

**業務上の目的・背景**：
発注済みの注文内容の修正、完了処理、および関連する入庫オペレーションや請求書との連携を管理するための画面です。

**画面へのアクセス方法**：
1. 発注書一覧画面から対象レコードの「編集」をクリック
2. 発注書詳細画面の「編集」ボタンをクリック
3. 発注書作成成功後の自動遷移
4. URL直接アクセス：`/admin/purchases/orders/purchase-orders/{record}/edit`

**主要な操作・処理内容**：
1. 発注書内容の編集・保存
2. ステータス管理（完了、キャンセル等）
3. 入庫オペレーションの確認・管理
4. 請求書の作成・管理
5. メール送信・印刷

**画面遷移**：
- 遷移元：発注書一覧画面、発注書詳細画面、発注書作成画面
- 遷移先：発注書詳細画面、入庫管理画面、請求書管理画面

**権限による表示制御**：
購買モジュールの編集権限を持つユーザーのみがアクセス可能です。ステータスによって編集可能な項目が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-007 | 発注書編集 | 主機能 | 発注書データの編集・更新 |
| FN-PURCH-005 | 発注書一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-008 | 発注書表示 | 関連機能 | サブナビゲーションで連携 |
| FN-INVT-XXX | 入庫管理 | 関連機能 | 入庫オペレーション管理 |
| FN-ACCT-XXX | 請求書管理 | 関連機能 | 仕入先請求書管理 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/admin/purchases/orders/purchase-orders/{record}/edit`

## 画面構成

1. **サブナビゲーション**
   - 詳細表示（ViewPurchaseOrder）
   - 編集（EditPurchaseOrder）- 現在画面
   - 請求書（ManageBills）
   - 入庫（ManageReceipts）

2. **ヘッダーアクション**
   - 請求書作成ボタン（入庫後に表示）
   - 完了ボタン（全入庫完了時）
   - キャンセルボタン
   - 印刷ボタン
   - メール送信ボタン

3. **進捗ステッパー**
   - ステータス表示（DRAFT → SENT → PURCHASE → DONE）

4. **基本情報セクション**
   - 見積依頼編集画面と同様

5. **タブセクション**
   - 商品タブ：注文明細の編集（入庫済数量・請求済数量の表示含む）
   - その他情報タブ：追加設定
   - 備考タブ：利用規約等

6. **金額サマリー**
   - 税抜金額、税額、合計金額の表示

## 入出力項目

見積依頼編集画面（253-見積依頼編集）と同様ですが、発注書固有の制御が追加されます。

| No | 項目名 | データ型 | 必須 | 編集可否条件 | バリデーション | 説明 |
|----|--------|----------|------|-------------|----------------|------|
| 1 | 仕入先（partner_id） | Integer/Select | ○ | state=DRAFT時のみ | 存在確認 | 仕入先マスタから選択 |
| 2 | 請求先連絡先（invoice_address_id） | Integer/Select | - | state != DONE | - | 請求先住所 |
| 3 | 配送先連絡先（delivery_address_id） | Integer/Select | - | state != DONE | - | 配送先住所 |
| 4 | 購買担当者（user_id） | Integer/Select | - | state != DONE | - | 担当者選択 |
| 5 | 通貨（currency_id） | Integer/Select | ○ | state=DRAFT時のみ | - | 通貨マスタから選択 |
| 6 | 発注日（ordered_at） | DateTime | - | state != DONE | 日付形式 | 発注日時 |
| 7 | 入荷予定日（planned_at） | DateTime | - | state != DONE | 日付形式 | 入荷予定日時 |
| 8 | 会社（company_id） | Integer/Select | ○ | state=DRAFT時のみ | - | 会社マスタから選択 |

### 注文明細の追加表示項目

| No | 項目名 | データ型 | 説明 | 編集可否 |
|----|--------|----------|------|---------|
| 1 | 入庫済数量（qty_received） | 数値 | 入庫完了した数量 | 読み取り専用 |
| 2 | 請求済数量（qty_invoiced） | 数値 | 請求済みの数量 | 読み取り専用 |
| 3 | 請求可能数量（qty_to_invoice） | 数値 | 請求可能な数量（入庫済み - 請求済み） | 読み取り専用 |

## 表示項目

見積依頼編集画面と同様に加え、以下の発注書固有項目が表示されます。

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 1 | 入庫数（receipts_count） | 数値 | 関連入庫オペレーション数 | 常時 |
| 2 | 請求書数（bills_count） | 数値 | 関連請求書数 | 常時 |
| 3 | 入庫ステータス（receipt_status） | バッジ | 入庫状況 | 常時 |
| 4 | 請求ステータス（invoice_status） | バッジ | 請求状況 | 常時 |

## イベント仕様

### 1-請求書作成ボタン押下

入庫済み数量があり、請求可能な場合に表示されます。押下すると仕入先請求書を作成します。

### 2-完了ボタン押下

全ての入庫と請求が完了している場合に表示されます。押下すると発注書のステータスをDONEに変更します。

### 3-キャンセルボタン押下

発注書をキャンセルします。関連する入庫オペレーションがキャンセルされていない場合は警告が表示されます。

### 4-印刷ボタン押下

発注書のPDFをダウンロードまたは印刷します。

### 5-メール送信ボタン押下

発注書をメールで送信するためのモーダルを表示します。

### 6-保存ボタン押下

フォーム内容を検証し、問題がなければ発注書を更新します。

### 7-請求書タブクリック

サブナビゲーションの「請求書」をクリックすると請求書管理画面（ManageBills）に遷移します。

### 8-入庫タブクリック

サブナビゲーションの「入庫」をクリックすると入庫管理画面（ManageReceipts）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | purchases_orders | UPDATE | 発注書ヘッダーの更新 |
| 保存 | purchases_order_lines | UPDATE/INSERT/DELETE | 発注書明細の更新 |
| 完了 | purchases_orders | UPDATE | ステータス変更 |
| キャンセル | purchases_orders | UPDATE | ステータス変更 |
| 請求書作成 | accounts_moves | INSERT | 仕入先請求書の作成 |

### テーブル別更新項目詳細

#### purchases_orders（完了時UPDATE）

| 項目（カラム名） | 更新値 | 備考 |
|-----------------|--------|------|
| state | DONE | 完了時 |
| receipt_status | RECEIVED | 全入庫完了時 |

#### purchases_orders（キャンセル時UPDATE）

| 項目（カラム名） | 更新値 | 備考 |
|-----------------|--------|------|
| state | CANCELED | キャンセル時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | save.notification.success | 発注書が正常に更新されました | 保存成功時 |
| 2 | 成功 | done.notification.success | 発注書が完了しました | 完了成功時 |
| 3 | 成功 | cancel.notification.success | 発注書がキャンセルされました | キャンセル成功時 |
| 4 | 成功 | create-bill.notification.success | 請求書が作成されました | 請求書作成成功時 |
| 5 | 警告 | cancel.confirm.title | 本当にキャンセルしますか？ | キャンセル確認時 |
| 6 | 警告 | cancel.warning.pending-receipts | 未処理の入庫オペレーションがあります | 入庫未完了時のキャンセル |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | 必須項目未入力 | バリデーションエラー表示 |
| 2 | レコードが見つからない | 404エラー、一覧画面にリダイレクト |
| 3 | 入庫オペレーションが進行中 | キャンセル不可の警告表示 |
| 4 | 請求書が存在する | 削除不可の警告表示 |
| 5 | 同時編集の競合 | 最新データで上書きまたはエラー表示 |
| 6 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |

## 備考

- 本画面は`EditPurchaseOrder`クラスで実装され、`EditOrder`を継承
- サブナビゲーションにManageBills、ManageReceiptsが追加される（見積依頼との違い）
- 発注書は入庫オペレーションと連携しており、入庫状況が表示される
- 請求書作成機能により、発注書から直接仕入先請求書を生成可能
- 入庫済み数量・請求済み数量は明細ごとにトラッキングされる
- DONE状態の発注書は基本的に編集不可
