# 画面設計書 258-発注書詳細

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「発注書詳細」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、既存の発注書（Purchase Order）の詳細情報を読み取り専用で表示するための画面です。発注書の全体像、入庫状況、請求状況を確認できます。

**業務上の目的・背景**：
購買担当者や管理者が発注書の内容を確認するための参照画面です。関連する入庫オペレーションや請求書へのナビゲーションも提供します。

**画面へのアクセス方法**：
1. 発注書一覧画面から対象レコードの「表示」をクリック
2. URL直接アクセス：`/admin/purchases/orders/purchase-orders/{record}`

**主要な操作・処理内容**：
1. 発注書詳細情報の閲覧
2. 編集画面への遷移
3. 入庫管理・請求書管理画面への遷移
4. 各種アクション実行

**画面遷移**：
- 遷移元：発注書一覧画面
- 遷移先：発注書編集画面、入庫管理画面、請求書管理画面

**権限による表示制御**：
購買モジュールの閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-008 | 発注書表示 | 主機能 | 発注書データの詳細表示 |
| FN-PURCH-005 | 発注書一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-007 | 発注書編集 | 遷移先機能 | サブナビゲーションで連携 |

## 画面種別

詳細（View）

## URL/ルーティング

`/admin/purchases/orders/purchase-orders/{record}`

## 画面構成

1. **サブナビゲーション**
   - 詳細表示（ViewPurchaseOrder）- 現在画面
   - 編集（EditPurchaseOrder）
   - 請求書（ManageBills）
   - 入庫（ManageReceipts）

2. **ヘッダーアクション**
   - 請求書作成ボタン（条件付き表示）
   - 完了ボタン（条件付き表示）
   - キャンセルボタン（条件付き表示）
   - 印刷ボタン
   - メール送信ボタン

3. **ステータスセクション**
   - 現在のステータスバッジ表示
   - 入庫ステータス
   - 請求ステータス

4. **基本情報セクション**
   - 仕入先情報
   - 担当者・会社情報
   - 日付情報
   - 通貨情報

5. **タブセクション**
   - 商品タブ：注文明細の表示（入庫・請求情報含む）
   - その他情報タブ：追加設定表示
   - 備考タブ：利用規約等

6. **金額サマリー**
   - 税抜金額、税額、合計金額の表示

7. **メタデータセクション**
   - 作成日時、作成者、更新日時

## 入出力項目

該当なし（読み取り専用画面のため入力項目なし）

## 表示項目

### 基本情報セクション

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 1 | ステータス（state） | バッジ | 発注書の現在ステータス | 常時 |
| 2 | 入庫ステータス（receipt_status） | バッジ | 入庫状況 | 常時 |
| 3 | 請求ステータス（invoice_status） | バッジ | 請求状況 | 常時 |
| 4 | 仕入先（partner.name） | テキスト | 仕入先名 | 常時 |
| 5 | 購買担当者（user.name） | テキスト | 担当者名 | 常時 |
| 6 | 通貨（currency.name） | テキスト | 通貨名 | 常時 |
| 7 | 発注日（ordered_at） | 日時 | 発注確定日時 | 常時 |
| 8 | 入荷予定日（planned_at） | 日時 | 入荷予定日時 | 常時 |
| 9 | 会社（company.name） | テキスト | 会社名 | 常時 |

### 注文明細（lines）

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 10 | 商品（product.name） | テキスト | 商品名 | 常時 |
| 11 | 説明（name） | テキスト | 商品説明 | 常時 |
| 12 | 数量（product_qty） | 数値 | 発注数量 | 常時 |
| 13 | 入庫済数量（qty_received） | 数値 | 入庫完了した数量 | 常時 |
| 14 | 請求済数量（qty_invoiced） | 数値 | 請求済みの数量 | 常時 |
| 15 | 単位（productUom.name） | テキスト | 単位名 | UOM設定有効時 |
| 16 | 単価（price_unit） | 通貨 | 単価 | 常時 |
| 17 | 税（taxes） | リスト | 適用税リスト | 常時 |
| 18 | 小計（price_subtotal） | 通貨 | 税抜小計 | 常時 |

### 金額サマリー

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 19 | 税抜金額（untaxed_amount） | 通貨 | 税抜合計金額 | 常時 |
| 20 | 税額（tax_amount） | 通貨 | 税額合計 | 常時 |
| 21 | 合計金額（total_amount） | 通貨 | 税込合計金額 | 常時 |

### メタデータセクション

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|---------|
| 22 | 作成日時（created_at） | 日時 | レコード作成日時 | 常時 |
| 23 | 作成者（creator.name） | テキスト | 作成者名 | 常時 |
| 24 | 更新日時（updated_at） | 日時 | 最終更新日時 | 常時 |

## イベント仕様

### 1-請求書作成ボタン押下

入庫済み数量があり、請求可能な場合に表示されます。押下すると仕入先請求書を作成します。

### 2-完了ボタン押下

全ての入庫と請求が完了している場合に表示されます。押下すると発注書のステータスをDONEに変更します。

### 3-キャンセルボタン押下

発注書をキャンセルします。

### 4-印刷ボタン押下

発注書のPDFをダウンロードまたは印刷します。

### 5-メール送信ボタン押下

発注書をメールで送信するためのモーダルを表示します。

### 6-編集タブクリック

サブナビゲーションの「編集」をクリックすると編集画面に遷移します。

### 7-請求書タブクリック

サブナビゲーションの「請求書」をクリックすると請求書管理画面に遷移します。

### 8-入庫タブクリック

サブナビゲーションの「入庫」をクリックすると入庫管理画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | purchases_orders | SELECT | 発注書データの取得 |
| 画面表示 | purchases_order_lines | SELECT | 発注書明細の取得 |
| 完了 | purchases_orders | UPDATE | ステータス変更 |
| キャンセル | purchases_orders | UPDATE | ステータス変更 |
| 請求書作成 | accounts_moves | INSERT | 仕入先請求書の作成 |

※詳細なデータベース更新仕様は「発注書編集」画面設計書を参照

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | done.notification.success | 発注書が完了しました | 完了成功時 |
| 2 | 成功 | cancel.notification.success | 発注書がキャンセルされました | キャンセル成功時 |
| 3 | 成功 | create-bill.notification.success | 請求書が作成されました | 請求書作成成功時 |
| 4 | 情報 | data.empty | データがありません | 明細が空の場合 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | レコードが見つからない | 404エラー、一覧画面にリダイレクト |
| 2 | 権限不足 | アクセス拒否、一覧画面にリダイレクト |
| 3 | アクション実行時のエラー | エラー通知を表示 |

## 備考

- 本画面は`ViewPurchaseOrder`クラスで実装され、`ViewOrder`を継承
- 情報表示はInfolist（Infolist）を使用して構造化された形式で表示
- サブナビゲーションに請求書・入庫管理が追加される（見積依頼詳細との違い）
- 入庫済み数量・請求済み数量が明細テーブルに表示される
- ヘッダーアクションは編集画面と同一のものを共有
- 発注書固有のステータス（入庫・請求）がステータスセクションに表示される
