# 画面設計書 259-購買契約一覧

## 概要

本ドキュメントは、Aureus ERPの購買モジュールにおける「購買契約一覧」画面の設計仕様を定義するものです。

### 本画面の処理概要

本画面は、購買契約（Purchase Agreement）の一覧を表示・管理するための画面です。包括発注（Blanket Order）と購買テンプレート（Purchase Template）の2種類の契約を管理します。

**業務上の目的・背景**：
仕入先との長期的な購買契約や、繰り返し使用する購買テンプレートを管理するための画面です。包括発注により、一定期間の価格・数量を事前に合意し、効率的な調達を実現します。

**画面へのアクセス方法**：
メインナビゲーション > 購買（Purchases）クラスター > 注文（Orders）> 購買契約（Purchase Agreements）を選択してアクセスします。

**主要な操作・処理内容**：
1. 購買契約の一覧表示（テーブル形式）
2. プリセットビューによる絞り込み（マイ契約、包括発注、購買テンプレート、下書き、完了、アーカイブ）
3. 高度なフィルタリング・検索機能
4. 購買契約の新規作成画面への遷移
5. 各購買契約の詳細・編集・削除操作

**画面遷移**：
- 遷移元：ダッシュボード、購買クラスターナビゲーション
- 遷移先：購買契約作成画面、購買契約詳細画面、購買契約編集画面

**権限による表示制御**：
ユーザーの購買モジュールに対する権限に応じて、作成・編集・削除ボタンの表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-009 | 購買契約一覧 | 主機能 | 購買契約データの一覧表示、検索、フィルタ、グループ化、ソート |
| FN-PURCH-010 | 購買契約作成 | 遷移先機能 | 新規購買契約の作成画面への遷移 |
| FN-PURCH-012 | 購買契約表示 | 遷移先機能 | 購買契約詳細の表示画面への遷移 |
| FN-PURCH-011 | 購買契約編集 | 遷移先機能 | 購買契約編集画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/purchases/orders/purchase-agreements`

## 画面構成

1. **ヘッダーアクション**
   - 新規作成ボタン（「+ 新規購買契約」）

2. **プリセットビュー（タブ）**
   - マイ契約（my_agreements）：ログインユーザーの担当する契約
   - 包括発注（blanket_orders）：タイプが包括発注の契約
   - 購買テンプレート（purchase_templates）：タイプが購買テンプレートの契約
   - 下書き（draft）：DRAFT状態の契約
   - 完了（done）：CLOSED状態の契約
   - アーカイブ（archived）：ソフトデリートされた契約

3. **データテーブル**
   - 購買契約固有のカラム構成

4. **フィルターモーダル**
   - 高度な検索条件の設定

## 入出力項目

該当なし（一覧画面のため、入力項目はフィルター条件のみ）

## 表示項目

| No | 項目名 | データ型 | 説明 | デフォルト表示 |
|----|--------|----------|------|---------------|
| 1 | 契約番号（name） | テキスト | 契約番号（BO/XXXまたはPT/XXX形式） | 表示 |
| 2 | 仕入先（partner.name） | テキスト | 仕入先名 | 表示 |
| 3 | 契約タイプ（type） | バッジ | 包括発注/購買テンプレート | 表示 |
| 4 | 購買担当者（user.name） | テキスト | 担当者名 | 表示 |
| 5 | 会社（company.name） | テキスト | 所属会社名 | 表示 |
| 6 | 有効開始日（starts_at） | 日付 | 契約開始日 | 表示 |
| 7 | 有効終了日（ends_at） | 日付 | 契約終了日 | 表示 |
| 8 | 参照番号（reference） | テキスト | 外部参照番号 | 表示 |
| 9 | ステータス（state） | バッジ | 契約のステータス | 表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「新規作成」ボタンをクリックすると、購買契約作成画面（CreatePurchaseAgreement）に遷移します。

### 2-行アクション（表示・編集・削除・復元・完全削除）

各行の右端にあるアクションメニューから以下の操作が可能：
- 表示：購買契約詳細画面に遷移（アーカイブ済みでない場合）
- 編集：購買契約編集画面に遷移（アーカイブ済みでない場合）
- 復元：アーカイブ済みの契約を復元
- 削除：契約をアーカイブ（CLOSED状態でない場合）
- 完全削除：アーカイブ済みの契約を完全削除

### 3-一括操作

チェックボックスで複数選択し、以下の一括操作が可能：
- 一括復元
- 一括削除（アーカイブ）
- 一括完全削除

### 4-フィルター適用

フィルターモーダルで条件を設定し、適用ボタンを押すとテーブルデータがフィルタリングされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | purchases_requisitions | SELECT | 購買契約データの取得 |
| 削除（アーカイブ） | purchases_requisitions | UPDATE | deleted_atを設定 |
| 復元 | purchases_requisitions | UPDATE | deleted_atをnullに |
| 完全削除 | purchases_requisitions | DELETE | レコードの完全削除 |

### テーブル別更新項目詳細

#### purchases_requisitions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | orderByDesc('id') | ID降順で取得 |
| UPDATE（アーカイブ） | deleted_at | now() | ソフトデリート |
| UPDATE（復元） | deleted_at | null | 復元時 |
| DELETE | - | id = 指定ID | 完全削除時 |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 | 表示条件 |
|----|------|-------------|--------------|---------|
| 1 | 成功 | delete.notification.success | 購買契約が正常にアーカイブされました | 削除成功時 |
| 2 | 成功 | restore.notification.success | 購買契約が正常に復元されました | 復元成功時 |
| 3 | 成功 | force-delete.notification.success | 購買契約が完全に削除されました | 完全削除成功時 |
| 4 | エラー | force-delete.notification.error | 関連データが存在するため、削除できません | 完全削除失敗時 |
| 5 | 成功 | bulk-delete.notification.success | 選択した購買契約が正常にアーカイブされました | 一括削除成功時 |
| 6 | 成功 | bulk-restore.notification.success | 選択した購買契約が正常に復元されました | 一括復元成功時 |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|---------|---------|
| 1 | データが見つからない | 空のテーブルを表示、データなしメッセージ表示 |
| 2 | 完全削除時のFK制約違反 | エラー通知を表示し、処理を中断 |
| 3 | 権限不足 | 該当操作ボタンを非表示、または操作時にエラー表示 |
| 4 | 通信エラー | 一般的なエラー通知を表示 |

## 備考

- 本画面はFilament PHPの`ListRecords`コンポーネントを継承して実装
- `PurchaseAgreementResource`は独自の`Resource`クラスとして実装（OrderResourceを継承しない）
- ソフトデリート（SoftDeletes）を使用してアーカイブ機能を実現
- 契約番号は包括発注の場合「BO/XXX」、購買テンプレートの場合「PT/XXX」形式
- 機能の有効/無効は`OrderSettings`の`enable_purchase_agreements`設定に依存
- グループ化機能により、仕入先別、タイプ別、ステータス別などでデータを集約表示可能
- CLOSED状態の契約は削除（アーカイブ）不可
