# 画面設計書 26-請求書作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける請求書作成画面の設計仕様を定義します。この画面では新規の請求書（Invoice）を作成し、顧客への売上請求を登録します。

### 本画面の処理概要

**業務上の目的・背景**：
請求書作成は売上管理の起点となる重要な業務プロセスです。顧客情報、請求明細（商品・数量・単価・税）、支払条件などを入力し、正確な請求書を発行することで、適切な売掛金管理と収益認識を実現します。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 「請求書」メニューを選択して一覧画面へ遷移
3. ヘッダーの「作成」ボタンをクリック

**主要な操作・処理内容**：
1. 基本情報の入力（顧客、請求日、支払期日/支払条件）
2. 請求明細の入力（商品選択、数量、単価、税、割引）
3. その他情報の入力（担当者、受取銀行口座、インコタームズ等）
4. 利用規約・条件の入力
5. 保存して請求書を作成

**画面遷移**：
- 遷移元：請求書一覧画面
- 遷移先：請求書詳細画面（作成成功時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-001 | 請求書管理 | 主機能 | 請求書の新規作成 |
| FN-ACC-002 | 支払管理 | 参照機能 | 支払条件・支払方法の参照 |
| FN-ACC-003 | 会計仕訳 | 後処理 | 作成後の仕訳計算 |

## 画面種別

作成（Create）

## URL/ルーティング

`/admin/accounts/invoices/create`

## 画面構成

- ステータスステッパー（無効化、表示のみ）
- 基本情報セクション
  - 支払ステータスアクション（作成時は非表示）
  - 顧客選択
  - 請求日・支払期日/支払条件
- タブ構成
  - 請求明細タブ
    - 商品リピーター（テーブル形式）
    - 請求サマリー（Livewireコンポーネント）
  - その他情報タブ
    - 請求情報フィールドセット
    - 会計情報フィールドセット
    - 追加情報フィールドセット
    - マーケティング情報フィールドセット
  - 利用規約タブ
    - リッチエディタ

## 入出力項目

### 基本情報

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| ステータス | state | 出力 | enum | - | DRAFT | ProgressStepper表示 |
| 顧客 | partner_id | 入力 | integer | - | null | 顧客サブタイプのパートナーのみ |
| 請求日 | invoice_date | 入力 | date | - | 今日 | ネイティブ日付選択無効 |
| 支払期日 | invoice_date_due | 入力 | date | ※ | 今日 | 支払条件未設定時は必須 |
| 支払条件 | invoice_payment_term_id | 入力 | integer | ※ | null | 支払期日未設定時は必須 |

### 請求明細（リピーター）

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| 商品 | product_id | 入力 | integer | ○ | null | 設定可能商品のみ |
| 数量 | quantity | 入力 | decimal | ○ | 1 | 最大99999999999 |
| 単位 | uom_id | 入力 | integer | ○ | 商品のUOM | UOM有効時のみ表示 |
| 税 | taxes | 入力 | array | - | 商品の税 | 複数選択可、販売税のみ |
| 割引率 | discount | 入力 | decimal | - | 0 | 0-99999999999 |
| 単価 | price_unit | 入力 | decimal | ○ | 商品価格 | 最大99999999999 |
| 小計 | price_subtotal | 出力 | decimal | - | 0 | 自動計算 |
| 税額 | price_tax | 隠し | decimal | - | 0 | 自動計算 |
| 合計 | price_total | 隠し | decimal | - | 0 | 自動計算 |
| UOM数量 | product_uom_qty | 隠し | decimal | - | 0 | 自動計算 |

### その他情報

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| 顧客参照 | reference | 入力 | string | - | null | 最大255文字 |
| 担当者 | invoice_user_id | 入力 | integer | - | null | 顧客選択時に自動設定 |
| 受取銀行口座 | partner_bank_id | 入力 | integer | - | null | - |
| 支払参照 | payment_reference | 入力 | string | - | null | - |
| 納品日 | delivery_date | 入力 | date | - | null | - |
| インコターム | invoice_incoterm_id | 入力 | integer | - | null | - |
| インコターム場所 | incoterm_location | 入力 | string | - | null | - |
| 支払方法 | preferred_payment_method_line_id | 入力 | integer | - | null | 顧客選択時に自動設定 |
| 自動転記 | auto_post | 入力 | boolean | - | false | - |
| 確認済み | checked | 入力 | boolean | - | false | - |
| 会社 | company_id | 入力 | integer | - | ユーザーのデフォルト会社 | - |
| 通貨 | currency_id | 入力 | integer | ○ | 会社の通貨 | - |
| キャンペーン | campaign_id | 入力 | integer | - | null | - |
| メディア | medium_id | 入力 | integer | - | null | - |
| ソース | source_id | 入力 | integer | - | null | - |

### 利用規約

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| 利用規約 | narration | 入力 | text | - | null | リッチエディタ |

## 表示項目

作成画面のため、入出力項目と同一。

## イベント仕様

### 1-顧客選択時

1. 選択された顧客情報を取得
2. invoice_user_idに顧客のuser_idを設定
3. preferred_payment_method_line_idに顧客のpropertyInboundPaymentMethodLineを設定
4. invoice_payment_term_idに顧客のpropertyPaymentTermを設定

### 2-商品選択時

1. 選択された商品情報を取得
2. uom_idに商品のUOMを設定
3. price_unitに商品価格をUOM換算して設定
4. taxesに商品の税を設定
5. product_uom_qtyをUOM換算して設定
6. 小計を再計算

### 3-数量変更時

1. product_uom_qtyをUOM換算して更新
2. 小計を再計算

### 4-UOM変更時

1. product_uom_qtyを更新
2. price_unitをUOM換算して更新
3. 小計を再計算

### 5-税・割引・単価変更時

1. 小計（price_subtotal）を再計算
2. 税額（price_tax）を再計算
3. 合計（price_total）を再計算

### 6-会社変更時

1. currency_idを選択された会社の通貨に更新

### 7-保存ボタン押下

1. フォームバリデーション実行
2. `mutateFormDataBeforeCreate`でmove_type、dateを設定
3. データベースに新規レコードを挿入
4. `afterCreate`でAccount::computeAccountMoveを実行（仕訳計算）
5. 成功通知を表示
6. 詳細画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | account_moves | INSERT | 請求書ヘッダーの作成 |
| 保存ボタン押下 | account_move_lines | INSERT | 請求明細の作成 |
| 保存ボタン押下 | account_move_line_tax | INSERT | 明細-税の関連付け |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | MoveType::OUT_INVOICE | 自動設定 |
| INSERT | date | now() | 自動設定 |
| INSERT | partner_id | フォーム入力値 | nullable |
| INSERT | invoice_date | フォーム入力値 | - |
| INSERT | invoice_date_due | フォーム入力値 | nullable |
| INSERT | invoice_payment_term_id | フォーム入力値 | nullable |
| INSERT | currency_id | フォーム入力値 | 必須 |
| INSERT | company_id | フォーム入力値 | - |
| INSERT | state | DRAFT | 初期値 |
| INSERT | その他フィールド | フォーム入力値 | - |

#### account_move_lines

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_id | 親レコードのID | 自動設定 |
| INSERT | product_id | フォーム入力値 | 必須 |
| INSERT | quantity | フォーム入力値 | 必須 |
| INSERT | price_unit | フォーム入力値 | 必須 |
| INSERT | discount | フォーム入力値 | - |
| INSERT | price_subtotal | 計算値 | 自動計算 |
| INSERT | price_tax | 計算値 | 自動計算 |
| INSERT | price_total | 計算値 | 自動計算 |
| INSERT | currency_id | 親レコードのcurrency_id | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| create-invoice.notification.title | 成功 | 作成成功タイトル | 作成処理成功時 |
| create-invoice.notification.body | 成功 | 作成成功メッセージ本文 | 作成処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 権限不足 | 作成権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| バリデーションエラー | 必須項目未入力など | フォームにエラーメッセージを表示 |
| 商品重複選択 | 同一商品を複数行で選択 | 選択肢を無効化 |
| 削除済みデータ参照 | 削除済みの顧客・商品等を選択 | 選択肢に「(Deleted)」表示、選択不可 |

## 備考

- 本画面はFilament PHPのCreateRecordページを継承して実装されている
- HasRepeaterColumnManagerトレイトを使用してリピーターのカラム管理を実装
- 商品リピーターはテーブルレイアウトで表示
- 請求サマリーはInvoiceSummary Livewireコンポーネントで動的表示
- 削除済みレコード（withTrashed）も選択肢に表示されるが選択不可
- 同一商品の重複選択を防止する機能あり
- UOM（単位）機能はProductSettings設定で有効/無効を切り替え可能
- afterCreateで仕訳計算（computeAccountMove）が実行される
