# 画面設計書 262-購買契約詳細

## 概要

本ドキュメントは、購買モジュールにおける購買契約詳細画面の設計を記載しています。この画面では、購買契約（ブランケットオーダーまたは購買テンプレート）の詳細情報を閲覧することができます。

### 本画面の処理概要

**業務上の目的・背景**：購買契約は、仕入先との長期的な取引条件を定義するための重要なドキュメントです。この詳細画面により、契約の全体像（仕入先情報、契約条件、商品明細、有効期間など）を一目で把握でき、購買担当者や管理者が契約内容を確認・レビューすることができます。また、契約に基づく発注の意思決定の参考情報として活用されます。

**画面へのアクセス方法**：購買モジュール > 注文 > 購買契約一覧 > 対象レコードの「詳細」アクション、または一覧画面でレコードをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 契約の基本情報（仕入先、購入担当者、契約タイプ、通貨）の閲覧
2. 有効期間（開始日・終了日）の確認（ブランケットオーダーのみ）
3. 参照番号、会社情報の確認
4. 商品明細（商品、数量、単位、単価）の閲覧
5. 契約条件（説明）の閲覧
6. メタデータ（作成日時、作成者、更新日時）の確認
7. Chatter機能によるコミュニケーション・履歴確認
8. 編集画面への遷移
9. 契約の削除（CLOSEDステータス以外）

**画面遷移**：
- 遷移元：購買契約一覧画面
- 遷移先：購買契約編集画面（サブナビゲーションから）

**権限による表示制御**：
- CLOSEDステータスの場合、削除アクションは非表示
- HasRecordNavigationTabsトレイトによるサブナビゲーション制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-022 | 購買契約表示 | 主機能 | 購買契約の詳細情報表示 |
| FN-PURCH-021 | 購買契約編集 | 遷移先機能 | 編集画面への遷移 |
| FN-PURCH-019 | 購買契約一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細

## URL/ルーティング

`/admin/purchases/orders/purchase-agreements/{record}/view`

## 画面構成

- ヘッダーアクションエリア
  - Chatterボタン
  - 削除ボタン（CLOSED以外で表示）
- ステータス表示セクション（バッジ表示）
- 基本情報セクション（アイコン付き2カラムレイアウト）
  - 左カラム：仕入先、購入担当者、契約タイプ、通貨
  - 右カラム：有効期間（開始日・終了日）、参照番号、会社
- タブエリア
  - 商品タブ：商品明細テーブル
  - 追加タブ：カスタムフィールド（設定時のみ表示）
  - 条件タブ：契約条件（Markdown表示）
- メタデータセクション
  - 作成日時、作成者、更新日時
- サブナビゲーション（詳細/編集切り替え）

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| ステータス | state | Badge | - | 契約のステータス表示 |
| 仕入先 | partner.name | Text | building-storefront | 仕入先名 |
| 購入担当者 | user.name | Text | user | 担当ユーザー名 |
| 契約タイプ | type | Badge | document | ブランケットオーダー/購買テンプレート |
| 通貨 | currency.name | Text | currency-dollar | 通貨名 |
| 有効開始日 | starts_at | Date | calendar | 契約の開始日 |
| 有効終了日 | ends_at | Date | calendar | 契約の終了日 |
| 参照番号 | reference | Text | identification | 外部参照番号 |
| 会社 | company.name | Text | building-office | 会社名 |

### 商品明細テーブル

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 商品 | product.name | Text | 商品名 |
| 数量 | qty | Number | 数量 |
| 単位 | uom.name | Text | 単位名（UOM有効時） |
| 単価 | price_unit | Money | 商品の単価（通貨コード付き） |

### 条件タブ

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 契約条件 | description | Markdown/Prose | 契約の詳細条件 |

### メタデータセクション

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| 作成日時 | created_at | DateTime | clock | レコード作成日時 |
| 作成者 | creator.name | Text | user | レコード作成者名 |
| 更新日時 | updated_at | DateTime | arrow-path | レコード更新日時 |

## イベント仕様

### 1-Chatterボタン押下

- 対象：「Chatter」ボタン
- 処理：
  1. Chatterパネルを表示
  2. 契約に関連するコメント・アクティビティ履歴を表示
- 画面遷移：なし（パネル表示）

### 2-削除ボタン押下

- 対象：「削除」ボタン（CLOSEDステータス以外で表示）
- 処理：
  1. 確認ダイアログ表示
  2. 確認後、レコードを論理削除
  3. 成功通知を表示
- 画面遷移：購買契約一覧画面

### 3-編集タブクリック

- 対象：サブナビゲーションの「編集」タブ
- 処理：
  1. 編集画面へ遷移
- 画面遷移：購買契約編集画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | purchases_requisitions | UPDATE | deleted_atを設定（論理削除） |
| 画面表示 | purchases_requisitions | SELECT | 契約情報の取得 |
| 画面表示 | purchases_requisition_lines | SELECT | 商品明細の取得 |

### テーブル別更新項目詳細

#### purchases_requisitions（削除時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 購買契約が削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面を表示 | レコードが見つかりません |
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| 削除済みレコード | 削除済みレコードの表示 | ソフトデリートされたレコードも表示可能 |

## 備考

- ViewRecordを継承した読み取り専用画面
- 購買契約機能は設定（OrderSettings::enable_purchase_agreements）で有効/無効を切り替え可能
- 単位（UOM）フィールドは設定（ProductSettings::enable_uom）で表示/非表示を切り替え可能
- 有効期間セクションはBLANKET_ORDERタイプの場合のみ表示
- HasRecordNavigationTabsトレイトによりView/Edit間のナビゲーションを提供
- Chatter機能により契約に関するコメントや活動履歴を確認可能
- 商品明細の単価はレコードの通貨コードに基づいて表示
- カスタムフィールドタブは設定されている場合のみ表示
