# 画面設計書 263-仕入先一覧

## 概要

本ドキュメントは、購買モジュールにおける仕入先一覧画面の設計を記載しています。この画面では、購買業務で利用する仕入先（サプライヤー）の一覧を表示・検索・管理することができます。

### 本画面の処理概要

**業務上の目的・背景**：仕入先管理は購買業務の基盤となる重要な機能です。この画面により、取引可能な仕入先の全体像を把握し、新規仕入先の登録、既存仕入先情報の確認・編集を効率的に行うことができます。購買担当者が発注先を選定する際の参照画面として、また仕入先マスタデータの管理画面として活用されます。

**画面へのアクセス方法**：購買モジュール > 注文 > 仕入先 をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 仕入先一覧のカード形式表示
2. 仕入先の検索・フィルタリング
3. 新規仕入先の作成画面への遷移
4. 既存仕入先の詳細・編集画面への遷移
5. レスポンシブなグリッドレイアウト表示

**画面遷移**：
- 遷移元：購買モジュールのナビゲーション
- 遷移先：仕入先作成画面、仕入先詳細画面、仕入先編集画面

**権限による表示制御**：
- sub_typeが'supplier'のパートナーのみ表示（仕入先タイプ）
- 新規作成アクションは権限に応じて表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-011 | 仕入先一覧 | 主機能 | 仕入先データの一覧表示と検索 |
| FN-PURCH-012 | 仕入先作成 | 遷移先機能 | 新規仕入先の作成 |
| FN-PURCH-014 | 仕入先表示 | 遷移先機能 | 仕入先詳細の表示 |

## 画面種別

一覧

## URL/ルーティング

`/admin/purchases/orders/vendors`

## 画面構成

- ヘッダーアクションエリア
  - 新規作成ボタン
- コンテンツエリア（カードグリッドレイアウト）
  - 仕入先カード（レスポンシブグリッド）
    - sm: 1列
    - md: 2列
    - xl: 3列
    - 2xl: 3列
- テーブル機能
  - 検索
  - フィルタ
  - 列の切り替え

## 入出力項目

該当なし（一覧表示画面のため入力項目なし）

## 表示項目

仕入先一覧はPartnerResourceを継承しているため、親クラスで定義されたテーブルカラムが表示されます。

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|-------|------|------|
| 名前 | name | Text | ○ | ○ | 仕入先名 |
| メール | email | Text | ○ | ○ | メールアドレス |
| 電話番号 | phone | Text | ○ | ○ | 電話番号 |
| 会社 | company.name | Text | ○ | - | 所属会社名 |
| 作成日 | created_at | DateTime | ○ | - | 作成日時 |

## イベント仕様

### 1-新規作成ボタン押下

- 対象：「新規作成」ボタン
- 処理：
  1. 仕入先作成画面へ遷移
- 画面遷移：仕入先作成画面

### 2-仕入先カードクリック

- 対象：仕入先カード
- 処理：
  1. 選択した仕入先の詳細画面へ遷移
- 画面遷移：仕入先詳細画面

### 3-検索実行

- 対象：検索フィールド
- 処理：
  1. 入力されたキーワードで仕入先を検索
  2. 一覧を更新表示
- 画面遷移：なし（一覧更新）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | partners | SELECT | 仕入先一覧の取得 |

### テーブル別更新項目詳細

#### partners（取得条件）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sub_type | = 'supplier' | 仕入先タイプのみ抽出 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| - | - | - | 一覧表示のため特になし |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| データなし | 空状態表示 | 仕入先がありません |

## 備考

- 購買モジュールのVendorResourceはInvoiceモジュールのVendorResourceを継承
- さらにPartnerResourceを継承した階層構造
- 表示はカード形式（contentGrid）を採用
- sub_type='supplier'のフィルタによりサプライヤーのみを表示
- レスポンシブデザインにより画面幅に応じてカラム数が変化
- 親クラスのListPartnersページを継承し、クエリを仕入先タイプに限定
