# 画面設計書 264-仕入先作成

## 概要

本ドキュメントは、購買モジュールにおける仕入先作成画面の設計を記載しています。この画面では、新規の仕入先（サプライヤー）を登録することができます。

### 本画面の処理概要

**業務上の目的・背景**：購買業務において新規取引先を開拓した際、システムに仕入先情報を登録する必要があります。この画面により、仕入先の基本情報（名前、連絡先、住所など）、売買・購買条件、請求関連設定を一括で登録でき、購買発注や請求書処理の基盤データを整備することができます。

**画面へのアクセス方法**：購買モジュール > 注文 > 仕入先一覧 > 「新規作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 仕入先基本情報（名前、メール、電話番号、ウェブサイト）の入力
2. 会社情報の設定
3. 販売・購買条件（担当者、支払条件、支払方法、財務ポジション）の設定
4. 請求関連設定（請求送付方法、EDI形式、自動転記設定）の入力
5. 内部メモの入力

**画面遷移**：
- 遷移元：仕入先一覧画面
- 遷移先：仕入先詳細画面（作成後）

**権限による表示制御**：
- 作成権限を持つユーザーのみアクセス可能
- sub_type='supplier'が自動的に設定される

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-012 | 仕入先作成 | 主機能 | 新規仕入先の登録 |
| FN-PURCH-011 | 仕入先一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PURCH-014 | 仕入先表示 | 遷移先機能 | 作成後の詳細表示 |

## 画面種別

作成

## URL/ルーティング

`/admin/purchases/orders/vendors/create`

## 画面構成

- 基本情報セクション
  - 画像アップロードエリア
  - 基本項目（名前、メール、電話番号など）
- タブエリア
  - 販売・購買タブ
    - 販売フィールドセット（担当者、支払条件、支払方法）
    - 購買フィールドセット（支払条件、支払方法）
    - 財務情報フィールドセット（財務ポジション）
    - その他設定フィールドセット
  - 請求タブ
    - 顧客請求書フィールドセット（送付方法、EDI形式、エンドポイント）
    - 自動化フィールドセット（自動転記、異常チェック設定）
  - 内部メモタブ
    - リッチテキストエディタ

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| サブタイプ | sub_type | 入力（非表示） | Hidden | - | - | supplier | 仕入先タイプ固定 |
| 名前 | name | 入力 | Text | ○ | 255 | - | 仕入先名 |
| メール | email | 入力 | Email | - | 255 | - | メールアドレス |
| 電話番号 | phone | 入力 | Text | - | 50 | - | 電話番号 |
| 携帯電話 | mobile | 入力 | Text | - | 50 | - | 携帯電話番号 |
| ウェブサイト | website | 入力 | URL | - | 255 | - | ウェブサイトURL |
| 会社 | company_id | 入力 | Select | - | - | - | 所属会社 |

### 販売・購買タブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 担当者 | user_id | 入力 | Select | - | - | - | 営業担当者 |
| 支払条件（販売） | property_payment_term_id | 入力 | Select | - | - | - | 販売時の支払条件 |
| 支払方法（販売） | property_inbound_payment_method_line_id | 入力 | Select | - | - | - | 入金支払方法 |
| 支払条件（購買） | property_supplier_payment_term_id | 入力 | Select | - | - | - | 購買時の支払条件 |
| 支払方法（購買） | property_outbound_payment_method_line_id | 入力 | Select | - | - | - | 出金支払方法 |
| 財務ポジション | property_account_position_id | 入力 | Select | - | - | - | 税務・会計ポジション |

### 請求タブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 請求送付方法 | invoice_sending_method | 入力 | Select | - | - | - | 請求書の送付方法 |
| EDI形式 | invoice_edi_format_store | 入力 | Select | - | - | - | 電子請求書の形式 |
| PEPPOL EAS | peppol_eas | 入力 | Select | - | - | - | PEPPOL識別スキーム |
| エンドポイント | peppol_endpoint | 入力 | Text | - | 255 | - | PEPPOLエンドポイント |
| 自動転記請求書 | autopost_bills | 入力 | Select | - | - | - | 自動転記設定 |
| 異常金額無視 | ignore_abnormal_invoice_amount | 入力 | Toggle | - | - | false | 異常な請求金額を無視 |
| 異常日付無視 | ignore_abnormal_invoice_date | 入力 | Toggle | - | - | false | 異常な請求日付を無視 |

### 内部メモタブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| コメント | comment | 入力 | RichText | - | - | - | 内部向けメモ |

## 表示項目

該当なし（作成画面のため入出力項目を参照）

## イベント仕様

### 1-保存ボタン押下

- 対象：フォーム保存
- 処理：
  1. 入力バリデーション実行
  2. sub_type='supplier'を自動設定
  3. パートナーレコードを作成
  4. 成功通知を表示
- 画面遷移：仕入先詳細画面

### 2-EDI形式変更

- 対象：EDI形式選択フィールド
- 処理：
  1. FACTURX_X_CII以外を選択時：PEPPOL EAS、エンドポイントフィールドを表示
  2. FACTURX_X_CII選択時：PEPPOL関連フィールドを非表示
- 画面遷移：なし（ライブ更新）

### 3-キャンセルボタン押下

- 対象：キャンセルボタン
- 処理：
  1. 入力内容を破棄
- 画面遷移：仕入先一覧画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | partners | INSERT | 新規仕入先レコードを作成 |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | sub_type | 'supplier' | 固定値（自動設定） |
| INSERT | name | フォーム入力値 | 仕入先名 |
| INSERT | email | フォーム入力値 | メールアドレス |
| INSERT | phone | フォーム入力値 | 電話番号 |
| INSERT | mobile | フォーム入力値 | 携帯電話 |
| INSERT | website | フォーム入力値 | ウェブサイト |
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | user_id | フォーム入力値 | 担当者ID |
| INSERT | property_payment_term_id | フォーム入力値 | 販売支払条件ID |
| INSERT | property_inbound_payment_method_line_id | フォーム入力値 | 入金支払方法ID |
| INSERT | property_supplier_payment_term_id | フォーム入力値 | 購買支払条件ID |
| INSERT | property_outbound_payment_method_line_id | フォーム入力値 | 出金支払方法ID |
| INSERT | property_account_position_id | フォーム入力値 | 財務ポジションID |
| INSERT | invoice_sending_method | フォーム入力値 | 請求送付方法 |
| INSERT | invoice_edi_format_store | フォーム入力値 | EDI形式 |
| INSERT | peppol_eas | フォーム入力値 | PEPPOL EAS |
| INSERT | peppol_endpoint | フォーム入力値 | エンドポイント |
| INSERT | autopost_bills | フォーム入力値 | 自動転記設定 |
| INSERT | ignore_abnormal_invoice_amount | フォーム入力値 | 異常金額無視フラグ |
| INSERT | ignore_abnormal_invoice_date | フォーム入力値 | 異常日付無視フラグ |
| INSERT | comment | フォーム入力値 | コメント |
| INSERT | created_at | 現在日時 | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 仕入先が作成されました | 作成成功時 |
| MSG-002 | エラー | 必須項目が入力されていません | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| バリデーションエラー | エラーメッセージを表示 | 各フィールドにエラー表示 |
| 重複データ | エラー通知を表示 | 既に登録されています |

## 備考

- 購買モジュールのCreateVendorはInvoiceモジュールのCreateVendorを継承
- さらにPartnerResourceのCreatePartnerを継承した階層構造
- mutateFormDataBeforeCreateでsub_type='supplier'を自動設定
- 作成後は詳細画面（view）へリダイレクト
- PEPPOLフィールドはEDI形式の選択に応じて動的に表示/非表示
- フォームは親クラス（VendorResource）で定義されたスキーマを使用
- リレーションシップフィールド（支払条件、支払方法など）はプリロード＆検索可能
