# 画面設計書 265-仕入先編集

## 概要

本ドキュメントは、購買モジュールにおける仕入先編集画面の設計を記載しています。この画面では、既存の仕入先（サプライヤー）情報を編集・更新することができます。

### 本画面の処理概要

**業務上の目的・背景**：取引先情報は事業活動の中で変更が発生することがあります。連絡先の変更、支払条件の見直し、請求方法の変更などに対応するため、仕入先情報を更新する必要があります。この画面により、仕入先の各種情報を修正し、最新の状態を維持することができます。

**画面へのアクセス方法**：購買モジュール > 注文 > 仕入先一覧 > 対象レコードの「編集」アクション、または仕入先詳細画面のサブナビゲーションから「編集」を選択してアクセスします。

**主要な操作・処理内容**：
1. 仕入先基本情報（名前、メール、電話番号、ウェブサイト）の編集
2. 会社情報の変更
3. 販売・購買条件（担当者、支払条件、支払方法、財務ポジション）の変更
4. 請求関連設定（請求送付方法、EDI形式、自動転記設定）の変更
5. 内部メモの編集

**画面遷移**：
- 遷移元：仕入先一覧画面、仕入先詳細画面
- 遷移先：仕入先詳細画面（保存後）

**権限による表示制御**：
- 編集権限を持つユーザーのみアクセス可能
- サブナビゲーションにより連絡先、住所、請求書、購買注文の管理画面へ遷移可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-013 | 仕入先編集 | 主機能 | 既存仕入先の編集・更新 |
| FN-PURCH-014 | 仕入先表示 | 遷移先機能 | 編集完了後の詳細表示 |
| FN-PURCH-011 | 仕入先一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

編集

## URL/ルーティング

`/admin/purchases/orders/vendors/{record}/edit`

## 画面構成

- 基本情報セクション
  - 画像アップロードエリア
  - 基本項目（名前、メール、電話番号など）
- タブエリア
  - 販売・購買タブ
    - 販売フィールドセット（担当者、支払条件、支払方法）
    - 購買フィールドセット（支払条件、支払方法）
    - 財務情報フィールドセット（財務ポジション）
    - その他設定フィールドセット
  - 請求タブ
    - 顧客請求書フィールドセット（送付方法、EDI形式、エンドポイント）
    - 自動化フィールドセット（自動転記、異常チェック設定）
  - 内部メモタブ
    - リッチテキストエディタ
- サブナビゲーション
  - 詳細、編集、連絡先、住所、請求書、購買注文

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 名前 | name | 入力 | Text | ○ | 255 | 既存値 | 仕入先名 |
| メール | email | 入力 | Email | - | 255 | 既存値 | メールアドレス |
| 電話番号 | phone | 入力 | Text | - | 50 | 既存値 | 電話番号 |
| 携帯電話 | mobile | 入力 | Text | - | 50 | 既存値 | 携帯電話番号 |
| ウェブサイト | website | 入力 | URL | - | 255 | 既存値 | ウェブサイトURL |
| 会社 | company_id | 入力 | Select | - | - | 既存値 | 所属会社 |

### 販売・購買タブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 担当者 | user_id | 入力 | Select | - | - | 既存値 | 営業担当者 |
| 支払条件（販売） | property_payment_term_id | 入力 | Select | - | - | 既存値 | 販売時の支払条件 |
| 支払方法（販売） | property_inbound_payment_method_line_id | 入力 | Select | - | - | 既存値 | 入金支払方法 |
| 支払条件（購買） | property_supplier_payment_term_id | 入力 | Select | - | - | 既存値 | 購買時の支払条件 |
| 支払方法（購買） | property_outbound_payment_method_line_id | 入力 | Select | - | - | 既存値 | 出金支払方法 |
| 財務ポジション | property_account_position_id | 入力 | Select | - | - | 既存値 | 税務・会計ポジション |

### 請求タブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 請求送付方法 | invoice_sending_method | 入力 | Select | - | - | 既存値 | 請求書の送付方法 |
| EDI形式 | invoice_edi_format_store | 入力 | Select | - | - | 既存値 | 電子請求書の形式 |
| PEPPOL EAS | peppol_eas | 入力 | Select | - | - | 既存値 | PEPPOL識別スキーム |
| エンドポイント | peppol_endpoint | 入力 | Text | - | 255 | 既存値 | PEPPOLエンドポイント |
| 自動転記請求書 | autopost_bills | 入力 | Select | - | - | 既存値 | 自動転記設定 |
| 異常金額無視 | ignore_abnormal_invoice_amount | 入力 | Toggle | - | - | 既存値 | 異常な請求金額を無視 |
| 異常日付無視 | ignore_abnormal_invoice_date | 入力 | Toggle | - | - | 既存値 | 異常な請求日付を無視 |

### 内部メモタブ

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| コメント | comment | 入力 | RichText | - | - | 既存値 | 内部向けメモ |

## 表示項目

該当なし（編集画面のため入出力項目を参照）

## イベント仕様

### 1-保存ボタン押下

- 対象：フォーム保存
- 処理：
  1. 入力バリデーション実行
  2. パートナーレコードを更新
  3. 成功通知を表示
- 画面遷移：同画面（リロード）または詳細画面

### 2-EDI形式変更

- 対象：EDI形式選択フィールド
- 処理：
  1. FACTURX_X_CII以外を選択時：PEPPOL EAS、エンドポイントフィールドを表示
  2. FACTURX_X_CII選択時：PEPPOL関連フィールドを非表示
- 画面遷移：なし（ライブ更新）

### 3-サブナビゲーション選択

- 対象：サブナビゲーションタブ
- 処理：
  1. 選択したタブに対応する管理画面へ遷移
- 画面遷移：
  - 詳細 → 仕入先詳細画面
  - 連絡先 → 連絡先管理画面
  - 住所 → 住所管理画面
  - 請求書 → 請求書管理画面
  - 購買注文 → 購買注文管理画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | partners | UPDATE | 仕入先レコードを更新 |

### テーブル別更新項目詳細

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 仕入先名 |
| UPDATE | email | フォーム入力値 | メールアドレス |
| UPDATE | phone | フォーム入力値 | 電話番号 |
| UPDATE | mobile | フォーム入力値 | 携帯電話 |
| UPDATE | website | フォーム入力値 | ウェブサイト |
| UPDATE | company_id | フォーム入力値 | 会社ID |
| UPDATE | user_id | フォーム入力値 | 担当者ID |
| UPDATE | property_payment_term_id | フォーム入力値 | 販売支払条件ID |
| UPDATE | property_inbound_payment_method_line_id | フォーム入力値 | 入金支払方法ID |
| UPDATE | property_supplier_payment_term_id | フォーム入力値 | 購買支払条件ID |
| UPDATE | property_outbound_payment_method_line_id | フォーム入力値 | 出金支払方法ID |
| UPDATE | property_account_position_id | フォーム入力値 | 財務ポジションID |
| UPDATE | invoice_sending_method | フォーム入力値 | 請求送付方法 |
| UPDATE | invoice_edi_format_store | フォーム入力値 | EDI形式 |
| UPDATE | peppol_eas | フォーム入力値 | PEPPOL EAS |
| UPDATE | peppol_endpoint | フォーム入力値 | エンドポイント |
| UPDATE | autopost_bills | フォーム入力値 | 自動転記設定 |
| UPDATE | ignore_abnormal_invoice_amount | フォーム入力値 | 異常金額無視フラグ |
| UPDATE | ignore_abnormal_invoice_date | フォーム入力値 | 異常日付無視フラグ |
| UPDATE | comment | フォーム入力値 | コメント |
| UPDATE | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 仕入先が更新されました | 更新成功時 |
| MSG-002 | エラー | 必須項目が入力されていません | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面を表示 | レコードが見つかりません |
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| バリデーションエラー | エラーメッセージを表示 | 各フィールドにエラー表示 |

## 備考

- 購買モジュールのEditVendorはInvoiceモジュールのEditVendorを継承
- さらにPartnerResourceのEditPartnerを継承した階層構造
- サブナビゲーションにより関連データ（連絡先、住所、請求書、購買注文）の管理画面へ遷移可能
- フォームは親クラス（VendorResource）で定義されたスキーマを使用
- リレーションシップフィールド（支払条件、支払方法など）はプリロード＆検索可能
- PEPPOLフィールドはEDI形式の選択に応じて動的に表示/非表示
