# 画面設計書 266-仕入先詳細

## 概要

本ドキュメントは、購買モジュールにおける仕入先詳細画面の設計を記載しています。この画面では、仕入先（サプライヤー）の詳細情報を閲覧することができます。

### 本画面の処理概要

**業務上の目的・背景**：仕入先との取引を行う際に、仕入先の詳細情報（連絡先、支払条件、請求設定など）を確認する必要があります。この画面により、仕入先に関するすべての情報を一目で把握でき、発注時の参考情報や与信管理の基礎データとして活用できます。

**画面へのアクセス方法**：購買モジュール > 注文 > 仕入先一覧 > 対象レコードをクリック、または一覧画面の「詳細」アクションを選択してアクセスします。

**主要な操作・処理内容**：
1. 仕入先基本情報（名前、メール、電話番号、ウェブサイト）の閲覧
2. 会社情報の確認
3. 販売・購買条件（担当者、支払条件、支払方法、財務ポジション）の閲覧
4. 請求関連設定（請求送付方法、EDI形式、自動転記設定）の確認
5. 内部メモの閲覧
6. 編集画面への遷移
7. 関連データ（連絡先、住所、請求書、購買注文）の管理画面への遷移

**画面遷移**：
- 遷移元：仕入先一覧画面
- 遷移先：仕入先編集画面、連絡先管理画面、住所管理画面、請求書管理画面、購買注文管理画面

**権限による表示制御**：
- 閲覧権限を持つユーザーがアクセス可能
- サブナビゲーションにより関連画面への遷移を制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-014 | 仕入先表示 | 主機能 | 仕入先詳細情報の表示 |
| FN-PURCH-013 | 仕入先編集 | 遷移先機能 | 編集画面への遷移 |
| FN-PURCH-011 | 仕入先一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細

## URL/ルーティング

`/admin/purchases/orders/vendors/{record}`

## 画面構成

- 基本情報セクション
  - 画像表示エリア
  - 基本項目（名前、メール、電話番号など）
- タブエリア
  - 販売・購買タブ
    - 販売フィールドセット（担当者、支払条件、支払方法）
    - 購買フィールドセット（支払条件、支払方法）
    - 財務情報フィールドセット（財務ポジション）
    - その他設定フィールドセット
  - 請求タブ
    - 顧客請求書フィールドセット（送付方法、EDI形式、エンドポイント）
    - 自動化フィールドセット（自動転記、異常チェック設定）
  - 内部メモタブ
    - コメント表示
- サブナビゲーション
  - 詳細、編集、連絡先、住所、請求書、購買注文

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| 名前 | name | Text | - | 仕入先名 |
| メール | email | Text | - | メールアドレス |
| 電話番号 | phone | Text | - | 電話番号 |
| 携帯電話 | mobile | Text | - | 携帯電話番号 |
| ウェブサイト | website | URL | - | ウェブサイトURL |
| 会社 | company.name | Text | - | 所属会社名 |

### 販売・購買タブ

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| 担当者 | user.name | Text | user | 営業担当者名 |
| 支払条件（販売） | propertyPaymentTerm.name | Text | calendar | 販売時の支払条件 |
| 支払方法（販売） | propertyInboundPaymentMethodLine.name | Text | credit-card | 入金支払方法 |
| 支払条件（購買） | propertySupplierPaymentTerm.name | Text | calendar | 購買時の支払条件 |
| 支払方法（購買） | propertyOutboundPaymentMethodLine.name | Text | banknotes | 出金支払方法 |
| 財務ポジション | propertyAccountPosition.name | Text | document-text | 税務・会計ポジション |

### 請求タブ

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| 請求送付方法 | invoice_sending_method | Text | paper-airplane | 請求書の送付方法 |
| EDI形式 | invoice_edi_format_store | Text | document | 電子請求書の形式 |
| PEPPOL EAS | peppol_eas | Text | identification | PEPPOL識別スキーム |
| エンドポイント | peppol_endpoint | Text | globe-alt | PEPPOLエンドポイント |
| 自動転記請求書 | autopost_bills | Text | bolt | 自動転記設定 |
| 異常金額無視 | ignore_abnormal_invoice_amount | Boolean | - | 異常な請求金額を無視 |
| 異常日付無視 | ignore_abnormal_invoice_date | Boolean | - | 異常な請求日付を無視 |

### 内部メモタブ

| 項目名 | 項目ID | 型 | アイコン | 説明 |
|--------|--------|-----|---------|------|
| コメント | comment | HTML | chat-bubble-left-right | 内部向けメモ |

## イベント仕様

### 1-編集タブクリック

- 対象：サブナビゲーションの「編集」タブ
- 処理：
  1. 編集画面へ遷移
- 画面遷移：仕入先編集画面

### 2-連絡先タブクリック

- 対象：サブナビゲーションの「連絡先」タブ
- 処理：
  1. 連絡先管理画面へ遷移
- 画面遷移：連絡先管理画面

### 3-住所タブクリック

- 対象：サブナビゲーションの「住所」タブ
- 処理：
  1. 住所管理画面へ遷移
- 画面遷移：住所管理画面

### 4-請求書タブクリック

- 対象：サブナビゲーションの「請求書」タブ
- 処理：
  1. 請求書管理画面へ遷移
- 画面遷移：請求書管理画面

### 5-購買注文タブクリック

- 対象：サブナビゲーションの「購買注文」タブ
- 処理：
  1. 購買注文管理画面へ遷移
- 画面遷移：購買注文管理画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | partners | SELECT | 仕入先情報の取得 |

### テーブル別更新項目詳細

該当なし（詳細表示のため更新なし）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| - | - | - | 詳細表示のため特になし |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコードが存在しない | 404エラー画面を表示 | レコードが見つかりません |
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |

## 備考

- 購買モジュールのViewVendorはInvoiceモジュールのViewVendorを継承
- さらにPartnerResourceのViewPartnerを継承した階層構造
- ViewRecordを継承した読み取り専用画面
- サブナビゲーションにより関連データの管理画面へ遷移可能
- infolistは親クラス（VendorResource）で定義されたスキーマを使用
- アイコン付きのTextEntryで視認性を向上
- プレースホルダー「-」で値がない場合も適切に表示
- 異常金額/日付無視フィールドはIconEntryでBoolean表示
