# 画面設計書 267-仕入先価格一覧

## 概要

本ドキュメントは、購買モジュールにおける仕入先価格一覧画面の設計を記載しています。この画面では、仕入先ごとの商品価格設定を一覧表示・管理することができます。

### 本画面の処理概要

**業務上の目的・背景**：仕入先価格（ベンダー価格リスト）は、各仕入先から商品を購入する際の単価、最小発注数量、有効期間などを管理するための重要なマスタデータです。この画面により、仕入先別の価格情報を一元管理し、購買発注時の自動価格適用や価格比較・交渉の基礎データとして活用できます。

**画面へのアクセス方法**：購買モジュール > 設定 > 仕入先価格 をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 仕入先価格一覧のテーブル表示
2. 仕入先、商品、通貨、会社などによるフィルタリング
3. 価格範囲、数量範囲、有効期間によるフィルタリング
4. グループ化（仕入先別、商品別、作成日別、更新日別）
5. 新規仕入先価格の作成（モーダル）
6. 既存仕入先価格の詳細表示・編集・削除
7. 一括削除操作

**画面遷移**：
- 遷移元：購買モジュールの設定ナビゲーション
- 遷移先：仕入先価格詳細画面、仕入先価格編集画面

**権限による表示制御**：
- アクセス権限を持つユーザーのみ表示
- 作成アクションで creator_id、company_id が自動設定

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-031 | 仕入先価格一覧 | 主機能 | 仕入先価格データの一覧表示と検索 |
| FN-PURCH-032 | 仕入先価格作成 | 関連機能 | 新規仕入先価格の作成 |
| FN-PURCH-033 | 仕入先価格詳細 | 遷移先機能 | 仕入先価格詳細の表示 |

## 画面種別

一覧

## URL/ルーティング

`/admin/purchases/configurations/vendor-prices`

## 画面構成

- ヘッダーアクションエリア
  - 新規作成ボタン（モーダル表示）
- テーブルエリア
  - 列の並べ替え対応
  - 列マネージャー（2列表示）
  - グループ化オプション
  - フィルターパネル
- 空状態エリア
  - 新規作成アクション

## 入出力項目

### 新規作成モーダル

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 仕入先 | partner_id | 入力 | Select | ○ | - | - | 仕入先選択 |
| 仕入先商品名 | product_name | 入力 | Text | - | 255 | - | 仕入先側の商品名 |
| 仕入先商品コード | product_code | 入力 | Text | - | 255 | - | 仕入先側の商品コード |
| リードタイム | delay | 入力 | Number | - | 8 | 1 | 納期日数 |
| 商品 | product_id | 入力 | Select | - | - | - | 商品選択 |
| 最小数量 | min_qty | 入力 | Number | - | 11 | 0 | 最小発注数量 |
| 単価 | price | 入力 | Number | - | 11 | 0 | 商品の単価 |
| 通貨 | currency_id | 入力 | Select | ○ | - | ユーザーのデフォルト会社通貨 | 通貨選択 |
| 有効開始日 | starts_at | 入力 | Date | - | - | - | 価格の有効開始日 |
| 有効終了日 | ends_at | 入力 | Date | - | - | - | 価格の有効終了日 |
| 割引 | discount | 入力 | Number | - | 11 | 0 | 割引率 |
| 会社 | company_id | 入力 | Select | - | - | ユーザーのデフォルト会社 | 会社選択 |

## 表示項目

### テーブルカラム

| 項目名 | 項目ID | 型 | ソート | 検索 | デフォルト表示 | 説明 |
|--------|--------|-----|-------|------|--------------|------|
| 仕入先 | partner.name | Text | - | ○ | ○ | 仕入先名 |
| 商品 | product.name | Text | - | ○ | ○ | 商品名 |
| 仕入先商品名 | product_name | Text | ○ | - | - | 仕入先側の商品名 |
| 仕入先商品コード | product_code | Text | ○ | - | - | 仕入先側の商品コード |
| 有効開始日 | starts_at | Date | ○ | - | - | 有効開始日 |
| 有効終了日 | ends_at | Date | ○ | - | - | 有効終了日 |
| 会社 | company.name | Text | ○ | - | ○ | 会社名 |
| 最小数量 | min_qty | Number | ○ | - | - | 最小発注数量 |
| 単価 | price | Number | ○ | - | ○ | 商品の単価 |
| 割引 | discount | Number | ○ | - | - | 割引率 |
| 通貨 | currency.name | Text | ○ | - | ○ | 通貨名 |
| 作成日時 | created_at | DateTime | ○ | - | - | 作成日時 |
| 更新日時 | updated_at | DateTime | ○ | - | - | 更新日時 |

### フィルター

| フィルター名 | 項目ID | 型 | 説明 |
|-------------|--------|-----|------|
| 仕入先 | partner_id | Select（複数） | 仕入先でフィルタ |
| 商品 | product_id | Select（複数） | 商品でフィルタ |
| 通貨 | currency_id | Select（複数） | 通貨でフィルタ |
| 会社 | company_id | Select（複数） | 会社でフィルタ |
| 価格範囲（From） | price_from | Number | 最低価格 |
| 価格範囲（To） | price_to | Number | 最高価格 |
| 最小数量範囲（From） | min_qty_from | Number | 最小数量下限 |
| 最小数量範囲（To） | min_qty_to | Number | 最小数量上限 |
| 有効期間開始（From） | starts_from | Date | 有効開始日下限 |
| 有効期間終了（Before） | ends_before | Date | 有効終了日上限 |
| 作成日（From） | created_from | Date | 作成日下限 |
| 作成日（Until） | created_until | Date | 作成日上限 |

### グループ化オプション

| グループ名 | 項目ID | 説明 |
|-----------|--------|------|
| 仕入先 | partner.name | 仕入先別にグループ化 |
| 商品 | product.name | 商品別にグループ化 |
| 作成日 | created_at | 作成日別にグループ化（折りたたみ可） |
| 更新日 | updated_at | 更新日別にグループ化（折りたたみ可） |

## イベント仕様

### 1-新規作成ボタン押下

- 対象：「新規作成」ボタン
- 処理：
  1. 新規作成モーダルを表示
  2. creator_id にログインユーザーIDを設定
  3. company_id にログインユーザーのデフォルト会社IDを設定
  4. フォーム入力後、保存処理
  5. 成功通知を表示
- 画面遷移：なし（モーダル閉じてリスト更新）

### 2-詳細アクション

- 対象：行アクションの「詳細」
- 処理：
  1. 仕入先価格詳細画面へ遷移
- 画面遷移：仕入先価格詳細画面

### 3-編集アクション

- 対象：行アクションの「編集」
- 処理：
  1. 仕入先価格編集画面へ遷移
- 画面遷移：仕入先価格編集画面

### 4-削除アクション

- 対象：行アクションの「削除」
- 処理：
  1. 確認ダイアログ表示
  2. 確認後、レコードを削除
  3. 成功/エラー通知を表示
- 画面遷移：なし（リスト更新）

### 5-一括削除アクション

- 対象：ツールバーの「一括削除」
- 処理：
  1. 選択されたレコードを一括削除
  2. 成功/エラー通知を表示
- 画面遷移：なし（リスト更新）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成ボタン押下 | products_suppliers | INSERT | 新規仕入先価格レコードを作成 |
| 削除アクション | products_suppliers | DELETE | 仕入先価格レコードを削除 |
| 一括削除アクション | products_suppliers | DELETE | 複数仕入先価格レコードを削除 |
| 画面表示 | products_suppliers | SELECT | 仕入先価格一覧の取得 |

### テーブル別更新項目詳細

#### products_suppliers

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | partner_id | フォーム入力値 | 仕入先ID |
| INSERT | product_name | フォーム入力値 | 仕入先商品名 |
| INSERT | product_code | フォーム入力値 | 仕入先商品コード |
| INSERT | delay | フォーム入力値 | リードタイム |
| INSERT | product_id | フォーム入力値 | 商品ID |
| INSERT | min_qty | フォーム入力値 | 最小数量 |
| INSERT | price | フォーム入力値 | 単価 |
| INSERT | currency_id | フォーム入力値 | 通貨ID |
| INSERT | starts_at | フォーム入力値 | 有効開始日 |
| INSERT | ends_at | フォーム入力値 | 有効終了日 |
| INSERT | discount | フォーム入力値 | 割引率 |
| INSERT | company_id | フォーム入力値またはデフォルト | 会社ID |
| INSERT | creator_id | ログインユーザーID | 作成者ID |
| INSERT | created_at | 現在日時 | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 仕入先価格が作成されました | 作成成功時 |
| MSG-002 | 成功 | 仕入先価格が削除されました | 削除成功時 |
| MSG-003 | エラー | 仕入先価格の削除に失敗しました | 削除エラー時 |
| MSG-004 | 成功 | 選択した仕入先価格が削除されました | 一括削除成功時 |
| MSG-005 | エラー | 仕入先価格の一括削除に失敗しました | 一括削除エラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| データなし | 空状態表示 | 仕入先価格がありません |
| 削除時の外部キー制約 | エラー通知を表示 | 関連データが存在するため削除できません |
| QueryException | エラー通知を表示 | 削除処理でエラーが発生しました |

## 備考

- クラスターはConfigurations（設定）に属する
- ナビゲーションソート順は10
- モデルはProductSupplier（products_suppliersテーブル）を使用
- ナビゲーションアイコンはheroicon-o-archive-box
- 列の並べ替え対応（reorderableColumns）
- 列マネージャーで2列表示設定
- 商品選択はis_configurable=nullの商品のみ（バリアント商品を除外）
- 仕入先商品名/コードにはツールチップでヘルプを表示
- 価格フィールドにはツールチップで計算方法のヒントを表示
- 空状態では新規作成アクションを表示
