# 画面設計書 268-商品一覧

## 概要

本ドキュメントは、購買モジュールにおける商品一覧画面の設計を記載しています。この画面では、購買業務で取り扱う商品の一覧を表示・検索・管理することができます。

### 本画面の処理概要

**業務上の目的・背景**：購買モジュールにおける商品管理は、発注対象となる商品のマスタデータを管理するための重要な機能です。この画面により、購買担当者が発注可能な商品を検索・確認し、新規商品の登録や既存商品情報の編集を効率的に行うことができます。

**画面へのアクセス方法**：購買モジュール > 商品 > 商品一覧 をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 商品一覧のテーブル表示
2. 商品の検索・フィルタリング
3. 新規商品の作成画面への遷移
4. 既存商品の詳細・編集画面への遷移
5. 商品の削除・復元操作

**画面遷移**：
- 遷移元：購買モジュールのナビゲーション
- 遷移先：商品作成画面、商品詳細画面、商品編集画面

**権限による表示制御**：
- アクセス権限を持つユーザーのみ表示
- 購買モジュール用にカスタマイズされたProductResource

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-041 | 商品一覧 | 主機能 | 商品データの一覧表示と検索 |
| FN-PURCH-042 | 商品作成 | 遷移先機能 | 新規商品の作成 |
| FN-PURCH-044 | 商品表示 | 遷移先機能 | 商品詳細の表示 |

## 画面種別

一覧

## URL/ルーティング

`/admin/purchases/products/products`

## 画面構成

- ヘッダーアクションエリア
  - 新規作成ボタン
- テーブルエリア
  - 商品一覧テーブル
  - 検索機能
  - フィルターパネル
  - グループ化オプション
  - 列の切り替え
- 行アクション
  - 詳細、編集、削除、復元

## 入出力項目

該当なし（一覧表示画面のため入力項目なし）

## 表示項目

### テーブルカラム

商品一覧はProductResourceを継承しているため、親クラスで定義されたテーブルカラムが表示されます。ただし、「responsible」フィルタは購買モジュールでは除外されています。

| 項目名 | 項目ID | 型 | ソート | 検索 | 説明 |
|--------|--------|-----|-------|------|------|
| 商品名 | name | Text | ○ | ○ | 商品名 |
| 内部参照 | default_code | Text | ○ | ○ | 内部参照コード |
| タイプ | type | Badge | ○ | - | 商品タイプ |
| カテゴリ | category.name | Text | ○ | - | 商品カテゴリ |
| 価格 | price | Money | ○ | - | 販売価格 |
| 原価 | standard_price | Money | ○ | - | 標準原価 |
| 作成日 | created_at | DateTime | ○ | - | 作成日時 |
| 更新日 | updated_at | DateTime | ○ | - | 更新日時 |

### フィルター

購買モジュールでは、親クラスのフィルターから「responsible」（担当者）フィルターを除外しています。

| フィルター名 | 項目ID | 型 | 説明 |
|-------------|--------|-----|------|
| 商品名 | name | Text | 商品名で検索 |
| タイプ | type | Select | 商品タイプでフィルタ |
| カテゴリ | category | Relationship | カテゴリでフィルタ |
| 作成日 | created_at | Date | 作成日でフィルタ |
| 更新日 | updated_at | Date | 更新日でフィルタ |

## イベント仕様

### 1-新規作成ボタン押下

- 対象：「新規作成」ボタン
- 処理：
  1. 商品作成画面へ遷移
- 画面遷移：商品作成画面

### 2-商品行クリック

- 対象：テーブル行
- 処理：
  1. 選択した商品の詳細画面へ遷移
- 画面遷移：商品詳細画面

### 3-詳細アクション

- 対象：行アクションの「詳細」
- 処理：
  1. 商品詳細画面へ遷移
- 画面遷移：商品詳細画面

### 4-編集アクション

- 対象：行アクションの「編集」
- 処理：
  1. 商品編集画面へ遷移
- 画面遷移：商品編集画面

### 5-削除アクション

- 対象：行アクションの「削除」
- 処理：
  1. 確認ダイアログ表示
  2. 確認後、レコードを論理削除
  3. 成功通知を表示
- 画面遷移：なし（リスト更新）

### 6-復元アクション

- 対象：行アクションの「復元」（削除済みレコード）
- 処理：
  1. レコードを復元
  2. 成功通知を表示
- 画面遷移：なし（リスト更新）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | products | UPDATE | deleted_atを設定（論理削除） |
| 復元アクション | products | UPDATE | deleted_atをNULLに設定 |
| 画面表示 | products | SELECT | 商品一覧の取得 |

### テーブル別更新項目詳細

#### products

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除 |
| UPDATE（復元） | deleted_at | NULL | 復元 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 商品が削除されました | 削除成功時 |
| MSG-002 | 成功 | 商品が復元されました | 復元成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| データなし | 空状態表示 | 商品がありません |

## 備考

- 購買モジュールのProductResourceは基盤ProductResourceを継承
- さらにListProductsはBaseListProductsを継承した階層構造
- クラスターはProducts（商品）に属する
- ナビゲーションソート順は1
- モデルはPurchaseモジュール用のProduct（extendsベースProduct）
- ナビゲーションアイコンはheroicon-o-shopping-bag
- recordTitleAttributeはname
- HasCustomFieldsトレイトによりカスタムフィールドに対応
- 「responsible」フィルターは購買モジュールでは除外（QueryBuilderから削除）
- サブナビゲーションでView, Edit, Attributes, Variants, Vendorsに遷移可能
