# 画面設計書 269-注文設定

## 概要

本ドキュメントは、購買モジュールにおける注文設定画面の設計を記載しています。この画面では、購買注文に関するシステム設定を管理することができます。

### 本画面の処理概要

**業務上の目的・背景**：購買業務において、注文承認フロー、確定済み注文のロック、購買契約機能の有効化など、業務プロセスに関わる重要な設定を管理する必要があります。この画面により、システム管理者が購買注文に関する動作設定を一元的に管理でき、組織のポリシーに合わせた購買ワークフローを構築できます。

**画面へのアクセス方法**：設定モジュール > Purchase > 注文 をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 注文承認の有効化/無効化
2. 承認が必要な最小金額の設定
3. 確定済み注文のロック機能の有効化/無効化
4. 購買契約機能の有効化/無効化
5. 設定の保存

**画面遷移**：
- 遷移元：設定モジュールのナビゲーション
- 遷移先：なし（設定保存後も同画面に留まる）

**権限による表示制御**：
- HasPageShieldトレイトによる権限制御
- 設定モジュールへのアクセス権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-091 | 注文設定 | 主機能 | 購買注文の設定管理 |

## 画面種別

設定

## URL/ルーティング

`/admin/settings/purchase/manage-orders`

## 画面構成

- パンくずリスト
  - 注文設定
- 設定フォームエリア
  - 注文承認設定グループ
    - 注文承認有効化トグル
    - 承認最小金額入力（条件付き表示）
  - 確定済み注文ロック設定
  - 購買契約設定

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| 注文承認有効化 | enable_order_approval | 入力 | Toggle | - | - | false | 注文承認ワークフローの有効化 |
| 承認最小金額 | order_validation_amount | 入力 | Number | - | - | 0 | 承認が必要な最小注文金額 |
| 確定済み注文ロック | enable_lock_confirmed_orders | 入力 | Toggle | - | - | false | 確定済み注文の編集ロック |
| 購買契約有効化 | enable_purchase_agreements | 入力 | Toggle | - | - | false | 購買契約機能の有効化 |

## 表示項目

該当なし（設定画面のため入出力項目を参照）

## イベント仕様

### 1-注文承認有効化トグル変更

- 対象：「注文承認有効化」トグル
- 処理：
  1. ONに変更時：承認最小金額入力フィールドを表示
  2. OFFに変更時：承認最小金額入力フィールドを非表示
- 画面遷移：なし（ライブ更新）

### 2-保存ボタン押下

- 対象：フォーム保存
- 処理：
  1. 入力バリデーション実行
  2. OrderSettings設定を更新
  3. 成功通知を表示
- 画面遷移：なし（同画面に留まる）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 注文設定を更新 |

### テーブル別更新項目詳細

Spatie Laravel Settingsパッケージを使用しているため、settingsテーブルまたはキャッシュに保存されます。

#### OrderSettings（設定クラス）

| 操作 | 項目（プロパティ名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_order_approval | フォーム入力値 | 注文承認有効フラグ |
| UPDATE | order_validation_amount | フォーム入力値 | 承認最小金額 |
| UPDATE | enable_lock_confirmed_orders | フォーム入力値 | 確定注文ロックフラグ |
| UPDATE | enable_purchase_agreements | フォーム入力値 | 購買契約有効フラグ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 設定が保存されました | 保存成功時 |
| MSG-002 | エラー | 設定の保存に失敗しました | 保存エラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| バリデーションエラー | エラーメッセージを表示 | 各フィールドにエラー表示 |

## 備考

- SettingsPageを継承した設定画面
- HasPageShieldトレイトにより権限制御
- ナビゲーションアイコンはheroicon-o-shopping-cart
- URLスラッグはpurchase/manage-orders
- ナビゲーショングループは「Purchase」
- ナビゲーションソート順は1
- クラスターはSettings（共通設定）に属する
- OrderSettings設定クラスを使用
- 承認最小金額フィールドは注文承認有効化時のみ表示（live更新）
- 各設定項目にはヘルパーテキストで説明を表示
- 翻訳キーを使用してラベル・ヘルパーテキストを国際化対応
