# 画面設計書 27-請求書編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける請求書編集画面の設計仕様を定義します。この画面では既存の請求書（Invoice）の内容を編集し、更新します。

### 本画面の処理概要

**業務上の目的・背景**：
請求書編集は、発行前の下書き請求書の修正や、発行後の請求書に対する各種操作（確認、キャンセル、支払処理など）を行うための画面です。請求書のステータスに応じて編集可能な項目が制御され、業務フローに沿った適切な操作を提供します。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 「請求書」メニューを選択して一覧画面へ遷移
3. 一覧から編集したいレコードの編集アクションをクリック
4. または詳細画面からヘッダーの操作メニューを使用

**主要な操作・処理内容**：
1. 請求書情報の編集（下書きステータス時）
2. チャット/コメント機能（Chatter）
3. 支払処理（PayAction）
4. 確認/発行（ConfirmAction）
5. キャンセル（CancelAction）
6. 下書きに戻す（ResetToDraftAction）
7. 確認済みにする（SetAsCheckedAction）
8. プレビュー（PreviewAction）
9. 印刷・送信（PrintAndSendAction）
10. クレジットノート作成（CreditNoteAction）
11. 削除

**画面遷移**：
- 遷移元：請求書一覧画面、請求書詳細画面
- 遷移先：請求書詳細画面（保存成功時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。ステータスに応じて編集可能な項目が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-001 | 請求書管理 | 主機能 | 請求書の編集・更新 |
| FN-ACC-002 | 支払管理 | 補助機能 | 支払処理 |
| FN-ACC-003 | 会計仕訳 | 後処理 | 保存後の仕訳計算 |
| FN-ACC-004 | チャット機能 | 補助機能 | コメント・履歴管理 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/admin/accounts/invoices/{record}/edit`

## 画面構成

- ヘッダーアクション
  - チャット（ChatterAction）
  - 支払（PayAction）
  - 確認（ConfirmAction）
  - キャンセル（CancelAction）
  - 下書きに戻す（ResetToDraftAction）
  - 確認済みにする（SetAsCheckedAction）
  - プレビュー（PreviewAction）
  - 印刷・送信（PrintAndSendAction）
  - クレジットノート（CreditNoteAction）
  - 削除（DeleteAction）
- レコードナビゲーションタブ（前後レコード移動）
- ステータスステッパー
- 基本情報セクション
- タブ構成（請求明細、その他情報、利用規約）

## 入出力項目

請求書作成画面（No.26）と同様のフォーム構成です。ただし、ステータスに応じて以下の項目が無効化されます：

### ステータス別編集制御

| ステータス | 編集可能項目 | 無効化項目 |
|-----------|------------|-----------|
| DRAFT | 全項目 | なし |
| POSTED | 一部項目のみ | 顧客、請求日、明細、受取銀行口座、納品日、自動転記 |
| CANCEL | なし（表示のみ） | 全項目 |

### 追加項目（編集時のみ）

| 項目名 | 項目ID | 備考 |
|--------|--------|------|
| 顧客参照 | reference | 編集可能 |
| 担当者 | invoice_user_id | 編集可能 |
| 支払参照 | payment_reference | 編集可能 |
| 確認済み | checked | 編集可能 |

## 表示項目

作成画面と同様のフォーム表示。

## イベント仕様

### 1-保存ボタン押下

1. フォームバリデーション実行
2. `mutateFormDataBeforeSave`で以下を処理：
   - 未入力項目にレコードの既存値をフォールバック
   - 顧客選択時に関連項目（commercial_partner_id等）を自動設定
   - 未選択時はinvoice_partner_display_nameにユーザー名を設定
3. データベースを更新
4. `afterSave`でAccount::computeAccountMoveを実行（仕訳再計算）
5. 成功通知を表示
6. 詳細画面へリダイレクト

### 2-チャットボタン押下

1. Chatterコンポーネントを表示
2. コメント・履歴の閲覧・追加が可能

### 3-支払ボタン押下（PayAction）

1. 支払処理モーダルを表示
2. 支払情報を入力
3. 支払を記録

### 4-確認ボタン押下（ConfirmAction）

1. 請求書を確認/発行
2. ステータスをPOSTEDに変更
3. 仕訳を確定

### 5-キャンセルボタン押下（CancelAction）

1. 確認ダイアログ表示
2. ステータスをCANCELに変更

### 6-下書きに戻すボタン押下（ResetToDraftAction）

1. ステータスをDRAFTに戻す
2. 編集可能状態に復帰

### 7-確認済みにするボタン押下（SetAsCheckedAction）

1. checkedフラグをtrueに設定

### 8-プレビューボタン押下（PreviewAction）

1. 請求書のプレビュー画面を表示
2. テンプレート：accounts::invoice/actions/preview.index

### 9-印刷・送信ボタン押下（PrintAndSendAction）

1. 印刷/メール送信オプションを表示
2. 選択された方法で出力

### 10-クレジットノートボタン押下（CreditNoteAction）

1. この請求書に対するクレジットノート（返金伝票）を作成

### 11-削除ボタン押下

1. 確認ダイアログ表示
2. レコードを削除
3. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | account_moves | UPDATE | 請求書ヘッダーの更新 |
| 保存ボタン押下 | account_move_lines | UPDATE/INSERT/DELETE | 請求明細の更新 |
| 確認ボタン押下 | account_moves | UPDATE | ステータス変更、仕訳確定 |
| キャンセルボタン押下 | account_moves | UPDATE | ステータス変更 |
| 削除ボタン押下 | account_moves | DELETE | 請求書の削除 |

### テーブル別更新項目詳細

#### account_moves（UPDATE）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム入力値またはレコード既存値 | フォールバック |
| UPDATE | invoice_date | フォーム入力値またはレコード既存値 | フォールバック |
| UPDATE | name | フォーム入力値またはレコード既存値 | フォールバック |
| UPDATE | auto_post | フォーム入力値またはレコード既存値 | フォールバック |
| UPDATE | invoice_currency_rate | フォーム入力値または1.0 | デフォルト |
| UPDATE | commercial_partner_id | 顧客のID | 顧客選択時 |
| UPDATE | partner_shipping_id | 顧客のID | 顧客選択時 |
| UPDATE | invoice_partner_display_name | 顧客名またはユーザー名 | - |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| edit-invoice.notification.title | 成功 | 保存成功タイトル | 保存処理成功時 |
| edit-invoice.notification.body | 成功 | 保存成功メッセージ本文 | 保存処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| レコード未存在 | URLパラメータのrecordが存在しない場合 | 404エラーページを表示 |
| 権限不足 | 編集権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| ステータス不整合 | POSTED/CANCELステータスで編集不可項目を変更 | フィールドが無効化されているため入力不可 |
| バリデーションエラー | 必須項目未入力など | フォームにエラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装されている
- HasRecordNavigationTabs、HasRepeaterColumnManagerトレイトを使用
- ステータス（POSTED, CANCEL）に応じてフォームフィールドが無効化される
- afterSaveで仕訳計算（computeAccountMove）が再実行される
- ヘッダーアクションはInvoiceResource\Actionsから読み込まれる独自アクション
- チャット機能（Chatter）はWebkul\Chatterパッケージを使用
- プレビューはBladeテンプレートを使用
