# 画面設計書 270-商品設定

## 概要

本ドキュメントは、購買モジュールにおける商品設定画面の設計を記載しています。この画面では、商品に関するシステム設定を管理することができます。

### 本画面の処理概要

**業務上の目的・背景**：購買業務において、商品バリアント、単位（UOM）、パッケージング機能などの有効化は、商品管理の複雑さと柔軟性のバランスを決定する重要な設定です。この画面により、システム管理者が商品管理に関する動作設定を一元的に管理でき、組織のニーズに合わせた商品マスタ管理を実現できます。

**画面へのアクセス方法**：設定モジュール > Purchase > 商品 をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 商品バリアント機能の有効化/無効化
2. 単位（UOM）機能の有効化/無効化
3. パッケージング機能の有効化/無効化
4. パッケージング設定画面へのリンク
5. 設定の保存

**画面遷移**：
- 遷移元：設定モジュールのナビゲーション
- 遷移先：なし（設定保存後も同画面に留まる）、パッケージング設定画面（リンクあり）

**権限による表示制御**：
- HasPageShieldトレイトによる権限制御
- 設定モジュールへのアクセス権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PURCH-092 | 商品設定 | 主機能 | 商品の設定管理 |
| FN-PURCH-093 | パッケージング設定 | 関連機能 | パッケージング管理画面への遷移 |

## 画面種別

設定

## URL/ルーティング

`/admin/settings/purchase/manage-products`

## 画面構成

- パンくずリスト
  - 商品設定
- 設定フォームエリア
  - バリアント設定トグル
  - 単位（UOM）設定トグル
  - パッケージング設定トグル（リンク付き）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 型 | 必須 | 桁数 | 初期値 | 説明 |
|--------|--------|----------|-----|------|------|--------|------|
| バリアント有効化 | enable_variants | 入力 | Toggle | - | - | false | 商品バリアント機能の有効化 |
| 単位有効化 | enable_uom | 入力 | Toggle | - | - | false | 単位（UOM）機能の有効化 |
| パッケージング有効化 | enable_packagings | 入力 | Toggle | - | - | false | パッケージング機能の有効化 |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| パッケージング設定リンク | - | Link | パッケージング設定画面へのリンク（ヘルパーテキスト内） |

## イベント仕様

### 1-保存ボタン押下

- 対象：フォーム保存
- 処理：
  1. 入力バリデーション実行
  2. ProductSettings設定を更新
  3. 成功通知を表示
- 画面遷移：なし（同画面に留まる）

### 2-パッケージング設定リンククリック

- 対象：パッケージング設定リンク
- 処理：
  1. パッケージングリソース画面へ遷移
- 画面遷移：パッケージング設定画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | settings | UPDATE | 商品設定を更新 |

### テーブル別更新項目詳細

Spatie Laravel Settingsパッケージを使用しているため、settingsテーブルまたはキャッシュに保存されます。

#### ProductSettings（設定クラス）

| 操作 | 項目（プロパティ名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | enable_variants | フォーム入力値 | バリアント有効フラグ |
| UPDATE | enable_uom | フォーム入力値 | 単位有効フラグ |
| UPDATE | enable_packagings | フォーム入力値 | パッケージング有効フラグ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 成功 | 設定が保存されました | 保存成功時 |
| MSG-002 | エラー | 設定の保存に失敗しました | 保存エラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 権限不足 | 403エラー画面を表示 | アクセス権限がありません |
| バリデーションエラー | エラーメッセージを表示 | 各フィールドにエラー表示 |

## 備考

- SettingsPageを継承した設定画面
- HasPageShieldトレイトにより権限制御
- ナビゲーションアイコンはheroicon-o-cube
- URLスラッグはpurchase/manage-products
- ナビゲーショングループは「Purchase」
- ナビゲーションソート順は2
- クラスターはSettings（共通設定）に属する
- ProductSettings設定クラスを使用
- 各設定項目にはヘルパーテキストで説明を表示
- パッケージング設定のヘルパーテキストにはHTMLリンクを含む
- リンクはPackagingResourceのURLを動的に取得
- ルートが存在しない場合はリンク先を「#」に設定
- リンクにはFilamentのスタイルクラスを適用してUIの一貫性を維持
- 翻訳キーを使用してラベル・ヘルパーテキストを国際化対応
