# 画面設計書 271-応募者一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「応募者一覧」画面の設計を定義します。

### 本画面の処理概要

応募者一覧画面は、採用プロセスにおける応募者情報を一覧形式で表示・管理するための画面です。

**業務上の目的・背景**：採用活動において、複数の求人に対する応募者を効率的に管理することは重要です。本画面では、応募者のステータス、応募した職位、選考段階などを一覧で確認でき、採用担当者が迅速に選考状況を把握し、適切なアクションを取ることを支援します。採用プロセスの可視化により、優秀な人材の見逃しを防ぎ、採用活動の効率化を図ります。

**画面へのアクセス方法**：メインナビゲーションから「採用」モジュールを選択し、「応募」クラスターの「応募者」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 応募者データの一覧表示（テーブル形式、ステージごとのグループ表示）
2. 応募者の検索・フィルタリング（ソース、メディア、候補者、ステージ、職位など）
3. 新規応募者の作成（候補者を選択してモーダルから登録）
4. 応募者の詳細表示・編集・削除
5. プリセットビュー（マイ応募者、未アサイン、進行中、採用済み、不採用、アーカイブなど）による絞り込み
6. 一括削除・完全削除・復元操作

**画面遷移**：
- 遷移元：ダッシュボード、採用モジュールトップ
- 遷移先：応募者詳細画面、応募者編集画面、候補者一覧画面

**権限による表示制御**：recruiter_idによるマイ応募者フィルタリング、会社ごとのデータ分離（company_id）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-001 | 応募者一覧 | 主機能 | 応募者データの一覧表示と検索 |
| FN-REC-002 | 応募者作成 | 主機能 | 新規応募者の作成 |
| FN-REC-003 | 応募者編集 | 遷移先機能 | 既存応募者の編集 |
| FN-REC-004 | 応募者表示 | 遷移先機能 | 応募者詳細の表示 |
| FN-REC-005 | 候補者一覧 | 補助機能 | 候補者選択時の参照 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/admin/recruitments/applications/applicants`

## 画面構成

- ヘッダーウィジェット：JobPositionStatsWidget（職位別統計）
- プリセットビュータブ（マイ応募者、未アサイン、進行中、採用済み、不採用、アーカイブ、ブロック、即時対応可能、最近作成、ステージ更新済み）
- データテーブル（応募者リスト）
- ヘッダーアクション：新規応募者作成ボタン
- フィルター（QueryBuilder）
- グループ化オプション
- 一括アクションメニュー

## 入出力項目

### 新規作成モーダル

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 候補者 | candidate_id | select | ○ | 既存候補者から選択、または新規作成 |

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| パートナー名 | candidate.partner.name | text | 候補者のパートナー名 |
| 応募日 | create_date | date | 応募した日付 |
| 職位 | job.name | text | 応募した職位名 |
| ステージ | stage.name | text | 現在の選考ステージ（デフォルト非表示） |
| 候補者名 | candidate.name | text | 候補者名（デフォルト非表示） |
| 応募ステータス | application_status | badge | ONGOING/HIRED/REFUSED/ARCHIVED |
| 不採用理由 | refuseReason.name | text | 不採用理由（デフォルト非表示） |
| 評価 | priority | stars | 星評価（1-3） |
| タグ | categories.name | badge | 応募者カテゴリ（デフォルト非表示） |
| メール | candidate.email_from | text | 候補者のメール（デフォルト非表示） |
| 採用担当者 | recruiter.name | text | 担当リクルーター（デフォルト非表示） |
| 面接官 | interviewer.name | badge | 面接担当者（デフォルト非表示） |
| 電話番号 | candidate.phone | text | 候補者の電話番号（デフォルト非表示） |
| メディア | medium.name | badge | UTMメディア（デフォルト非表示） |
| ソース | source.name | badge | UTMソース（デフォルト非表示） |
| 希望給与 | salary_expected | number | 候補者の希望給与（デフォルト非表示） |
| 対応可能日 | candidate.availability_date | date | 候補者の対応可能日（デフォルト非表示） |

## イベント仕様

### 1-新規作成ボタン押下

候補者選択モーダルが表示されます。候補者を選択し確定すると、以下の処理が実行されます：
- 同一候補者・会社の既存応募者がある場合、既存レコードを再アクティブ化
- 新規の場合、応募者レコードを作成
- 作成後、編集画面へ自動遷移

### 2-プリセットビュー選択

選択したビューに応じてクエリが変更されます：
- マイ応募者：recruiter_id = ログインユーザーID
- 未アサイン：recruiter_id = NULL
- 進行中：削除なし、アクティブ、不採用理由なし、採用日なし
- 採用済み：date_closedあり
- 不採用：refuse_reason_idあり
- アーカイブ：deleted_atありまたはis_active = false

### 3-行アクション

| アクション | 処理 |
|-----------|------|
| 表示 | 応募者詳細画面へ遷移 |
| 編集 | 応募者編集画面へ遷移 |
| 復元 | ソフトデリートされたレコードを復元 |
| 削除 | ソフトデリート実行 |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | recruitments_applicants | INSERT/UPDATE | 応募者レコードの作成または再アクティブ化 |
| 削除 | recruitments_applicants | UPDATE | deleted_atの設定（ソフトデリート） |
| 復元 | recruitments_applicants | UPDATE | deleted_atのクリア |
| 完全削除 | recruitments_applicants | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### recruitments_applicants

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | candidate_id | 選択した候補者ID | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | company_id | ログインユーザーのデフォルト会社ID | 自動設定 |
| INSERT | create_date | 現在日時 | 自動設定 |
| INSERT | is_active | true | 自動設定 |
| UPDATE（再アクティブ化） | is_active | true | 既存レコード更新 |
| UPDATE（再アクティブ化） | deleted_at | null | 既存レコード更新 |
| UPDATE（再アクティブ化） | refuse_reason_id | null | 既存レコード更新 |
| UPDATE（再アクティブ化） | date_closed | null | 既存レコード更新 |
| UPDATE（再アクティブ化） | recruiter_id | ログインユーザーID | 既存レコード更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 応募者が正常に作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 応募者が正常に削除されました | 削除成功時 |
| MSG-003 | 成功 | 応募者が正常に復元されました | 復元成功時 |
| MSG-004 | 成功 | 選択した応募者が一括削除されました | 一括削除成功時 |
| MSG-005 | 成功 | 選択した応募者が完全に削除されました | 完全削除成功時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | エラー通知を表示し、空の一覧を表示 |
| 作成時の重複 | 既存レコードを再アクティブ化 |
| 削除時の関連データ存在 | 外部キー制約エラーの場合、エラーメッセージを表示 |

## 備考

- SoftDeletesトレイトを使用しており、論理削除をサポート
- HasTableViewsトレイトにより複数のプリセットビューを提供
- ステージ別グループ表示がデフォルト設定
- ブロック状態（state = BLOCKED）の応募者はデフォルトで非表示
