# 画面設計書 272-応募者編集

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「応募者編集」画面の設計を定義します。

### 本画面の処理概要

応募者編集画面は、既存の応募者情報を更新するための画面です。

**業務上の目的・背景**：採用プロセスが進むにつれて、応募者に関する情報は更新が必要になります。面接結果、評価の変更、ステージの更新、給与交渉の結果など、選考の各段階で得られた情報を記録し、最新の状態を維持することが重要です。本画面では、応募者の基本情報から詳細な選考情報まで包括的に編集できます。

**画面へのアクセス方法**：応募者一覧画面から対象の応募者の編集ボタンをクリック、または応募者詳細画面から編集アクションを実行してアクセスします。

**主要な操作・処理内容**：
1. 候補者情報の表示・更新（名前、メール、電話、LinkedIn）
2. 応募内容の更新（職位、部署、採用担当者、面接官）
3. 評価情報の更新（優先度/評価）
4. 給与情報の更新（希望給与、提示給与）
5. ステージの変更
6. 採用ステータスの管理（採用、不採用、アーカイブ、再開）
7. 従業員レコードの作成（採用確定時）

**画面遷移**：
- 遷移元：応募者一覧画面、応募者詳細画面
- 遷移先：応募者一覧画面、応募者詳細画面、スキル管理画面、活動管理画面

**権限による表示制御**：応募者のrecruiter_idとログインユーザーの関係による編集権限

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-003 | 応募者編集 | 主機能 | 応募者データの更新 |
| FN-REC-006 | 採用確定 | 主機能 | 採用ステータスの変更と従業員作成 |
| FN-REC-007 | 不採用処理 | 主機能 | 不採用ステータスの設定 |
| FN-REC-008 | アーカイブ処理 | 主機能 | 応募者のアーカイブ |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/admin/recruitments/applications/applicants/{record}/edit`

## 画面構成

- ページヘッダー（応募者名、サブナビゲーション）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：基本情報、職位情報、詳細セクション
  - 右カラム（1/3幅）：ステータス、リクルーター情報、給与情報
- フッターアクション（保存、キャンセル、各種ステータスアクション）
- サブナビゲーション（詳細、編集、スキル、活動）

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 候補者名 | candidate.name | text | ○ | 候補者の氏名（候補者テーブルを更新） |
| メール | candidate.email_from | email | - | 候補者のメールアドレス |
| 電話番号 | candidate.phone | tel | - | 候補者の電話番号 |
| LinkedIn | candidate.linkedin_profile | url | - | LinkedInプロフィールURL |

### 職位情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 職位 | job_id | select | - | 応募対象の職位 |
| 部署 | department_id | select | - | 配属予定の部署 |
| 会社 | company_id | select | - | 採用会社 |

### 詳細セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| タグ | recruitments_applicant_categories | multi-select | - | 応募者カテゴリ |
| ソース | source_id | select | - | UTMソース |
| メディア | medium_id | select | - | UTMメディア |

### ステータスセクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ステージ | stage_id | select | - | 現在の選考ステージ |
| 評価 | priority | placeholder | - | 星評価の表示（編集不可） |

### リクルーター情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 採用担当者 | recruiter_id | select | - | 担当リクルーター |
| 面接官 | recruitments_applicant_interviewers | multi-select | - | 面接担当者（複数選択可） |

### 給与情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 希望給与 | salary_expected | number | - | 候補者の希望給与 |
| 希望給与（その他） | salary_expected_extra | text | - | 追加の給与条件 |
| 提示給与 | salary_proposed | number | - | 会社側の提示給与 |
| 提示給与（その他） | salary_proposed_extra | text | - | 追加の給与条件 |

## イベント仕様

### 1-保存ボタン押下

フォームデータのバリデーションを実行し、問題なければrecruitments_applicantsテーブルと関連する候補者情報を更新します。

### 2-採用アクション実行

ヘッダーアクションの「採用」ボタンを押下すると以下の処理が実行されます：
- setAsHired()メソッドを呼び出し
- date_closedに現在日時を設定
- 通知表示
- 従業員レコード作成オプションを提供

### 3-従業員作成アクション実行

採用確定後、「従業員作成」ボタンで以下の処理を実行：
- createEmployee()メソッドを呼び出し
- Employeeテーブルに新規レコード作成
- 候補者のemployee_idを更新

### 4-不採用アクション実行

モーダルで不採用理由を選択し確定すると：
- setAsRefused()メソッドを呼び出し
- refuse_reason_idを設定
- refuse_dateに現在日時を設定

### 5-アーカイブアクション実行

- setAsArchived()メソッドを呼び出し
- is_activeをfalseに設定

### 6-再開アクション実行

- reopen()メソッドを呼び出し
- is_activeをtrueに設定
- refuse_reason_id、date_closedをクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | recruitments_applicants | UPDATE | 応募者情報の更新 |
| 保存 | recruitments_candidates | UPDATE | 候補者の基本情報更新 |
| 保存 | recruitments_applicant_applicant_categories | SYNC | カテゴリ関連の同期 |
| 保存 | recruitments_applicant_interviewers | SYNC | 面接官関連の同期 |
| 採用 | recruitments_applicants | UPDATE | date_closedの設定 |
| 従業員作成 | employees | INSERT | 従業員レコード作成 |
| 従業員作成 | recruitments_candidates | UPDATE | employee_idの設定 |
| 不採用 | recruitments_applicants | UPDATE | refuse_reason_id、refuse_dateの設定 |
| アーカイブ | recruitments_applicants | UPDATE | is_activeの設定 |

### テーブル別更新項目詳細

#### recruitments_applicants

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | job_id | フォーム入力値 | 職位 |
| UPDATE | department_id | フォーム入力値 | 部署 |
| UPDATE | company_id | フォーム入力値 | 会社 |
| UPDATE | source_id | フォーム入力値 | UTMソース |
| UPDATE | medium_id | フォーム入力値 | UTMメディア |
| UPDATE | stage_id | フォーム入力値 | ステージ |
| UPDATE | recruiter_id | フォーム入力値 | 採用担当者 |
| UPDATE | salary_expected | フォーム入力値 | 希望給与 |
| UPDATE | salary_expected_extra | フォーム入力値 | 希望給与その他 |
| UPDATE | salary_proposed | フォーム入力値 | 提示給与 |
| UPDATE | salary_proposed_extra | フォーム入力値 | 提示給与その他 |
| UPDATE | date_closed | 採用時：現在日時 | 採用日 |
| UPDATE | refuse_reason_id | 不採用時：選択した理由ID | 不採用理由 |
| UPDATE | refuse_date | 不採用時：現在日時 | 不採用日 |
| UPDATE | is_active | true/false | アーカイブ/再開時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 応募者が正常に更新されました | 保存成功時 |
| MSG-002 | 成功 | 応募者を採用しました | 採用処理成功時 |
| MSG-003 | 成功 | 従業員レコードが作成されました | 従業員作成成功時 |
| MSG-004 | 成功 | 応募者を不採用にしました | 不採用処理成功時 |
| MSG-005 | 成功 | 応募者をアーカイブしました | アーカイブ成功時 |
| MSG-006 | 成功 | 応募者を再開しました | 再開成功時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| バリデーションエラー | 該当フィールドにエラーメッセージを表示 |
| 従業員作成エラー（パートナーなし） | エラー通知を表示 |
| データベース更新失敗 | エラー通知を表示し、ロールバック |

## 備考

- 候補者情報（name, email_from, phone, linkedin_profile）はsaveRelationships()で候補者テーブルを直接更新
- ステージ変更時はdate_last_stage_updatedを自動更新
- HasChatter、HasLogActivityトレイトにより活動ログを自動記録
