# 画面設計書 273-応募者詳細

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「応募者詳細」画面の設計を定義します。

### 本画面の処理概要

応募者詳細画面は、応募者の詳細情報を閲覧専用で表示する画面です。

**業務上の目的・背景**：採用担当者や面接官が応募者の全体像を把握するために、詳細情報を一覧できる画面が必要です。本画面では、候補者の基本情報、応募した職位、選考ステージ、評価、給与情報などを一画面で確認でき、選考判断の参考資料として活用されます。

**画面へのアクセス方法**：応募者一覧画面から対象の応募者の表示ボタンをクリック、または各関連画面から応募者詳細リンクを選択してアクセスします。

**主要な操作・処理内容**：
1. 候補者基本情報の表示（名前、メール、電話、LinkedIn）
2. 応募内容の表示（職位、部署、会社）
3. 選考情報の表示（ステージ、ステータス、評価）
4. 給与情報の表示（希望給与、提示給与）
5. 担当者情報の表示（採用担当者、面接官）
6. 各種アクションの実行（採用、不採用、アーカイブ、再開）

**画面遷移**：
- 遷移元：応募者一覧画面、職位別求人一覧画面
- 遷移先：応募者編集画面、スキル管理画面、活動管理画面

**権限による表示制御**：閲覧権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-004 | 応募者表示 | 主機能 | 応募者詳細情報の表示 |
| FN-REC-006 | 採用確定 | 補助機能 | 採用アクションの実行 |
| FN-REC-007 | 不採用処理 | 補助機能 | 不採用アクションの実行 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/admin/recruitments/applications/applicants/{record}`

## 画面構成

- ページヘッダー（応募者名、サブナビゲーション）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：候補者情報、職位情報、追加情報
  - 右カラム（1/3幅）：選考情報、給与情報、ステータス
- ヘッダーアクション（編集、採用、不採用、アーカイブ、再開）
- サブナビゲーション（詳細、編集、スキル、活動）

## 表示項目

### 候補者情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 候補者名 | candidate.name | text | 候補者の氏名 |
| メール | candidate.email_from | text | メールアドレス（リンク付き） |
| 電話番号 | candidate.phone | text | 電話番号 |
| LinkedIn | candidate.linkedin_profile | link | LinkedInプロフィールURL |
| CC メール | email_cc | text | CCメールアドレス |
| メールバウンス | message_bounced | icon | メールバウンス状態 |

### 職位情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 職位 | job.name | text | 応募対象の職位 |
| 部署 | department.name | text | 配属予定の部署 |
| 会社 | company.name | text | 採用会社 |
| タグ | categories.name | badge | 応募者カテゴリ（バッジ表示） |

### ソース情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ソース | source.name | badge | UTMソース |
| メディア | medium.name | badge | UTMメディア |

### 選考情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ステージ | stage.name | text | 現在の選考ステージ |
| 応募ステータス | application_status | badge | ONGOING/HIRED/REFUSED/ARCHIVED |
| 評価 | priority | stars | 星評価（1-3） |
| 対応可能日 | candidate.availability_date | date | 候補者の対応可能日 |

### 担当者情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 採用担当者 | recruiter.name | text | 担当リクルーター |
| 面接官 | interviewer.name | badge | 面接担当者（複数表示） |

### 給与情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 希望給与 | salary_expected | number | 候補者の希望給与 |
| 希望給与（その他） | salary_expected_extra | text | 追加の給与条件 |
| 提示給与 | salary_proposed | number | 会社側の提示給与 |
| 提示給与（その他） | salary_proposed_extra | text | 追加の給与条件 |

## イベント仕様

### 1-編集ボタン押下

応募者編集画面へ遷移します。

### 2-採用アクション実行

ヘッダーアクションの「採用」ボタンを押下すると採用処理を実行し、date_closedを設定します。

### 3-従業員作成アクション実行

採用確定後、「従業員作成」ボタンでEmployeeテーブルに新規レコードを作成します。

### 4-不採用アクション実行

モーダルで不採用理由を選択し、refuse_reason_idを設定します。

### 5-アーカイブアクション実行

is_activeをfalseに設定し、応募者をアーカイブします。

### 6-再開アクション実行

is_activeをtrueに設定し、refuse_reason_id、date_closedをクリアして応募者を再開します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 採用 | recruitments_applicants | UPDATE | date_closedの設定 |
| 従業員作成 | employees | INSERT | 従業員レコード作成 |
| 従業員作成 | recruitments_candidates | UPDATE | employee_idの設定 |
| 不採用 | recruitments_applicants | UPDATE | refuse_reason_id、refuse_dateの設定 |
| アーカイブ | recruitments_applicants | UPDATE | is_activeの設定 |
| 再開 | recruitments_applicants | UPDATE | is_active、refuse_reason_id、date_closedの更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 応募者を採用しました | 採用処理成功時 |
| MSG-002 | 成功 | 従業員レコードが作成されました | 従業員作成成功時 |
| MSG-003 | 成功 | 応募者を不採用にしました | 不採用処理成功時 |
| MSG-004 | 成功 | 応募者をアーカイブしました | アーカイブ成功時 |
| MSG-005 | 成功 | 応募者を再開しました | 再開成功時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | 404エラーページを表示 |
| 従業員作成エラー | エラー通知を表示 |
| アクション実行失敗 | エラー通知を表示 |

## 備考

- プレースホルダーとして「—」を使用し、値がない場合に表示
- 各項目にはアイコンを設定し、視認性を向上
- priorityフィールドは星アイコンでカスタム表示
- application_statusはEnumからラベル・色・アイコンを取得して表示
- アクションボタンは現在のステータスに応じて表示/非表示を制御
