# 画面設計書 274-候補者一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「候補者一覧」画面の設計を定義します。

### 本画面の処理概要

候補者一覧画面は、採用プロセスにおける候補者（潜在的な応募者）を管理するための画面です。

**業務上の目的・背景**：候補者は、まだ特定の職位に応募していないが、将来的に採用対象となる可能性のある人材です。人材プールを構築・管理することで、適切な職位が空いた際に迅速に候補者へアプローチできます。本画面では、候補者の基本情報、スキル、評価などを一覧で管理し、タレントマネジメントを支援します。

**画面へのアクセス方法**：メインナビゲーションから「採用」モジュールを選択し、「応募」クラスターの「候補者」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 候補者データの一覧表示（カード形式、グリッドレイアウト）
2. 候補者の検索・フィルタリング（会社、パートナー、学歴、担当者）
3. 新規候補者の作成
4. 候補者の詳細表示・編集・削除
5. 担当者別グループ表示

**画面遷移**：
- 遷移元：ダッシュボード、採用モジュールトップ
- 遷移先：候補者詳細画面、候補者編集画面、候補者作成画面

**権限による表示制御**：manager_idによる担当者フィルタリング、会社ごとのデータ分離

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-009 | 候補者一覧 | 主機能 | 候補者データの一覧表示と検索 |
| FN-REC-010 | 候補者作成 | 遷移先機能 | 新規候補者の作成 |
| FN-REC-011 | 候補者編集 | 遷移先機能 | 既存候補者の編集 |
| FN-REC-012 | 候補者表示 | 遷移先機能 | 候補者詳細の表示 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/admin/recruitments/applications/candidates`

## 画面構成

- データテーブル（カード形式、グリッドレイアウト）
- ヘッダーアクション：新規候補者作成ボタン（作成画面へ遷移）
- フィルター（QueryBuilder）
- グループ化オプション（担当者別）
- 一括アクションメニュー

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 候補者名 | name | text | 候補者の氏名（太字表示） |
| タグ | categories.name | badge | 候補者カテゴリ（カラーバッジ表示） |
| 評価 | priority | stars | 星評価（1-3、カスタムHTML表示） |

## フィルター項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 会社 | company | relation | 所属会社でフィルタリング |
| パートナー | partner | relation | 関連パートナーでフィルタリング |
| 学歴 | degree | relation | 学歴でフィルタリング |
| 担当者 | manager | relation | 担当マネージャーでフィルタリング |

## グループ化オプション

| グループ名 | フィールド | 説明 |
|-----------|----------|------|
| 担当者名 | manager.name | 担当マネージャー別にグループ化 |

## イベント仕様

### 1-新規作成ボタン押下

候補者作成画面へ遷移します。

### 2-行アクション

| アクション | 処理 |
|-----------|------|
| 表示 | 候補者詳細画面へ遷移 |
| 編集 | 候補者編集画面へ遷移 |
| 削除 | 確認ダイアログ表示後、ソフトデリート実行 |

### 3-一括削除

選択した候補者を一括でソフトデリートします。

### 4-空状態アクション

候補者が存在しない場合、作成ボタンを表示し、クリックで候補者作成画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | recruitments_candidates | UPDATE | deleted_atの設定（ソフトデリート） |
| 一括削除 | recruitments_candidates | UPDATE | 複数レコードのdeleted_at設定 |

### テーブル別更新項目詳細

#### recruitments_candidates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE（ソフト） | deleted_at | 現在日時 | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 候補者が正常に削除されました | 削除成功時 |
| MSG-002 | 成功 | 選択した候補者が一括削除されました | 一括削除成功時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | エラー通知を表示し、空の一覧を表示 |
| 削除時の関連データ存在 | 外部キー制約エラーの場合、エラーメッセージを表示 |

## 備考

- グリッドレイアウト（md: 2列、xl: 3列）でカード形式表示
- タグはカテゴリの色に基づいてバッジ表示
- 評価は星アイコン（塗りつぶし/アウトライン）でカスタム表示
- SoftDeletesトレイトを使用しており、論理削除をサポート
- created_at降順がデフォルトソート
