# 画面設計書 275-候補者作成

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「候補者作成」画面の設計を定義します。

### 本画面の処理概要

候補者作成画面は、新規候補者を登録するための画面です。

**業務上の目的・背景**：人材紹介会社からの推薦、就職イベントでの接触、社内紹介など、様々な経路で候補者情報を入手します。これらの候補者を人材プールに登録することで、適切な職位が空いた際に迅速にアプローチできます。本画面では、候補者の基本情報、連絡先、学歴、担当者などを登録します。

**画面へのアクセス方法**：候補者一覧画面の新規作成ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 候補者基本情報の入力（氏名、メール、電話、LinkedIn）
2. 追加情報の入力（学歴、タグ、担当者、対応可能日）
3. ステータス・評価の設定
4. 候補者レコードの作成

**画面遷移**：
- 遷移元：候補者一覧画面
- 遷移先：候補者一覧画面（作成後）、候補者編集画面（作成後）

**権限による表示制御**：作成権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-010 | 候補者作成 | 主機能 | 新規候補者の登録 |
| FN-REC-009 | 候補者一覧 | 遷移元機能 | 一覧画面からのアクセス |

## 画面種別

作成画面（CreateRecord）

## URL/ルーティング

`/admin/recruitments/applications/candidates/create`

## 画面構成

- ページヘッダー（候補者作成タイトル）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：基本情報セクション、追加詳細セクション
  - 右カラム（1/3幅）：ステータス・評価セクション
- フッターアクション（作成、キャンセル）

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 作成者ID | creator_id | hidden | - | ログインユーザーID（自動設定） |
| 候補者名 | name | text | ○ | 候補者の氏名、最大255文字 |
| メール | email_from | email | - | メールアドレス、リアルタイムバリデーション |
| 電話番号 | phone | tel | - | 電話番号、最大255文字 |
| LinkedIn | linkedin_profile | url | - | LinkedInプロフィールURL、最大255文字 |

### 追加詳細セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 学歴 | degree_id | select | - | 学歴マスタから選択、検索可能 |
| タグ | recruitments_candidate_categories | multi-select | - | 候補者カテゴリ、複数選択可能 |
| 担当者 | manager_id | select | - | 担当マネージャー、ユーザーから選択 |
| 対応可能日 | availability_date | date | - | 候補者の対応可能日 |

### ステータス・評価セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ステータス | is_active | toggle | - | アクティブ/非アクティブ、デフォルトtrue |
| 評価 | evaluation | placeholder | - | 評価表示（作成時はデフォルト表示） |

## イベント仕様

### 1-作成ボタン押下

フォームデータのバリデーションを実行し、問題なければrecruitments_candidatesテーブルに新規レコードを作成します。
作成成功後、候補者一覧画面へ遷移し、成功通知を表示します。

### 2-パートナー自動作成

候補者保存時に、partner_idが未設定の場合、自動的にパートナーレコードを作成します：
- partnersテーブルに新規レコード作成
- candidate.partner_idを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | recruitments_candidates | INSERT | 候補者レコードの作成 |
| 作成 | partners | INSERT | パートナーレコードの自動作成 |
| 作成 | recruitments_candidate_applicant_categories | INSERT | カテゴリ関連の作成 |

### テーブル別更新項目詳細

#### recruitments_candidates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | email_from | フォーム入力値 | |
| INSERT | phone | フォーム入力値 | |
| INSERT | linkedin_profile | フォーム入力値 | |
| INSERT | degree_id | フォーム入力値 | |
| INSERT | manager_id | フォーム入力値 | |
| INSERT | availability_date | フォーム入力値 | |
| INSERT | is_active | フォーム入力値 | デフォルトtrue |
| INSERT | priority | 0 | デフォルト値 |

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | creator_id | ログインユーザーID | |
| INSERT | sub_type | 'partner' | 固定値 |
| INSERT | company_id | 候補者の会社ID | |
| INSERT | phone | 候補者の電話番号 | |
| INSERT | email | 候補者のメール | |
| INSERT | name | 候補者の名前 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 候補者が正常に作成されました | 作成成功時 |
| MSG-002 | エラー | 名前は必須です | 名前未入力時 |
| MSG-003 | エラー | 有効なメールアドレスを入力してください | メール形式不正時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| バリデーションエラー | 該当フィールドにエラーメッセージを表示 |
| データベース登録失敗 | エラー通知を表示 |
| パートナー作成失敗 | エラー通知を表示（候補者レコードはロールバック） |

## 備考

- email_fromフィールドはlive()バリデーションを使用
- パートナー作成はモデルのbootメソッドでsavedイベント時に自動実行
- 2カラムレイアウトを各セクション内で使用
- 評価フィールドは作成時は表示のみ（編集画面で更新可能）
