# 画面設計書 276-候補者編集

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「候補者編集」画面の設計を定義します。

### 本画面の処理概要

候補者編集画面は、既存の候補者情報を更新するための画面です。

**業務上の目的・背景**：候補者の情報は時間とともに変化します。連絡先の変更、学歴の追加、評価の更新など、最新の情報を維持することで、適切な職位のマッチングや候補者へのアプローチを効果的に行えます。

**画面へのアクセス方法**：候補者一覧画面から対象の候補者の編集ボタンをクリック、または候補者詳細画面から編集アクションを実行してアクセスします。

**主要な操作・処理内容**：
1. 候補者基本情報の更新（氏名、メール、電話、LinkedIn）
2. 追加情報の更新（学歴、タグ、担当者、対応可能日）
3. ステータス・評価の更新
4. 候補者レコードの保存

**画面遷移**：
- 遷移元：候補者一覧画面、候補者詳細画面
- 遷移先：候補者一覧画面、候補者詳細画面、スキル管理画面

**権限による表示制御**：編集権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-011 | 候補者編集 | 主機能 | 候補者データの更新 |
| FN-REC-009 | 候補者一覧 | 遷移元機能 | 一覧画面からのアクセス |
| FN-REC-012 | 候補者表示 | 遷移元機能 | 詳細画面からのアクセス |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/admin/recruitments/applications/candidates/{record}/edit`

## 画面構成

- ページヘッダー（候補者名、サブナビゲーション）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：基本情報セクション、追加詳細セクション
  - 右カラム（1/3幅）：ステータス・評価セクション
- フッターアクション（保存、キャンセル）
- サブナビゲーション（詳細、編集、スキル）

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 作成者ID | creator_id | hidden | - | 作成者ID（変更不可） |
| 候補者名 | name | text | ○ | 候補者の氏名、最大255文字 |
| メール | email_from | email | - | メールアドレス、リアルタイムバリデーション |
| 電話番号 | phone | tel | - | 電話番号、最大255文字 |
| LinkedIn | linkedin_profile | url | - | LinkedInプロフィールURL、最大255文字 |

### 追加詳細セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| 学歴 | degree_id | select | - | 学歴マスタから選択、検索可能 |
| タグ | recruitments_candidate_categories | multi-select | - | 候補者カテゴリ、複数選択可能 |
| 担当者 | manager_id | select | - | 担当マネージャー、ユーザーから選択 |
| 対応可能日 | availability_date | date | - | 候補者の対応可能日 |

### ステータス・評価セクション

| 項目名 | 項目ID | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| ステータス | is_active | toggle | - | アクティブ/非アクティブ |
| 評価 | evaluation | placeholder | - | 星評価表示（編集時は現在値を表示） |

## イベント仕様

### 1-保存ボタン押下

フォームデータのバリデーションを実行し、問題なければrecruitments_candidatesテーブルを更新します。
更新成功後、成功通知を表示します。

### 2-パートナー自動更新

候補者保存時に、関連パートナー情報を自動的に同期更新します：
- partnersテーブルのレコードを更新
- 名前、メール、電話、会社IDを同期

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | recruitments_candidates | UPDATE | 候補者レコードの更新 |
| 保存 | partners | UPDATE | パートナーレコードの同期更新 |
| 保存 | recruitments_candidate_applicant_categories | SYNC | カテゴリ関連の同期 |

### テーブル別更新項目詳細

#### recruitments_candidates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | email_from | フォーム入力値 | |
| UPDATE | phone | フォーム入力値 | |
| UPDATE | linkedin_profile | フォーム入力値 | |
| UPDATE | degree_id | フォーム入力値 | |
| UPDATE | manager_id | フォーム入力値 | |
| UPDATE | availability_date | フォーム入力値 | |
| UPDATE | is_active | フォーム入力値 | |

#### partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | phone | 候補者の電話番号 | 同期 |
| UPDATE | email | 候補者のメール | 同期 |
| UPDATE | name | 候補者の名前 | 同期 |
| UPDATE | company_id | 候補者の会社ID | 同期 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | 候補者が正常に更新されました | 更新成功時 |
| MSG-002 | エラー | 名前は必須です | 名前未入力時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| バリデーションエラー | 該当フィールドにエラーメッセージを表示 |
| データベース更新失敗 | エラー通知を表示 |
| パートナー更新失敗 | エラー通知を表示 |

## 備考

- HasLogActivityトレイトにより変更履歴を自動記録
- パートナー情報の同期はモデルのbootメソッドでsavedイベント時に実行
- サブナビゲーションで詳細、スキル管理画面へ遷移可能
- 評価フィールドは別途アクションで更新可能（priorityフィールド）
