# 画面設計書 277-候補者詳細

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「候補者詳細」画面の設計を定義します。

### 本画面の処理概要

候補者詳細画面は、候補者の詳細情報を閲覧専用で表示する画面です。

**業務上の目的・背景**：採用担当者が候補者の全体像を把握するために、詳細情報を一覧できる画面が必要です。本画面では、候補者の基本情報、連絡先、学歴、タグ、評価などを一画面で確認でき、職位マッチングや候補者へのアプローチの参考資料として活用されます。

**画面へのアクセス方法**：候補者一覧画面から対象の候補者の表示ボタンをクリック、または各関連画面から候補者詳細リンクを選択してアクセスします。

**主要な操作・処理内容**：
1. 候補者基本情報の表示（名前、メール、電話、LinkedIn）
2. 追加情報の表示（会社、学歴、タグ、担当者、対応可能日）
3. ステータス・評価の表示
4. コミュニケーション情報の表示（CCメール、メールバウンス状態）

**画面遷移**：
- 遷移元：候補者一覧画面
- 遷移先：候補者編集画面、スキル管理画面

**権限による表示制御**：閲覧権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-012 | 候補者表示 | 主機能 | 候補者詳細情報の表示 |
| FN-REC-011 | 候補者編集 | 遷移先機能 | 編集画面への遷移 |
| FN-REC-013 | スキル管理 | 遷移先機能 | スキル管理画面への遷移 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/admin/recruitments/applications/candidates/{record}`

## 画面構成

- ページヘッダー（候補者名、サブナビゲーション）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：基本情報セクション、追加詳細セクション
  - 右カラム（1/3幅）：ステータス・評価セクション、コミュニケーションセクション
- ヘッダーアクション（編集）
- サブナビゲーション（詳細、編集、スキル）

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 候補者名 | name | text | 候補者の氏名（アイコン付き） |
| 連絡先 | partner.name | text | 関連パートナー名 |
| メール | email_from | text | メールアドレス（アイコン付き） |
| 電話番号 | phone | text | 電話番号（アイコン付き） |
| LinkedIn | linkedin_profile | link | LinkedInプロフィールURL（リンク付き） |

### 追加詳細セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 会社 | company.name | text | 所属会社名（アイコン付き） |
| 学歴 | degree.name | text | 学歴（アイコン付き） |
| タグ | categories.name | badge | 候補者カテゴリ（カラーバッジ表示） |
| 担当者 | manager.name | text | 担当マネージャー（アイコン付き） |
| 対応可能日 | availability_date | date | 候補者の対応可能日（アイコン付き） |

### ステータス・評価セクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| ステータス | is_active | icon | アクティブ/非アクティブ（ブール値アイコン） |
| 評価 | priority | stars | 星評価（1-3、カスタムHTML表示） |

### コミュニケーションセクション

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| CC メール | email_cc | text | CCメールアドレス（アイコン付き） |
| メールバウンス | message_bounced | icon | メールバウンス状態（ブール値アイコン） |

## イベント仕様

### 1-編集ボタン押下

候補者編集画面へ遷移します。

### 2-サブナビゲーション操作

| 項目 | 遷移先 |
|------|--------|
| 詳細 | 現在の画面（候補者詳細） |
| 編集 | 候補者編集画面 |
| スキル | スキル管理画面 |

## データベース更新仕様

### 操作別データベース影響一覧

表示専用画面のため、データベース更新は発生しません。

## メッセージ仕様

表示専用画面のため、特定のメッセージ表示はありません。

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | 404エラーページを表示 |
| 権限エラー | 403エラーページを表示 |

## 備考

- プレースホルダーとして「—」を使用し、値がない場合に表示
- 各項目にはheroiconアイコンを設定し、視認性を向上
- priorityフィールドは星アイコン（塗りつぶし/アウトライン）でカスタムHTML表示
- タグはカテゴリの色に基づいてバッジ表示（Color::generateV3Palette使用）
- linkedin_profileはURLとして表示し、クリックで外部リンクへ遷移
- 2カラムレイアウトを各セクション内で使用
