# 画面設計書 278-職位別求人一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「職位別求人一覧」画面の設計を定義します。

### 本画面の処理概要

職位別求人一覧画面は、職位ごとの求人状況と応募者数を一覧表示する画面です。

**業務上の目的・背景**：採用活動を効率的に管理するためには、各職位の採用状況を一目で把握できることが重要です。本画面では、各職位に対する新規応募者数、総応募者数、採用予定人数などを一覧で確認でき、採用担当者が優先的に対応すべき職位を判断できます。

**画面へのアクセス方法**：メインナビゲーションから「採用」モジュールを選択し、「応募」クラスターの「職位別求人」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 職位ごとの求人状況表示（カード形式）
2. 新規応募者数の確認とクイックアクセス
3. 総応募者数の確認とクイックアクセス
4. 採用予定人数の編集
5. 職位検索・ソート

**画面遷移**：
- 遷移元：ダッシュボード、採用モジュールトップ
- 遷移先：応募者一覧画面（フィルター適用）

**権限による表示制御**：職位・応募者へのアクセス権限に基づく表示制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-014 | 職位別求人一覧 | 主機能 | 職位ごとの求人状況表示 |
| FN-REC-001 | 応募者一覧 | 遷移先機能 | 職位フィルター付き応募者一覧への遷移 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/admin/recruitments/applications/jobs-by-positions`

## 画面構成

- データテーブル（カード形式、グリッドレイアウト）
- 職位カード（名前、担当者、会社、アクションボタン）
- 検索・ソート機能

## 表示項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 職位名 | name | text | 職位名（太字表示） |
| 担当者 | department.manager.name | text | 部門マネージャー名（アイコン付き） |
| 会社 | company.name | text | 所属会社名（アイコン付き、値がある場合のみ表示） |

## アクションボタン

| アクション名 | 項目ID | 型 | 説明 |
|-------------|--------|-----|------|
| 新規応募者 | applications | button | 新規応募者数を表示、クリックでフィルター付き応募者一覧へ遷移 |
| 採用予定 | to_recruitment | button | 採用予定人数を表示、クリックで編集モーダルを開く |
| 総応募者 | total_applications | button | 総応募者数を表示、クリックで職位フィルター付き応募者一覧へ遷移 |

## イベント仕様

### 1-新規応募者ボタン押下

stage_id = 1（初期ステージ）かつ対象職位でフィルタリングされた応募者一覧画面へ遷移します。
遷移時のURLパラメータ：
```
tableFilters[queryBuilder][rules][dPtN][type]=stage
tableFilters[queryBuilder][rules][dPtN][data][operator]=isRelatedTo
tableFilters[queryBuilder][rules][dPtN][data][settings][values][]={1}
tableFilters[queryBuilder][rules][kwWd][type]=job
tableFilters[queryBuilder][rules][kwWd][data][operator]=isRelatedTo
tableFilters[queryBuilder][rules][kwWd][data][settings][values][]={record.id}
```

### 2-採用予定ボタン押下

職位の編集モーダルが表示され、採用予定人数（no_of_recruitment）を編集できます。
フォーム定義はJobPositionResourceから継承します。

### 3-総応募者ボタン押下

対象職位でフィルタリングされた応募者一覧画面へ遷移します。
遷移時のURLパラメータ：
```
tableFilters[queryBuilder][rules][kwWd][type]=job
tableFilters[queryBuilder][rules][kwWd][data][operator]=isRelatedTo
tableFilters[queryBuilder][rules][kwWd][data][settings][values][]={record.id}
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 採用予定編集 | employees_job_positions | UPDATE | 採用予定人数の更新 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | no_of_recruitment | フォーム入力値 | 採用予定人数 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 情報 | 新規応募 {count} | 新規応募者ボタンラベル |
| MSG-002 | 情報 | 採用予定 {count} | 採用予定ボタンラベル |
| MSG-003 | 情報 | 総応募者 {count} | 総応募者ボタンラベル |

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | エラー通知を表示し、空の一覧を表示 |
| 遷移先URLエラー | エラー通知を表示 |

## 備考

- グリッドレイアウト（md: 2列、xl: 2列）でカード形式表示
- JobPositionモデルを使用（employees_job_positionsテーブル）
- 応募者数はwithCountで取得：
  - new_applicants_count: stage_id = 1 のレコード数
  - total_applicants_count: 全応募者数
- フォーム・infolist定義はJobPositionResourceから継承
- ApplicationsクラスターのナビゲーションSort = 1
- 応募者一覧へのフィルター遷移はQueryBuilderフィルターを使用
