# 画面設計書 279-ステージ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「ステージ一覧」画面の設計を定義します。

### 本画面の処理概要

ステージ一覧画面は、採用プロセスにおける選考ステージを管理するための画面です。

**業務上の目的・背景**：採用プロセスは複数の選考段階（ステージ）で構成されます。例えば、「書類選考」「一次面接」「二次面接」「内定」などです。本画面では、これらのステージを定義・管理し、採用フローを体系的に構築できます。ステージの順序、状態ラベル、適用する職位などを設定することで、一貫した採用プロセスを実現します。

**画面へのアクセス方法**：メインナビゲーションから「採用」モジュールを選択し、「設定」クラスターの「ステージ」メニューをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ステージデータの一覧表示（テーブル形式）
2. ステージの検索・フィルタリング（名前、職位、作成者など）
3. 新規ステージの作成
4. ステージの詳細表示・編集・削除
5. ステージのドラッグ＆ドロップ並び替え
6. グループ化表示

**画面遷移**：
- 遷移元：採用設定トップ
- 遷移先：ステージ作成画面、ステージ詳細画面、ステージ編集画面

**権限による表示制御**：管理権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-015 | ステージ一覧 | 主機能 | ステージデータの一覧表示と検索 |
| FN-REC-016 | ステージ作成 | 遷移先機能 | 新規ステージの作成 |
| FN-REC-017 | ステージ編集 | 遷移先機能 | 既存ステージの編集 |
| FN-REC-018 | ステージ表示 | 遷移先機能 | ステージ詳細の表示 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/admin/recruitments/configurations/stages`

## 画面構成

- データテーブル（標準テーブル形式）
- ヘッダーアクション：新規ステージ作成ボタン
- フィルター（QueryBuilder）
- グループ化オプション
- 一括アクションメニュー
- 並び替え機能（ドラッグ＆ドロップ）

## 表示項目

| 項目名 | 項目ID | 型 | 表示設定 | 説明 |
|--------|--------|-----|---------|------|
| ID | id | number | 非表示（トグル可） | レコードID |
| ステージ名 | name | text | 表示 | ステージ名（検索・ソート可） |
| 職位 | jobs.name | badge | 表示 | 適用する職位（複数、バッジ表示） |
| デフォルトステージ | is_default | icon | 表示 | デフォルトステージフラグ |
| 折りたたみ | fold | icon | 表示 | 折りたたみフラグ |
| 採用ステージ | hired_stage | icon | 表示 | 採用ステージフラグ |
| 作成者 | createdBy.name | text | 非表示（トグル可） | 作成者名 |
| 作成日時 | created_at | datetime | 非表示（トグル可） | 作成日時 |
| 更新日時 | updated_at | datetime | 非表示（トグル可） | 更新日時 |

## フィルター項目

| 項目名 | 項目ID | 型 | 説明 |
|--------|--------|-----|------|
| 名前 | name | relation | ステージ名でフィルタリング |
| 職位 | jobs | relation | 職位でフィルタリング |
| 折りたたみ | fold | boolean | 折りたたみ状態でフィルタリング |
| グレーラベル | legend_normal | relation | グレーラベルでフィルタリング |
| 赤ラベル | legend_blocked | relation | 赤ラベルでフィルタリング |
| 緑ラベル | legend_done | relation | 緑ラベルでフィルタリング |
| 作成者 | createdBy | relation | 作成者でフィルタリング |
| 作成日 | created_at | date | 作成日でフィルタリング |
| 更新日 | updated_at | date | 更新日でフィルタリング |

## グループ化オプション

| グループ名 | フィールド | 説明 |
|-----------|----------|------|
| ステージ名 | name | ステージ名別にグループ化 |
| 折りたたみ | fold | 折りたたみ状態別にグループ化 |
| グレーラベル | legend_normal | グレーラベル別にグループ化 |
| 赤ラベル | legend_blocked | 赤ラベル別にグループ化 |
| 緑ラベル | legend_done | 緑ラベル別にグループ化 |
| 作成者 | createdBy.name | 作成者別にグループ化 |
| 作成日 | created_at | 作成日別にグループ化 |
| 更新日 | updated_at | 更新日別にグループ化 |

## イベント仕様

### 1-新規作成ボタン押下

ステージ作成画面へ遷移します。

### 2-行アクション

| アクション | 処理 |
|-----------|------|
| 表示 | ステージ詳細画面へ遷移 |
| 編集 | ステージ編集画面へ遷移 |
| 削除 | 確認ダイアログ表示後、削除実行 |

### 3-並び替え

ドラッグ＆ドロップでステージの順序を変更できます。sortフィールドが更新されます（降順）。

### 4-一括削除

選択したステージを一括で削除します。

### 5-空状態アクション

ステージが存在しない場合、作成ボタンを表示し、クリックでステージ作成画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | recruitments_stages | DELETE | ステージレコードの削除 |
| 並び替え | recruitments_stages | UPDATE | sortフィールドの更新 |
| 一括削除 | recruitments_stages | DELETE | 複数レコードの削除 |

### テーブル別更新項目詳細

#### recruitments_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（並び替え） | sort | 新しい順序値 | 降順 |
| DELETE | - | - | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | ステージが正常に削除されました | 削除成功時 |
| MSG-002 | エラー | このステージは使用中のため削除できません | 削除時の外部キー制約エラー |
| MSG-003 | 成功 | 選択したステージが一括削除されました | 一括削除成功時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| データ取得失敗 | エラー通知を表示し、空の一覧を表示 |
| 削除時の外部キー制約エラー | QueryExceptionをキャッチし、エラーメッセージを表示して処理をキャンセル |

## 備考

- reorderableColumnsによりカラム順序の変更が可能
- columnManagerColumns(2)により2列でカラム管理を表示
- 削除時はQueryExceptionをキャッチして外部キー制約エラーを処理
- Spatie\EloquentSortable\SortableTraitを使用した並び替え機能
- Configurationsクラスター所属、navigationSort = 1
- 職位はバッジ表示、値がない場合は「-」を表示
