# 画面設計書 28-請求書詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける請求書詳細画面の設計仕様を定義します。この画面では請求書（Invoice）の登録内容を閲覧し、各種操作を行います。

### 本画面の処理概要

**業務上の目的・背景**：
請求書詳細画面は、発行済みまたは下書きの請求書の内容を確認するための画面です。請求書の基本情報、明細、支払ステータス、その他情報を一覧表示し、ステータスに応じた各種操作（確認、支払、キャンセル等）を提供します。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 「請求書」メニューを選択して一覧画面へ遷移
3. 一覧から表示したいレコードをクリック、または表示アクションを選択
4. グローバル検索から請求書を検索してアクセス

**主要な操作・処理内容**：
1. 請求書情報の閲覧（読み取り専用）
2. チャット/コメント機能（Chatter）
3. 支払処理（PayAction）
4. 確認/発行（ConfirmAction）
5. キャンセル（CancelAction）
6. 下書きに戻す（ResetToDraftAction）
7. 確認済みにする（SetAsCheckedAction）
8. プレビュー（PreviewAction）
9. 印刷・送信（PrintAndSendAction）
10. クレジットノート作成（CreditNoteAction）
11. 削除

**画面遷移**：
- 遷移元：請求書一覧画面、グローバル検索
- 遷移先：請求書編集画面、請求書一覧画面（削除時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-001 | 請求書管理 | 主機能 | 請求書の詳細表示 |
| FN-ACC-002 | 支払管理 | 補助機能 | 支払処理 |
| FN-ACC-004 | チャット機能 | 補助機能 | コメント・履歴管理 |

## 画面種別

詳細（View）

## URL/ルーティング

`/admin/accounts/invoices/{record}`

## 画面構成

- ヘッダーアクション
  - チャット（ChatterAction）
  - 支払（PayAction）
  - 確認（ConfirmAction）
  - キャンセル（CancelAction）
  - 下書きに戻す（ResetToDraftAction）
  - 確認済みにする（SetAsCheckedAction）
  - プレビュー（PreviewAction）
  - 印刷・送信（PrintAndSendAction）
  - クレジットノート（CreditNoteAction）
  - 削除（DeleteAction）
- レコードナビゲーションタブ（前後レコード移動）
- 支払ステータスセクション（コンパクト表示）
- 基本情報セクション
  - 請求書番号
  - 顧客情報
  - 請求日・支払期日/支払条件
- タブ構成
  - 請求明細タブ（RepeatableEntry）
  - その他情報タブ（複数セクション）
  - 利用規約タブ

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン | 備考 |
|--------|--------|----------|----------|---------|------|
| 支払ステータス | payment_state | enum | バッジ | - | コンパクトセクション |
| 請求書番号 | name | string | テキスト | heroicon-o-document | 太字・大サイズ |
| 顧客 | partner.name | string | テキスト | heroicon-o-user | partner_idがある場合 |
| 顧客表示名 | invoice_partner_display_name | string | テキスト | heroicon-o-user | partner_idがない場合 |
| 請求日 | invoice_date | date | 日付 | heroicon-o-calendar | - |
| 支払期日 | invoice_date_due | date | 日付 | heroicon-o-clock | 支払条件未設定時 |
| 支払条件 | invoicePaymentTerm.name | string | テキスト | heroicon-o-calendar-days | 支払条件設定時 |

### 請求明細（RepeatableEntry）

| 項目名 | 項目ID | データ型 | 表示形式 | 備考 |
|--------|--------|----------|----------|------|
| 商品名 | name | string | テキスト | - |
| 数量 | quantity | decimal | テキスト | - |
| 単位 | uom.name | string | テキスト | UOM有効時のみ |
| 単価 | price_unit | decimal | 金額 | 通貨フォーマット |
| 割引率 | discount | decimal | パーセント | % |
| 税 | taxes | array | バッジ | 複数表示 |
| 小計 | price_subtotal | decimal | 金額 | 通貨フォーマット |

### その他情報タブ

#### 請求情報セクション

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| 顧客参照 | reference | string | テキスト | heroicon-o-hashtag |
| 担当者 | invoiceUser.name | string | テキスト | heroicon-o-user |
| 受取銀行口座 | partnerBank.account_number | string | テキスト | heroicon-o-building-library |
| 支払参照 | payment_reference | string | テキスト | heroicon-o-identification |
| 納品日 | delivery_date | date | 日付 | heroicon-o-truck |

#### 会計情報セクション

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| インコターム | invoiceIncoterm.name | string | テキスト | heroicon-o-globe-alt |
| インコターム場所 | incoterm_location | string | テキスト | heroicon-o-map-pin |
| 支払方法 | paymentMethodLine.name | string | テキスト | heroicon-o-credit-card |
| 自動転記 | auto_post | boolean | アイコン | heroicon-o-arrow-path |
| 確認済み | checked | boolean | アイコン | heroicon-o-check-circle |

#### 追加情報セクション

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| 会社 | company.name | string | テキスト | heroicon-o-building-office |
| 通貨 | currency.name | string | テキスト | heroicon-o-banknotes |

#### マーケティング情報セクション

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| キャンペーン | campaign.name | string | テキスト | heroicon-o-presentation-chart-line |
| メディア | medium.name | string | テキスト | heroicon-o-device-phone-mobile |
| ソース | source.name | string | テキスト | heroicon-o-link |

### 利用規約タブ

| 項目名 | 項目ID | データ型 | 表示形式 |
|--------|--------|----------|----------|
| 利用規約 | narration | text | HTML |

## イベント仕様

### 1-チャットボタン押下

1. Chatterコンポーネントを表示
2. コメント・履歴の閲覧・追加が可能

### 2-支払ボタン押下（PayAction）

1. 支払処理モーダルを表示
2. 支払情報を入力
3. 支払を記録

### 3-確認ボタン押下（ConfirmAction）

1. 請求書を確認/発行
2. ステータスをPOSTEDに変更

### 4-キャンセルボタン押下（CancelAction）

1. 確認ダイアログ表示
2. ステータスをCANCELに変更

### 5-下書きに戻すボタン押下（ResetToDraftAction）

1. ステータスをDRAFTに戻す

### 6-確認済みにするボタン押下（SetAsCheckedAction）

1. checkedフラグをtrueに設定

### 7-プレビューボタン押下（PreviewAction）

1. 請求書のプレビュー画面を表示

### 8-印刷・送信ボタン押下（PrintAndSendAction）

1. 印刷/メール送信オプションを表示

### 9-クレジットノートボタン押下（CreditNoteAction）

1. この請求書に対するクレジットノートを作成

### 10-削除ボタン押下

1. 確認ダイアログ表示
2. レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | account_moves | SELECT | 請求書情報の取得 |
| 画面表示 | account_move_lines | SELECT | 請求明細の取得 |
| 削除ボタン押下 | account_moves | DELETE | 請求書の削除 |
| 各アクション | account_moves | UPDATE | ステータス変更等 |

### テーブル別更新項目詳細

#### account_moves（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | id = URLパラメータのrecord | 全カラム取得 |

#### account_move_lines（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | move_id = 親レコードのID | リレーション経由 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| view-invoice.header-actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| view-invoice.header-actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| レコード未存在 | URLパラメータのrecordが存在しない場合 | 404エラーページを表示 |
| 権限不足 | 閲覧権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| リレーション先不在 | 参照先が削除されている場合 | プレースホルダー「-」を表示 |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装されている
- HasRecordNavigationTabs、HasRepeatableEntryColumnManagerトレイトを使用
- 請求明細はRepeatableEntryでテーブル形式表示
- 請求サマリーはInvoiceSummary Livewireコンポーネントで動的表示
- 各表示項目には値がない場合プレースホルダー「-」が表示される
- ヘッダーアクションは編集画面と同様の構成
- 削除アクションには成功通知が設定されている
- 金額は通貨に応じたフォーマットで表示
- 税は複数の場合バッジで並列表示
