# 画面設計書 280-ステージ作成

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける「ステージ作成」画面の設計を定義します。

### 本画面の処理概要

ステージ作成画面は、採用プロセスにおける新規選考ステージを登録するための画面です。

**業務上の目的・背景**：採用プロセスをカスタマイズするために、企業固有の選考ステージを定義する必要があります。例えば、技術面接、最終面接、リファレンスチェックなど、業務要件に応じたステージを追加することで、採用フローを最適化できます。

**画面へのアクセス方法**：ステージ一覧画面の新規作成ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ステージ基本情報の入力（ステージ名、要件説明）
2. ステータスラベルの設定（グレー/赤/緑ラベル）
3. 追加設定（適用職位、折りたたみ、採用ステージ、デフォルト設定）
4. ステージレコードの作成

**画面遷移**：
- 遷移元：ステージ一覧画面
- 遷移先：ステージ一覧画面（作成後）

**権限による表示制御**：管理権限のあるユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-REC-016 | ステージ作成 | 主機能 | 新規ステージの登録 |
| FN-REC-015 | ステージ一覧 | 遷移元機能 | 一覧画面からのアクセス |

## 画面種別

作成画面（CreateRecord）

## URL/ルーティング

`/admin/recruitments/configurations/stages/create`

## 画面構成

- ページヘッダー（ステージ作成タイトル）
- メインコンテンツエリア（3カラムレイアウト）
  - 左カラム（2/3幅）：一般情報セクション
  - 右カラム（1/3幅）：ツールチップセクション、追加情報セクション
- フッターアクション（作成、キャンセル）

## 入出力項目

### 一般情報セクション

| 項目名 | 項目ID | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| 作成者ID | creator_id | hidden | ○ | ログインユーザーID | 自動設定 |
| ステージ名 | name | text | ○ | - | ステージの名称 |
| 要件 | requirements | richEditor | - | - | このステージで必要な要件説明、最大255文字 |

### ツールチップセクション

このセクションでは、カンバンビューでの状態ラベルを定義します。

| 項目名 | 項目ID | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| グレーラベル | legend_normal | text | ○ | In Progress | 通常状態のラベル |
| 赤ラベル | legend_blocked | text | ○ | Blocked | ブロック状態のラベル |
| 緑ラベル | legend_done | text | ○ | Ready for Next Stage | 完了状態のラベル |

### 追加情報セクション

| 項目名 | 項目ID | 型 | 必須 | デフォルト値 | 説明 |
|--------|--------|-----|------|-------------|------|
| 職位 | recruitments_job_positions | multi-select | - | - | このステージを適用する職位（複数選択可） |
| 折りたたみ | fold | toggle | - | false | カンバンビューで折りたたんで表示するか |
| 採用ステージ | hired_stage | toggle | - | false | このステージが採用確定を意味するか |
| デフォルトステージ | is_default | toggle | - | false | 新規応募者のデフォルトステージとするか |

## イベント仕様

### 1-作成ボタン押下

フォームデータのバリデーションを実行し、問題なければrecruitments_stagesテーブルに新規レコードを作成します。
作成成功後、ステージ一覧画面へ遷移し、成功通知を表示します。

### 2-職位選択

recruitments_job_positionsフィールドで職位を選択すると、このステージがその職位の採用プロセスに適用されます。
職位を選択しない場合、全ての職位に適用されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成 | recruitments_stages | INSERT | ステージレコードの作成 |
| 作成 | recruitments_stages_jobs | INSERT | ステージと職位の関連レコード作成 |

### テーブル別更新項目詳細

#### recruitments_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | requirements | フォーム入力値 | リッチテキスト |
| INSERT | legend_normal | フォーム入力値 | デフォルト: In Progress |
| INSERT | legend_blocked | フォーム入力値 | デフォルト: Blocked |
| INSERT | legend_done | フォーム入力値 | デフォルト: Ready for Next Stage |
| INSERT | fold | フォーム入力値 | デフォルト: false |
| INSERT | hired_stage | フォーム入力値 | デフォルト: false |
| INSERT | is_default | フォーム入力値 | デフォルト: false |
| INSERT | sort | 自動計算値 | SortableTraitにより自動設定 |

#### recruitments_stages_jobs

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | stage_id | 作成されたステージID | 中間テーブル |
| INSERT | job_id | 選択された職位ID | 複数レコード |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG-001 | 成功 | ステージが正常に作成されました | 作成成功時 |
| MSG-002 | エラー | ステージ名は必須です | 名前未入力時 |
| MSG-003 | エラー | グレーラベルは必須です | legend_normal未入力時 |
| MSG-004 | エラー | 赤ラベルは必須です | legend_blocked未入力時 |
| MSG-005 | エラー | 緑ラベルは必須です | legend_done未入力時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| バリデーションエラー | 該当フィールドにエラーメッセージを表示 |
| データベース登録失敗 | エラー通知を表示 |

## 備考

- ツールチップセクションには説明文を設定：「カンバンビューでの各状態の意味を定義するためのラベル設定」
- 各ラベルフィールドにはヒントアイコンとツールチップを設定
- 2カラムレイアウトを一般情報セクション内で使用
- sort_when_creating = true により、作成時に自動的にソート順が設定される
- hired_stageがtrueのステージで採用処理を実行すると、応募者のdate_closedが設定される
