# 画面設計書 281-ステージ編集

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおけるステージ編集画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、採用プロセスにおけるステージ（選考段階）の情報を編集するための画面です。ステージ名、要件、ツールチップラベル、関連する職位などを変更できます。

**業務上の目的・背景**：採用活動では、応募者が様々な選考段階を経て採用に至ります。ステージ編集機能により、人事担当者は選考プロセスの各段階の名称や条件を状況に応じて柔軟に変更でき、採用業務の最適化を図ることができます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「ステージ」を選択し、一覧画面から編集したいステージの編集アクションをクリック、または詳細画面から編集ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. ステージ名の編集
2. 要件（Requirements）の編集
3. ツールチップラベル（グレー/赤/緑）の編集
4. 関連職位の変更
5. フォールド（折りたたみ）設定の変更
6. 採用ステージ設定の変更
7. デフォルトステージ設定の変更
8. ステージの削除

**画面遷移**：
- 本画面から遷移可能：ステージ詳細画面、ステージ一覧画面
- 本画面への遷移元：ステージ一覧画面、ステージ詳細画面

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ステージ管理 | 主機能 | ステージデータの編集・更新 |
| - | ステージ詳細 | 遷移先機能 | 編集後のステージ詳細表示 |
| - | ステージ削除 | 関連機能 | ステージの削除処理 |

## 画面種別

編集

## URL/ルーティング

`/recruitments/configurations/stages/{record}/edit`

## 画面構成

- ヘッダーエリア：画面タイトル、表示ボタン、削除ボタン
- メインエリア（左側2/3）：一般情報セクション
- サイドエリア（右側1/3）：ツールチップセクション、追加情報セクション
- フッターエリア：保存ボタン、キャンセルボタン

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | 作成者ID | creator_id | integer | ○ | - | Hidden | ログインユーザーID | - | 非表示項目 |
| 2 | ステージ名 | name | string | ○ | 255 | テキスト | - | required | - |
| 3 | 要件 | requirements | text | - | 255 | リッチエディタ | - | maxLength:255 | 全幅表示 |
| 4 | グレーラベル | legend_normal | string | ○ | 255 | テキスト | In Progress | required | ヒントアイコン付き |
| 5 | 赤ラベル | legend_blocked | string | ○ | 255 | テキスト | Blocked | required | ヒントアイコン付き |
| 6 | 緑ラベル | legend_done | string | ○ | 255 | テキスト | Ready for Next Stage | required | ヒントアイコン付き |
| 7 | 職位 | recruitments_job_positions | array | - | - | 複数選択 | - | - | リレーション |
| 8 | フォールド | fold | boolean | - | - | トグル | false | - | - |
| 9 | 採用ステージ | hired_stage | boolean | - | - | トグル | false | - | - |
| 10 | デフォルト | is_default | boolean | - | - | トグル | false | - | - |

## 表示項目

該当なし（編集画面のため入力項目として定義）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、recruitmentsテーブルのstagesレコードを更新し、成功時は通知を表示してステージ詳細画面へリダイレクトします。

### 2-表示ボタン押下

ヘッダーの「表示」ボタンを押下すると、該当レコードの詳細画面（ViewStages）へ遷移します。

### 3-削除ボタン押下

ヘッダーの「削除」ボタンを押下すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | recruitments_stages | UPDATE | ステージ情報の更新 |
| 保存ボタン押下 | recruitments_stages_jobs | SYNC | 職位との関連を同期 |
| 削除ボタン押下 | recruitments_stages | DELETE | ステージレコードの削除 |

### テーブル別更新項目詳細

#### recruitments_stages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | 入力値 | ステージ名 |
| UPDATE | requirements | 入力値 | 要件 |
| UPDATE | legend_normal | 入力値 | グレーラベル |
| UPDATE | legend_blocked | 入力値 | 赤ラベル |
| UPDATE | legend_done | 入力値 | 緑ラベル |
| UPDATE | fold | 入力値 | フォールド設定 |
| UPDATE | hired_stage | 入力値 | 採用ステージ設定 |
| UPDATE | is_default | 入力値 | デフォルト設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | ステージが更新されました | 更新成功時 |
| MSG-002 | 成功 | ステージが削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 更新処理中断 | システムエラーが発生しました |
| 関連データあり（削除時） | 削除処理キャンセル | このステージは使用中のため削除できません |

## 備考

- 本画面はFilament PHPのEditRecordを継承して実装されています
- 保存成功後はステージ詳細画面へ自動リダイレクトされます
- サブナビゲーションはクラスターのコンポーネントから動的に生成されます
