# 画面設計書 282-職位一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける職位一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、採用活動における職位（求人ポジション）を一覧形式で管理するための画面です。職位の検索、表示、新規作成、編集、削除といった基本的なCRUD操作を提供します。

**業務上の目的・背景**：採用活動において、どのような職位で人材を募集するかは重要な管理項目です。本画面により、人事担当者は各部署・会社の採用ポジションを一元管理し、採用活動の進捗状況を把握することができます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「職位」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 職位一覧の表示（職位名、部署、会社、ステータス等）
2. 検索・フィルター機能による職位の絞り込み
3. 「新規作成」ボタンから職位作成画面への遷移
4. 一覧行クリックによる詳細画面への遷移
5. 行アクションからの編集・削除・復元操作
6. 一括削除・復元操作
7. プリセットビュー（自部署・アーカイブ）による絞り込み

**画面遷移**：
- 本画面から遷移可能：職位作成画面、職位詳細画面、職位編集画面
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 職位一覧 | 主機能 | 職位データの一覧表示と検索 |
| - | 職位作成 | 遷移先機能 | 新規職位の作成 |
| - | 職位編集 | 遷移先機能 | 既存職位の編集 |
| - | 職位詳細 | 遷移先機能 | 職位の詳細表示 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/job-positions`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- プリセットビュータブ：自部署、アーカイブ
- テーブルエリア：職位一覧テーブル
- フィルターエリア：部署、雇用形態、会社、ステータス等
- 行アクション：表示、編集、削除、復元
- 一括操作エリア：一括削除、強制削除、一括復元

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | ID | id | integer | 職位ID | デフォルト非表示 |
| 2 | 職位名 | name | string | 職位の名称 | 検索可能 |
| 3 | 部署 | department.name | string | 所属部署名 | 検索可能 |
| 4 | 会社 | company.name | string | 会社名 | 検索可能 |
| 5 | 予定人数 | expected_employees | integer | 採用予定人数 | デフォルト非表示 |
| 6 | 現在人数 | no_of_employee | integer | 現在の従業員数 | デフォルト非表示 |
| 7 | ステータス | is_active | boolean | 有効/無効 | アイコン表示 |
| 8 | 作成者 | createdBy.name | string | 作成者名 | デフォルト非表示 |
| 9 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 10 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、職位作成画面（CreateJobPosition）へ遷移します。

### 2-行クリック（表示）

一覧の行をクリックまたは表示アクションを選択すると、該当レコードの詳細画面（ViewJobPosition）へ遷移します。

### 3-編集アクション

行の編集アクションを選択すると、該当レコードの編集画面（EditJobPosition）へ遷移します。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを論理削除します。成功時は通知メッセージが表示されます。

### 5-復元アクション

論理削除済みレコードの復元アクションを選択すると、レコードが復元されます。成功時は通知メッセージが表示されます。

### 6-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが論理削除されます。

### 7-一括復元

複数の論理削除済みレコードを選択し一括復元を実行すると、レコードが復元されます。

### 8-プリセットビュー切替

「自部署」タブを選択すると、ログインユーザーの所属部署の職位のみ表示されます。「アーカイブ」タブを選択すると、論理削除済みの職位のみ表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | employees_job_positions | SOFT DELETE | 選択した職位レコードを論理削除 |
| 復元アクション | employees_job_positions | UPDATE | deleted_atをnullに更新 |
| 一括削除 | employees_job_positions | SOFT DELETE | 選択した複数の職位レコードを論理削除 |
| 強制削除 | employees_job_positions | DELETE | 選択した複数の職位レコードを物理削除 |
| 一括復元 | employees_job_positions | UPDATE | 複数レコードのdeleted_atをnullに更新 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |
| DELETE | - | 主キー（id）で特定 | 物理削除 |
| UPDATE（復元） | deleted_at | null | 復元処理 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 職位が削除されました | 削除成功時 |
| MSG-002 | 成功 | 職位が復元されました | 復元成功時 |
| MSG-003 | 成功 | 職位が一括削除されました | 一括削除成功時 |
| MSG-004 | 成功 | 職位が強制削除されました | 強制削除成功時 |
| MSG-005 | 成功 | 職位が一括復元されました | 一括復元成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| データ取得失敗 | エラーページ表示 | システムエラーが発生しました |
| 削除失敗（関連データあり） | エラー通知表示 | この職位は使用中のため削除できません |
| 権限不足 | 操作拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- ベースクラスとして従業員モジュールのListJobPositionsを継承しています
- テーブルは並べ替え可能（sort列による昇順・降順）
- プリセットビューにより「自部署」「アーカイブ」での絞り込みが可能です
- ソフトデリート対応で、論理削除・復元が可能です
