# 画面設計書 283-職位作成

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける職位作成画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、採用活動における新規職位（求人ポジション）を作成するための画面です。職位名、部署、会社、リクルーター、面接官、職務内容などの情報を入力して新規職位を登録します。

**業務上の目的・背景**：新たな採用ニーズが発生した際、どのポジションで人材を募集するかを定義する必要があります。本画面により、人事担当者は詳細な職位情報を設定し、採用活動の土台を構築することができます。

**画面へのアクセス方法**：職位一覧画面の「新規作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 基本情報（職位名、部署、マネージャー、会社等）の入力
2. リクルーター・面接官の設定
3. 職務内容・応募要件の入力
4. 採用計画情報（採用目標人数、期間等）の入力
5. スキル・雇用形態の設定
6. 職位の有効/無効設定

**画面遷移**：
- 本画面から遷移可能：職位詳細画面（作成成功後）
- 本画面への遷移元：職位一覧画面

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 職位作成 | 主機能 | 新規職位データの登録 |
| - | 職位詳細 | 遷移先機能 | 作成後の詳細表示 |
| - | 部署作成 | 関連機能 | 部署の新規作成（モーダル） |
| - | 会社作成 | 関連機能 | 会社の新規作成（モーダル） |

## 画面種別

作成

## URL/ルーティング

`/recruitments/configurations/job-positions/create`

## 画面構成

- ヘッダーエリア：画面タイトル
- メインエリア（左側2/3）：雇用情報セクション、職務説明セクション
- サイドエリア（右側1/3）：期間設定、人員計画セクション
- フッターエリア：保存ボタン、キャンセルボタン

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | 職位名 | name | string | ○ | 255 | テキスト | - | required,max:255 | ヒントアイコン付き |
| 2 | 部署 | department_id | integer | - | - | セレクト | - | - | 新規作成可能 |
| 3 | マネージャー | manager_id | integer | - | - | セレクト | - | - | 部署選択時に自動設定 |
| 4 | 会社 | company_id | integer | - | - | セレクト | - | - | 新規作成可能 |
| 5 | リクルーター | recruiter_id | integer | - | - | セレクト | - | - | ユーザー新規作成可能 |
| 6 | 面接官 | recruitments_job_position_interviewers | array | - | - | 複数選択 | - | - | 複数選択可能 |
| 7 | 勤務地 | address_id | integer | - | - | セレクト | - | - | 新規作成可能 |
| 8 | 業種 | industry_id | integer | - | - | セレクト | - | - | 新規作成可能 |
| 9 | 職務内容 | description | text | - | - | リッチエディタ | - | - | 全幅表示 |
| 10 | 応募要件 | requirements | text | - | - | リッチエディタ | - | - | 全幅表示 |
| 11 | 開始日 | date_from | date | - | - | 日付選択 | - | - | - |
| 12 | 終了日 | date_to | date | - | - | 日付選択 | - | - | - |
| 13 | 採用目標人数 | no_of_recruitment | integer | - | - | 数値 | 0 | min:0,max:99999999999 | - |
| 14 | 現在人数 | no_of_employee | integer | - | - | 数値 | - | - | 読み取り専用 |
| 15 | 予定人数 | expected_employees | integer | - | - | 数値 | - | - | 読み取り専用 |
| 16 | 採用済人数 | no_of_hired_employee | integer | - | - | 数値 | - | - | 読み取り専用 |
| 17 | 必要スキル | job_position_skills | array | - | - | 複数選択 | - | - | 複数選択可能 |
| 18 | 雇用形態 | employment_type_id | integer | - | - | セレクト | - | - | - |
| 19 | ステータス | is_active | boolean | - | - | トグル | true | - | - |

## 表示項目

該当なし（作成画面のため入力項目として定義）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、職位レコードを新規作成し、成功時は通知を表示して職位詳細画面へリダイレクトします。

### 2-部署選択変更

部署を選択すると、選択した部署に紐づくマネージャーと会社が自動的にセットされます（未設定の場合のみ）。

### 3-部署新規作成

部署セレクトの新規作成ボタンを押下すると、部署作成モーダルが表示されます。

### 4-会社新規作成

会社セレクトの新規作成ボタンを押下すると、会社作成モーダルが表示されます。

### 5-リクルーター新規作成

リクルーターセレクトの新規作成ボタンを押下すると、ユーザー作成モーダルが表示されます。

### 6-勤務地新規作成

勤務地セレクトの新規作成ボタンを押下すると、住所作成モーダルが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | employees_job_positions | INSERT | 職位レコードの新規作成 |
| 保存ボタン押下 | recruitments_job_position_interviewers | INSERT | 面接官の関連登録 |
| 保存ボタン押下 | job_position_skills | INSERT | スキルの関連登録 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 職位名 |
| INSERT | department_id | 入力値 | 部署ID |
| INSERT | company_id | 入力値 | 会社ID |
| INSERT | manager_id | 入力値 | マネージャーID |
| INSERT | recruiter_id | 入力値 | リクルーターID |
| INSERT | address_id | 入力値 | 勤務地ID |
| INSERT | industry_id | 入力値 | 業種ID |
| INSERT | description | 入力値 | 職務内容 |
| INSERT | requirements | 入力値 | 応募要件 |
| INSERT | date_from | 入力値 | 開始日 |
| INSERT | date_to | 入力値 | 終了日 |
| INSERT | no_of_recruitment | 入力値 | 採用目標人数 |
| INSERT | employment_type_id | 入力値 | 雇用形態ID |
| INSERT | is_active | 入力値 | ステータス |
| INSERT | creator_id | ログインユーザーID | 作成者ID |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 職位が作成されました | 作成成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 作成処理中断 | システムエラーが発生しました |
| 必須項目未入力 | 保存処理中断 | 必須項目を入力してください |

## 備考

- 本画面はFilament PHPのCreateRecordを継承して実装されています
- ベースクラスとして従業員モジュールのCreateJobPositionを継承しています
- 保存成功後は職位詳細画面へ自動リダイレクトされます
- 部署選択時にマネージャーと会社が自動設定される連動機能があります
- 各セレクトフィールドから関連データの新規作成が可能です
