# 画面設計書 284-職位編集

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける職位編集画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、既存の職位（求人ポジション）情報を編集するための画面です。職位名、部署、会社、リクルーター、面接官、職務内容などの情報を変更できます。

**業務上の目的・背景**：採用活動中に職位の条件変更や要件の見直しが発生することがあります。本画面により、人事担当者は職位情報を柔軟に更新し、最新の採用ニーズに対応することができます。

**画面へのアクセス方法**：職位一覧画面から編集アクションをクリック、または職位詳細画面から編集ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 基本情報（職位名、部署、マネージャー、会社等）の編集
2. リクルーター・面接官の変更
3. 職務内容・応募要件の編集
4. 採用計画情報（採用目標人数、期間等）の変更
5. スキル・雇用形態の変更
6. 職位の有効/無効設定の変更

**画面遷移**：
- 本画面から遷移可能：職位詳細画面（更新成功後）
- 本画面への遷移元：職位一覧画面、職位詳細画面

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 職位編集 | 主機能 | 職位データの更新 |
| - | 職位詳細 | 遷移先機能 | 更新後の詳細表示 |
| - | 部署作成 | 関連機能 | 部署の新規作成（モーダル） |
| - | 会社作成 | 関連機能 | 会社の新規作成（モーダル） |

## 画面種別

編集

## URL/ルーティング

`/recruitments/configurations/job-positions/{record}/edit`

## 画面構成

- ヘッダーエリア：画面タイトル
- メインエリア（左側2/3）：雇用情報セクション、職務説明セクション
- サイドエリア（右側1/3）：期間設定、人員計画セクション
- フッターエリア：保存ボタン、キャンセルボタン

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | 職位名 | name | string | ○ | 255 | テキスト | 既存値 | required,max:255 | ヒントアイコン付き |
| 2 | 部署 | department_id | integer | - | - | セレクト | 既存値 | - | 新規作成可能 |
| 3 | マネージャー | manager_id | integer | - | - | セレクト | 既存値 | - | - |
| 4 | 会社 | company_id | integer | - | - | セレクト | 既存値 | - | 新規作成可能 |
| 5 | リクルーター | recruiter_id | integer | - | - | セレクト | 既存値 | - | ユーザー新規作成可能 |
| 6 | 面接官 | recruitments_job_position_interviewers | array | - | - | 複数選択 | 既存値 | - | 複数選択可能 |
| 7 | 勤務地 | address_id | integer | - | - | セレクト | 既存値 | - | 新規作成可能 |
| 8 | 業種 | industry_id | integer | - | - | セレクト | 既存値 | - | 新規作成可能 |
| 9 | 職務内容 | description | text | - | - | リッチエディタ | 既存値 | - | 全幅表示 |
| 10 | 応募要件 | requirements | text | - | - | リッチエディタ | 既存値 | - | 全幅表示 |
| 11 | 開始日 | date_from | date | - | - | 日付選択 | 既存値 | - | - |
| 12 | 終了日 | date_to | date | - | - | 日付選択 | 既存値 | - | - |
| 13 | 採用目標人数 | no_of_recruitment | integer | - | - | 数値 | 既存値 | min:0,max:99999999999 | - |
| 14 | 現在人数 | no_of_employee | integer | - | - | 数値 | 既存値 | - | 読み取り専用 |
| 15 | 予定人数 | expected_employees | integer | - | - | 数値 | 既存値 | - | 読み取り専用 |
| 16 | 採用済人数 | no_of_hired_employee | integer | - | - | 数値 | 既存値 | - | 読み取り専用 |
| 17 | 必要スキル | job_position_skills | array | - | - | 複数選択 | 既存値 | - | 複数選択可能 |
| 18 | 雇用形態 | employment_type_id | integer | - | - | セレクト | 既存値 | - | - |
| 19 | ステータス | is_active | boolean | - | - | トグル | 既存値 | - | - |

## 表示項目

該当なし（編集画面のため入力項目として定義）

## イベント仕様

### 1-保存ボタン押下

フォームの入力値をバリデーション後、職位レコードを更新し、成功時は通知を表示して職位詳細画面へリダイレクトします。更新後、レコードがリフレッシュされます。

### 2-部署選択変更

部署を選択すると、選択した部署に紐づくマネージャーと会社が自動的にセットされます（未設定の場合のみ）。

### 3-部署新規作成

部署セレクトの新規作成ボタンを押下すると、部署作成モーダルが表示されます。

### 4-会社新規作成

会社セレクトの新規作成ボタンを押下すると、会社作成モーダルが表示されます。

### 5-リクルーター新規作成

リクルーターセレクトの新規作成ボタンを押下すると、ユーザー作成モーダルが表示されます。

### 6-勤務地新規作成

勤務地セレクトの新規作成ボタンを押下すると、住所作成モーダルが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | employees_job_positions | UPDATE | 職位レコードの更新 |
| 保存ボタン押下 | recruitments_job_position_interviewers | SYNC | 面接官の関連を同期 |
| 保存ボタン押下 | job_position_skills | SYNC | スキルの関連を同期 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | 入力値 | 職位名 |
| UPDATE | department_id | 入力値 | 部署ID |
| UPDATE | company_id | 入力値 | 会社ID |
| UPDATE | manager_id | 入力値 | マネージャーID |
| UPDATE | recruiter_id | 入力値 | リクルーターID |
| UPDATE | address_id | 入力値 | 勤務地ID |
| UPDATE | industry_id | 入力値 | 業種ID |
| UPDATE | description | 入力値 | 職務内容 |
| UPDATE | requirements | 入力値 | 応募要件 |
| UPDATE | date_from | 入力値 | 開始日 |
| UPDATE | date_to | 入力値 | 終了日 |
| UPDATE | no_of_recruitment | 入力値 | 採用目標人数 |
| UPDATE | employment_type_id | 入力値 | 雇用形態ID |
| UPDATE | is_active | 入力値 | ステータス |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 職位が更新されました | 更新成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 更新処理中断 | システムエラーが発生しました |
| レコード未発見 | 404エラー | 指定された職位が見つかりません |

## 備考

- 本画面はFilament PHPのEditRecordを継承して実装されています
- ベースクラスとして従業員モジュールのEditJobPositionを継承しています
- 保存成功後は職位詳細画面へ自動リダイレクトされます
- mutateFormDataBeforeFillとmutateFormDataBeforeSaveで計算フィールド（no_of_employee, no_of_hired_employee, expected_employees）が処理されます
- afterSaveでレコードがリフレッシュされます
