# 画面設計書 285-職位詳細

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける職位詳細画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、職位（求人ポジション）の詳細情報を参照表示するための画面です。職位の基本情報、人員計画、職務内容などを確認できます。

**業務上の目的・背景**：採用活動において職位の詳細を確認することは重要です。本画面により、人事担当者や関係者は職位の条件、要件、現在の採用状況を一目で把握することができます。

**画面へのアクセス方法**：職位一覧画面から行クリックまたは表示アクション、職位作成/編集完了後の自動遷移でアクセスします。

**主要な操作・処理内容**：
1. 職位基本情報の参照
2. 人員計画情報（目標人数、現在人数等）の参照
3. 職務内容・応募要件の参照
4. 編集ボタンから編集画面への遷移
5. 削除ボタンによる職位の削除

**画面遷移**：
- 本画面から遷移可能：職位編集画面
- 本画面への遷移元：職位一覧画面、職位作成画面、職位編集画面

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 職位詳細 | 主機能 | 職位データの詳細表示 |
| - | 職位編集 | 遷移先機能 | 詳細からの編集 |
| - | 職位削除 | 関連機能 | 職位の削除処理 |

## 画面種別

詳細

## URL/ルーティング

`/recruitments/configurations/job-positions/{record}`

## 画面構成

- ヘッダーエリア：画面タイトル、編集ボタン、削除ボタン
- メインエリア（左側2/3）：雇用情報セクション、職務説明セクション
- サイドエリア（右側1/3）：人員計画セクション

## 入出力項目

該当なし（詳細画面のため表示項目として定義）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | 職位名 | name | string | 職位の名称 | アイコン付き |
| 2 | 部署 | department.name | string | 所属部署名 | アイコン付き |
| 3 | 会社 | company.name | string | 会社名 | アイコン付き |
| 4 | リクルーター | recruiter.name | string | 担当リクルーター名 | アイコン付き |
| 5 | 面接官 | interviewers | array | 面接官リスト | - |
| 6 | 勤務地 | address.name | string | 勤務地 | アイコン付き |
| 7 | 業種 | industry.name | string | 業種名 | アイコン付き |
| 8 | 職務内容 | description | text | 職務の説明 | HTML表示 |
| 9 | 応募要件 | requirements | text | 応募に必要な要件 | HTML表示 |
| 10 | 予定人数 | expected_employees | integer | 採用予定の合計人数 | アイコン付き |
| 11 | 現在人数 | no_of_employee | integer | 現在のポジション人数 | アイコン付き |
| 12 | 採用目標 | no_of_recruitment | integer | 採用目標人数 | アイコン付き |
| 13 | 採用済人数 | no_of_hired_employee | integer | 採用済みの人数 | アイコン付き |
| 14 | 雇用形態 | employmentType.name | string | 雇用形態名 | アイコン付き |
| 15 | ステータス | is_active | boolean | 有効/無効 | アイコン表示 |

## イベント仕様

### 1-編集ボタン押下

ヘッダーの「編集」ボタンを押下すると、該当レコードの編集画面（EditJobPosition）へ遷移します。

### 2-削除ボタン押下

ヘッダーの「削除」ボタンを押下すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示され、一覧画面へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | employees_job_positions | DELETE | 職位レコードの削除 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | 主キー（id）で特定 | 論理削除の場合はdeleted_atを更新 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 職位が削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| レコード未発見 | 404エラー | 指定された職位が見つかりません |
| 削除失敗 | エラー通知表示 | 削除に失敗しました |

## 備考

- 本画面はFilament PHPのViewRecordを継承して実装されています
- ベースクラスとして従業員モジュールのViewJobPositionを継承しています
- 3カラムレイアウトで表示され、左側2カラムにメイン情報、右側1カラムに人員計画を表示
- 職務内容と応募要件はHTML形式で表示されます
- 各項目はアイコン付きで視認性を高めています
