# 画面設計書 286-部署一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける部署一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、組織内の部署を一覧表示し管理するための画面です。部署の検索、表示、新規作成、編集、削除といった基本的なCRUD操作を提供します。

**業務上の目的・背景**：採用活動においては、どの部署で人材を募集するかを明確にする必要があります。本画面により、人事担当者は組織の部署構成を把握し、採用計画と連携した部署管理を行うことができます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「部署」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 部署一覧のカード形式表示（部署名、マネージャー、会社）
2. 検索・フィルター機能による部署の絞り込み
3. 「新規作成」ボタンから部署作成画面への遷移
4. カードクリックによる詳細画面への遷移
5. 行アクションからの編集・削除・復元操作
6. 一括削除・復元操作

**画面遷移**：
- 本画面から遷移可能：部署作成画面、部署詳細画面、部署編集画面
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 部署一覧 | 主機能 | 部署データの一覧表示と検索 |
| - | 部署作成 | 遷移先機能 | 新規部署の作成 |
| - | 部署編集 | 遷移先機能 | 既存部署の編集 |
| - | 部署詳細 | 遷移先機能 | 部署の詳細表示 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/departments`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- カードグリッドエリア：部署カード一覧（2列×3列のグリッド）
- フィルターエリア：部署名、マネージャー、会社、作成日時等
- カードアクション：表示、編集、削除、復元、強制削除
- 一括操作エリア：一括復元、一括削除、強制一括削除

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | マネージャーアバター | manager.partner.avatar | image | マネージャーの画像 | 円形、35px |
| 2 | 部署名 | name | string | 部署の名称 | 太字表示 |
| 3 | マネージャー名 | manager.name | string | 部署マネージャー名 | ブリーフケースアイコン |
| 4 | 会社名 | company.name | string | 所属会社名 | ビルアイコン |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、部署作成画面（CreateDepartment）へ遷移します。

### 2-カードクリック（表示）

カードをクリックまたは表示アクションを選択すると、該当部署の詳細画面（ViewDepartment）へ遷移します。

### 3-編集アクション

カードの編集アクションを選択すると、該当部署の編集画面（EditDepartment）へ遷移します。

### 4-削除アクション

カードの削除アクションを選択すると、確認ダイアログ表示後、該当レコードを論理削除します。成功時は通知メッセージが表示されます。

### 5-復元アクション

論理削除済みレコードの復元アクションを選択すると、レコードが復元されます。成功時は通知メッセージが表示されます。

### 6-強制削除アクション

論理削除済みレコードの強制削除アクションを選択すると、レコードが物理削除されます。成功時は通知メッセージが表示されます。

### 7-一括復元

複数の論理削除済みレコードを選択し一括復元を実行すると、レコードが復元されます。

### 8-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが論理削除されます。

### 9-強制一括削除

複数の論理削除済みレコードを選択し強制一括削除を実行すると、レコードが物理削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション | employees_departments | SOFT DELETE | 選択した部署レコードを論理削除 |
| 復元アクション | employees_departments | UPDATE | deleted_atをnullに更新 |
| 強制削除アクション | employees_departments | DELETE | レコードを物理削除 |
| 一括削除 | employees_departments | SOFT DELETE | 選択した複数の部署レコードを論理削除 |
| 強制一括削除 | employees_departments | DELETE | 選択した複数の部署レコードを物理削除 |
| 一括復元 | employees_departments | UPDATE | 複数レコードのdeleted_atをnullに更新 |

### テーブル別更新項目詳細

#### employees_departments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SOFT DELETE | deleted_at | 現在日時 | 論理削除 |
| DELETE | - | 主キー（id）で特定 | 物理削除 |
| UPDATE（復元） | deleted_at | null | 復元処理 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 部署が削除されました | 削除成功時 |
| MSG-002 | 成功 | 部署が復元されました | 復元成功時 |
| MSG-003 | 成功 | 部署が強制削除されました | 強制削除成功時 |
| MSG-004 | 成功 | 部署が一括復元されました | 一括復元成功時 |
| MSG-005 | 成功 | 部署が一括削除されました | 一括削除成功時 |
| MSG-006 | 成功 | 部署が強制一括削除されました | 強制一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| データ取得失敗 | エラーページ表示 | システムエラーが発生しました |
| 削除失敗（関連データあり） | エラー通知表示 | この部署は使用中のため削除できません |
| 権限不足 | 操作拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- ベースクラスとして従業員モジュールのListDepartmentsを継承しています
- カードグリッド形式で表示（md: 2列、xl: 3列）
- ソフトデリート対応で、論理削除・復元・強制削除が可能です
- 部署の階層表示には詳細画面のヒエラルキーツリーを使用します
