# 画面設計書 287-学位一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける学位一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、応募者の学歴資格として登録可能な学位マスタを一覧管理するための画面です。学士、修士、博士などの学位を登録・編集・削除できます。

**業務上の目的・背景**：採用活動において、応募者の学歴は重要な評価基準の一つです。本画面により、人事担当者は学位マスタを管理し、応募者情報入力時の選択肢を整備することができます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「学位」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 学位一覧の表示
2. 新規学位の作成（モーダル）
3. 既存学位の編集（モーダル）
4. 学位の削除
5. 学位のドラッグ&ドロップによる並べ替え

**画面遷移**：
- 本画面から遷移可能：なし（モーダル内で完結）
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 学位管理 | 主機能 | 学位データのCRUD操作 |
| - | 応募者管理 | 関連機能 | 応募者の学歴入力で使用 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/degrees`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：学位一覧テーブル
- 行アクション：表示（モーダル）、編集（モーダル）、削除
- 一括操作エリア：一括削除

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | 学位名 | name | string | ○ | 255 | テキスト | - | required,max:255 | プレースホルダーあり |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | ID | id | integer | 学位ID | デフォルト非表示 |
| 2 | 学位名 | name | string | 学位の名称 | 検索・ソート可能 |
| 3 | 作成者 | createdBy.name | string | 作成者名 | デフォルト非表示 |
| 4 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 5 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、学位作成モーダルが表示されます。名前を入力して保存すると学位が登録されます。

### 2-表示アクション

行の表示アクションを選択すると、学位の詳細情報がモーダルで表示されます。

### 3-編集アクション

行の編集アクションを選択すると、学位編集モーダルが表示されます。内容を変更して保存すると学位が更新されます。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

### 6-ドラッグ&ドロップ並べ替え

テーブル行をドラッグ&ドロップすることで、学位の表示順序を変更できます。sort列が自動更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | recruitments_degrees | INSERT | 学位レコードの新規作成 |
| 編集 | recruitments_degrees | UPDATE | 学位レコードの更新 |
| 削除アクション | recruitments_degrees | DELETE | 選択した学位レコードを削除 |
| 一括削除 | recruitments_degrees | DELETE | 選択した複数の学位レコードを削除 |
| 並べ替え | recruitments_degrees | UPDATE | sort列の更新 |

### テーブル別更新項目詳細

#### recruitments_degrees

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 学位名 |
| INSERT | sort | 自動設定 | 並び順 |
| INSERT | creator_id | ログインユーザーID | 作成者 |
| UPDATE | name | 入力値 | 学位名 |
| UPDATE | sort | ドラッグ位置 | 並び順 |
| DELETE | - | 主キー（id）で特定 | 削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 学位が作成されました | 作成成功時 |
| MSG-002 | 成功 | 学位が更新されました | 更新成功時 |
| MSG-003 | 成功 | 学位が削除されました | 削除成功時 |
| MSG-004 | 成功 | 学位が一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 処理中断 | システムエラーが発生しました |
| 削除失敗（使用中） | エラー通知表示 | この学位は使用中のため削除できません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- 作成・編集・表示はモーダルで行われ、画面遷移は発生しません
- ドラッグ&ドロップによる並べ替えは降順（sort desc）で反映されます
- Spatie EloquentSortableパッケージを使用しています
