# 画面設計書 288-応募者カテゴリ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける応募者カテゴリ一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、応募者を分類するためのカテゴリ（タグ）を一覧管理するための画面です。カテゴリ名と識別用の色を設定できます。

**業務上の目的・背景**：採用活動において、応募者を適切に分類・整理することは効率的な選考プロセスの実現に重要です。本画面により、人事担当者は応募者のカテゴリ分けに使用するタグを管理できます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「応募者カテゴリ」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 応募者カテゴリ一覧の表示
2. 新規カテゴリの作成（モーダル）
3. 既存カテゴリの編集（モーダル）
4. カテゴリの削除
5. カテゴリのドラッグ&ドロップによる並べ替え

**画面遷移**：
- 本画面から遷移可能：なし（モーダル内で完結）
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 応募者カテゴリ管理 | 主機能 | カテゴリデータのCRUD操作 |
| - | 応募者管理 | 関連機能 | 応募者へのカテゴリ付与で使用 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/applicant-categories`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：カテゴリ一覧テーブル
- 行アクション：表示（モーダル）、編集（モーダル）、削除
- 一括操作エリア：一括削除

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | カテゴリ名 | name | string | ○ | 255 | テキスト | - | required,max:255 | プレースホルダーあり |
| 2 | 色 | color | string | ○ | - | カラーピッカー | - | required,hexColor | HEX形式 |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | ID | id | integer | カテゴリID | デフォルト非表示 |
| 2 | カテゴリ名 | name | string | カテゴリの名称 | 検索・ソート可能 |
| 3 | 色 | color | string | カテゴリの色 | カラー表示 |
| 4 | 作成者 | createdBy.name | string | 作成者名 | デフォルト非表示 |
| 5 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 6 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、カテゴリ作成モーダルが表示されます。名前と色を入力して保存するとカテゴリが登録されます。作成者IDは自動的にログインユーザーが設定されます。

### 2-表示アクション

行の表示アクションを選択すると、カテゴリの詳細情報がモーダルで表示されます。

### 3-編集アクション

行の編集アクションを選択すると、カテゴリ編集モーダルが表示されます。内容を変更して保存するとカテゴリが更新されます。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

### 6-ドラッグ&ドロップ並べ替え

テーブル行をドラッグ&ドロップすることで、カテゴリの表示順序を変更できます。sort列が自動更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | recruitments_applicant_categories | INSERT | カテゴリレコードの新規作成 |
| 編集 | recruitments_applicant_categories | UPDATE | カテゴリレコードの更新 |
| 削除アクション | recruitments_applicant_categories | DELETE | 選択したカテゴリレコードを削除 |
| 一括削除 | recruitments_applicant_categories | DELETE | 選択した複数のカテゴリレコードを削除 |
| 並べ替え | recruitments_applicant_categories | UPDATE | sort列の更新 |

### テーブル別更新項目詳細

#### recruitments_applicant_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | カテゴリ名 |
| INSERT | color | 入力値 | カテゴリ色（HEX） |
| INSERT | creator_id | ログインユーザーID | 作成者 |
| UPDATE | name | 入力値 | カテゴリ名 |
| UPDATE | color | 入力値 | カテゴリ色（HEX） |
| DELETE | - | 主キー（id）で特定 | 削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | カテゴリが作成されました | 作成成功時 |
| MSG-002 | 成功 | カテゴリが更新されました | 更新成功時 |
| MSG-003 | 成功 | カテゴリが削除されました | 削除成功時 |
| MSG-004 | 成功 | カテゴリが一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 処理中断 | システムエラーが発生しました |
| 削除失敗（使用中） | エラー通知表示 | このカテゴリは使用中のため削除できません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- 作成・編集・表示はモーダルで行われ、画面遷移は発生しません
- カラーピッカーでHEX形式の色を選択できます
- ドラッグ&ドロップによる並べ替えは降順（sort desc）で反映されます
- 作成時にcreator_idが自動的にログインユーザーに設定されます（mutateDataUsing）
