# 画面設計書 289-雇用形態一覧

## 概要

本ドキュメントは、Aureus ERPシステムの採用モジュールにおける雇用形態一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、雇用形態（正社員、契約社員、パートタイムなど）のマスタを一覧管理するための画面です。雇用形態名、コード、対象国などを設定できます。

**業務上の目的・背景**：採用活動において、どのような雇用形態で人材を募集するかは重要な情報です。本画面により、人事担当者は雇用形態マスタを管理し、職位や応募者情報での雇用形態選択を整備することができます。

**画面へのアクセス方法**：採用モジュールの設定メニューから「雇用形態」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 雇用形態一覧の表示
2. 新規雇用形態の作成（モーダル）
3. 既存雇用形態の編集（モーダル）
4. 雇用形態の削除
5. 雇用形態のドラッグ&ドロップによる並べ替え
6. グループ化表示（名前、コード、国など）

**画面遷移**：
- 本画面から遷移可能：なし（モーダル内で完結）
- 本画面への遷移元：採用モジュール設定メニュー

**権限による表示制御**：採用モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 雇用形態管理 | 主機能 | 雇用形態データのCRUD操作 |
| - | 職位管理 | 関連機能 | 職位の雇用形態選択で使用 |
| - | 従業員管理 | 関連機能 | 従業員情報での雇用形態設定 |

## 画面種別

一覧

## URL/ルーティング

`/recruitments/configurations/employment-types`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- テーブルエリア：雇用形態一覧テーブル
- フィルターエリア：名前、国、作成者、作成日時等
- グループ化：名前、コード、国、作成者、日時
- 行アクション：表示（モーダル）、編集（モーダル）、削除
- 一括操作エリア：一括削除

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 最大桁数 | 入力形式 | デフォルト値 | バリデーション | 備考 |
|----|--------|--------|-----|------|----------|----------|--------------|----------------|------|
| 1 | 作成者ID | creator_id | integer | ○ | - | Hidden | ログインユーザーID | - | 非表示 |
| 2 | 名称 | name | string | ○ | 255 | テキスト | - | required,max:255 | リアルタイム更新 |
| 3 | コード | code | string | - | - | テキスト | - | - | - |
| 4 | 国 | country_id | integer | - | - | セレクト | - | - | 検索・プリロード可能 |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | ID | id | integer | 雇用形態ID | デフォルト非表示 |
| 2 | 名称 | name | string | 雇用形態の名称 | 検索・ソート可能 |
| 3 | コード | code | string | 雇用形態コード | 検索・ソート可能 |
| 4 | 国 | country.name | string | 対象国名 | 検索・ソート可能 |
| 5 | 作成者 | createdBy.name | string | 作成者名 | デフォルト非表示 |
| 6 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 7 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーまたはエンプティステートの「+」アイコン付きボタンを押下すると、雇用形態作成モーダルが表示されます。名称、コード、国を入力して保存すると雇用形態が登録されます。

### 2-表示アクション

行の表示アクションを選択すると、雇用形態の詳細情報がモーダルで表示されます。

### 3-編集アクション

行の編集アクションを選択すると、雇用形態編集モーダルが表示されます。コードが未入力の場合は名前が自動設定されます。

### 4-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードを削除します。成功時は通知メッセージが表示されます。

### 5-一括削除

複数行を選択し一括削除を実行すると、選択されたすべてのレコードが削除されます。

### 6-ドラッグ&ドロップ並べ替え

テーブル行をドラッグ&ドロップすることで、雇用形態の表示順序を変更できます。sort列が自動更新されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | employees_employment_types | INSERT | 雇用形態レコードの新規作成 |
| 編集 | employees_employment_types | UPDATE | 雇用形態レコードの更新 |
| 削除アクション | employees_employment_types | DELETE | 選択した雇用形態レコードを削除 |
| 一括削除 | employees_employment_types | DELETE | 選択した複数の雇用形態レコードを削除 |
| 並べ替え | employees_employment_types | UPDATE | sort列の更新 |

### テーブル別更新項目詳細

#### employees_employment_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力値 | 雇用形態名 |
| INSERT | code | 入力値 or 名前 | コード |
| INSERT | country_id | 入力値 | 国ID |
| INSERT | creator_id | ログインユーザーID | 作成者 |
| INSERT | sort | 自動設定 | 並び順 |
| UPDATE | name | 入力値 | 雇用形態名 |
| UPDATE | code | 入力値 or 名前 | コード |
| UPDATE | country_id | 入力値 | 国ID |
| UPDATE | sort | ドラッグ位置 | 並び順 |
| DELETE | - | 主キー（id）で特定 | 削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 雇用形態が作成されました | 作成成功時 |
| MSG-002 | 成功 | 雇用形態が更新されました | 更新成功時 |
| MSG-003 | 成功 | 雇用形態が削除されました | 削除成功時 |
| MSG-004 | 成功 | 雇用形態が一括削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| バリデーションエラー | 該当フィールドにエラー表示 | 各フィールドのバリデーションメッセージ |
| データベースエラー | 処理中断 | システムエラーが発生しました |
| 削除失敗（使用中） | エラー通知表示 | この雇用形態は使用中のため削除できません |

## 備考

- 本画面はFilament PHPのListRecordsを継承して実装されています
- ベースクラスとして従業員モジュールのEmploymentTypeResourceを継承しています
- 作成・編集・表示はモーダルで行われ、画面遷移は発生しません
- ドラッグ&ドロップによる並べ替えは降順（sort desc）で反映されます
- 編集時にコードが未入力の場合、名前が自動的にコードとして設定されます（mutateDataUsing）
- グループ化機能で名前、コード、国、作成者、作成日時、更新日時でグループ表示可能
